/*
 * File: data.h
 * Author: Douglas Selph
 * Date: Mar 1993
 *    Extracted from the Machine archive
 * Purpose:
 */
#ifndef DATA_H
#define DATA_H

#define COMPUTE_CARGO(c,t) (g_galaxy_version >= 3 ? ((c)+((c)*(c)/10.0)) : (c*t))

#define TEST_SLOT 0
#define TEST_RACE 0

#define MAX_CARGO -1.0

#define ERROR_NAME "??"
#define UNKNOWN_NAME "?"
#define MAX_RNAME 80

#define RACE_NEW -3
#define RACE_ERR -2
#define RACE_ALL -1

#define DATA_ALL 0
#define DATA_GROUPS 1
#define DATA_PLANETS 2
#define DATA_SHIPS 3

#define CURRENT_TECH	0
#define OVERRIDE_TECH   1

#define CAPITAL_NAME      "Capital"
#define RAW_MAT_NAME      "Raw Materials"
#define RESEARCH_NAME     "Research"
#define SHIPS_NAME        "Ships"
#define TECH_LEVEL        "Tech Level"

#define YOUR_PLANETS 	"Your Planets"
#define PLANETS 	"Planets"
#define ALIEN_PLANETS 	"Unidentified Planets"
#define NEUTRAL_PLANETS "Uninhabited Planets"
#define SHIP_TYPES 	"Ship Types"
#define GROUPS 		"Groups"
#define YOUR 		"Your"
#define ABBR_GROUPS 	"List Of"
#define REPORT_TITLE 	"Report for"
#define YOUR_ROUTES 	"Your Routes"
#define BATTLE_AT 	"Battle at"
#define SAMPLE_BATTLE 	"Sample Battle"
#define AT_WAR 		"At War"
#define DESTROYED 	"Destroyed"
#define STATUS_OF 	"Status of Players"
#define FLEET 		"Fleet"
#define RESULTS 	"Results"

#define CAPITAL   1
#define RAW_MAT   2
#define RESEARCH  3
#define SHIPS     4

#define PR_CAP		0
#define PR_MAT		1
#define PR_DRIVE	2
#define PR_WEAPONS	3
#define PR_SHIELDS	4
#define PR_CARGO	5

#define WHO_NOID	0
#define WHO_ME		1
#define WHO_ALIEN	2
#define WHO_NOONE	3
#define WHO_FRIEND	4
#define WHO_NOONE_SEEN	5

#define TYPE_INVALID		0
#define TYPE_UNIDENTIFIED	1
#define TYPE_UNINHABITED	2
#define TYPE_SHIPS		3
#define TYPE_YOUR_PLANETS	4
#define TYPE_YOUR_GROUPS        5
#define TYPE_YOUR_ABBR_GROUPS	6
#define TYPE_ALIEN_GROUPS       7
#define TYPE_ALIEN_ABBR_GROUPS  8
#define TYPE_PLANETS  		9  
#define TYPE_ROUTES  		10
#define TYPE_NEW_RACE		11
#define TYPE_RACE_LINE		12
#define TYPE_BATTLE_AT		13
#define TYPE_DESTROYED		14
#define TYPE_STATUS_OF		15
#define TYPE_SAMPLE_BATTLE	16
#define TYPE_AT_WAR		17
#define TYPE_RESULTS		18

#define OPT_PLANET_ID		0
#define OPT_PLANET_SIZE		1
#define OPT_PLANET_RES		2
#define OPT_PLANET_DIST		3

#define WITH_TITLE 1
#define NO_TITLE 0

#define BATTLE_DIST		-1

char *get_planet_name();
char *get_produce_name();
char *get_who_name();

double planet_dist();
double planet_xy_dist();
int element_int();
char *element_str();
char *get_ship_name();
float element_float();
float calc_num_ships();
float get_ship_mass();
float get_planet_x();
float get_planet_y();
char *get_ship_title();
float get_planet_res();
float get_planet_size();
char *getGroupSaveFile();
char *get_race_name();
char *getTmpFilename();
float weapon_mass();
float compute_num_ships();
float compute_estimate();
char *askstr();
float get_ship_eff_defense();
double frand2();

#endif
