static char    *rcsid = "$Header: /navy/homes/zeus/SRC/RCS/new-game.c,v 2.42 1994/05/17 13:43:15 bampton Exp bampton $";

/*
 * $Log: new-game.c,v $
 * Revision 2.42  1994/05/17  13:43:15  bampton
 * *** empty log message ***
 *
 * Revision 2.41  1994/04/08  03:11:28  bampton
 * Revision 2.40  1994/03/09  20:22:55  bampton
 * Revision 2.38  1993/09/27  17:15:54  bampton
 * Revision 2.37  1993/09/07  20:50:32  bampton
 * Revision 2.33  1993/08/03  23:10:13  bampton
 * Revision 2.30  1993/07/14  14:59:26  bampton
 * Revision 0.0  1993/07/14  13:42:19  bampton RCS
 * prototype.
 * 
 */

#define NOTIMEB

#include "common.h"
#include "prot.h"
#include "protos/new-game.h"

void name_game_rcsid (void);
extern planet  *planets;
extern double   galaxysize;

void
new_game_rcsid (void)
{
  printf ("%s\n",rcsid);
}

#ifndef PREPROC
void
set_spice (planet * p)
{
  double          spice;

  spice = frand (10.0);
  if (spice > 9.8)              /* double-planet system */
  {
    p->size = frand (MAXPOP) + MAXPOP;
    /* double-planet system */
    p->resources = frand (10.0);/* higher resource than average */
  }
  else if (spice > 5.0)         /* normal system */
  {
    p->size = frand (MAXPOP);
    p->resources = pow (10.0, (double) (frand (2.0) - 1.0));
  }
  else if (spice > 4.0)         /* minor but resource-rich */
  {
    p->size = frand (MAXPOP / 5.0) + 50.0;      /* minor, resource-rich */
    p->resources = frand (6.0) + 4.0;
  }
  else if (spice > .7)          /* very tiny, bad resources */
  {
    p->size = frand (MAXPOP / 50.0);    /* very minor, resource-poor */
    p->resources = pow (2.0, (double) (frand (2.0) - 1.0));
  }
  else
  {                             /* unsettleable */
    p->size = 0.0;
    p->resources = 0.0;
  }

  p->pop = p->ind = 0.0;
}

#ifdef NEWGAME
planet         *
addplanet (void)
{
  planet         *p;
  int             i;

  for (p = planets, i = 0; p; p = p->next, i++);
  p = alloc (sizeof (planet));
  memset (p, 0, sizeof (planet));
  addlist (&planets, p);
  p->producing = PR_CAP;
  sprintf (p->name, "%d", i);
  sprintf (p->num, "%d", i);
  return p;
}

void
create_galaxy ()
{
  int             nstdplanets;
  int             nplanets, i;
  struct planetstruct *p;

  /* Seed random number genorator... */
  srandom ((time (NULL)) % 32768);

#ifdef GAMENAME
  printf ("Name of game?");
  getstr();
  strcpy(gamename,buf);
#endif
  printf ("Number of standard systems? ");
  nstdplanets = geti ();
  nplanets = nstdplanets * 3;
  galaxysize = 0.0;
  do
  {
    printf ("Size of galaxy? ");
    galaxysize = getf ();
  }
  while (galaxysize < MINSEP);  /* Just to ensure a sane value */
  for (i = 0; i < nplanets; i++)
  {
    p = addplanet ();
    p->x = frand (galaxysize);
    p->y = frand (galaxysize);
    p->owner = NULL;
    set_spice (p);
  }
}

#endif

#endif
