static char *rcsid = "$Header: /navy/homes/zeus/SRC/RCS/enterturn.c,v 2.42 1994/05/17 13:43:15 bampton Exp bampton $";

/*
 * $Log: enterturn.c,v $
 * Revision 2.42  1994/05/17  13:43:15  bampton
 * *** empty log message ***
 *
 * Revision 2.41  1994/04/08  03:11:28  bampton
 * Revision 2.40  1994/03/09  20:22:55  bampton
 * Revision 2.39  1993/10/28  22:31:20  bampton
 * Revision 2.38  1993/09/27  17:15:54  bampton
 * Revision 2.37  1993/09/07  20:50:32  bampton
 * Revision 2.36  1993/08/19  16:32:29  bampton
 * Revision 2.35  1993/08/14  15:46:12  bampton
 * Revision 2.34  1993/08/09  23:06:20  bampton
 * Revision 2.33  1993/08/03  23:10:13  bampton
 * Revision 2.30  1993/07/14  14:59:26  bampton
 * Revision 0.0  1993/07/14  13:42:03  bampton RCS prototype.
 *
 */

#define IO
#define NOTIMEB
#include "common.h"
#include "prot.h"
#include "protos/enterturn.h"
#include "protos/cmds.h"

void enterturn_rcsid (void);

#ifdef  INTERACTIVE
#define throwstr()
#else
#define throwstr()              getstr()
#endif

extern player *players;
extern shiptype *shiptypes;
extern battle *battles;
extern char buf[256];
extern double galaxysize;
int groupno;
extern planet *planets;
extern int turn;

#ifdef PREPROC
int bad = 0;
int n_order = 0;

#endif

extern planetdefense *defender;

char orders[256];
char err_tmp[80];


void
enterturn_rcsid (void)
{
  printf ("%s\n", rcsid);
}

void
error (char msg[])
{

#ifdef PREPROC
  bad++;

#ifdef SMART
  fprintf (stderr, "Mistake (%0d):%s\n", n_order, orders);
  fprintf (stderr, "%s", msg);
  return;
#endif

  printf ("          ");
  printf ("%s", msg);
#else
  printf ("%s\n", msg);
#endif
}

void
append_cmd (char *order, char *cmd)
{
  int i, j;


  assert (strlen (order) + strlen (cmd) < 255);

  order[1 + strlen (order)] = '\0';
  order[strlen (order)] = ' ';
  for (i = strlen (order), j = 0; (order[i] = cmd[j]); i++, j++);

}

void
getstr (void)
{
  int i;

  gets (buf);
  buf[MAXTEXT - 1] = 0;
  i = strlen (buf);
  while (i && buf[i - 1] == ' ')
    buf[--i] = 0;
}


/* BUG : What what to return if not an int */

int
geti (void)
{

#ifndef PREPROC
  REDO:
#endif

  getstr ();
  if (buf[0] && !isdigit (buf[0]))
  {
    sprintf (err_tmp, "Integer expected.\n");

#ifndef PREPROC
    fprintf (stderr, "%s", err_tmp);
    goto REDO;
#else
    return -1;
#endif
  }
  return atoi (buf);
}

/* BUG : What what to return if not an float */
double
getf (void)
{

#ifndef PREPROC
  REDO:
#endif

  getstr ();
  if (buf[0] && !isdigit (buf[0]) && buf[0] != '.')
  {
    sprintf (err_tmp, "Number expected.\n");

#ifndef PREPROC
    fprintf (stderr, "%s", err_tmp);
    goto REDO;
#else
    return 0.0;
#endif
  }
  return atof (buf);
}

/* BUG : What what to return if not an float */
double
getf2 (void)
{

#ifndef PREPROC
  REDO:
#endif

  getstr ();
  if (buf[0] && !isdigit (buf[0]) && buf[0] != '.' && buf[0] != '-')
  {
    sprintf (err_tmp, "Number expected.\n");

#ifndef PREPROC
    fprintf (stderr, "%s", err_tmp);
    goto REDO;
#else
    return 0.0;
#endif
  }
  return atof (buf);
}

int
stricmp (const char *s1, const char *s2)
{
  char c1, c2;

  do
  {
    c1 = tolower (*s1++);
    c2 = tolower (*s2++);
    if (c1 != c2)
      return c1 - c2;
  }
  while (c1);
  return 0;
}

int
zeromem (void *_p, int bytes)
{
  char *p = _p;

  do
    if (*p++)
      return 0;
  while (--bytes);
  return 1;
}


void
addlist (void *_base, void *_p)
{
  list **base = _base;
  list *p = _p;
  list *q;

  p->next = NULL;
  if (*base)
  {
    for (q = *base; q->next; q = q->next)
      ;
    q->next = p;
  }
  else
    *base = p;
}

void
removelist (void *_base, void *_p)
{
  list **base = _base;
  list *p = _p;
  list *q;

  if (*base == p)
    *base = p->next;
  else
  {
    for (q = *base; q->next != p; q = q->next)
      assert (q);
    q->next = p->next;
  }
  free (p);
}

void
cktech (group * g)
{
  shiptype *t;

  t = g->type;
  if (!t->drive)
    g->tech.drive = 0.0;
  if (!t->nguns)
    g->tech.guns = 0.0;
  if (!t->shields)
    g->tech.shields = 0.0;
  if (!t->cargo)
    g->tech.cargo = 0.0;
}

#ifdef PASSWORDS
int
verify_password (player *P, const char *pw)
{
  FILE *pwf;
  char pwfpw[MAXTEXT],pwl[200];
  int j,k;

  pwf = fopen ("races:passwords","r");
  if (pwf==NULL) exit (2); /* Urk. No file? */

  for (;;)
  {
    if (feof(pwf)) /* Player name not matched in file */
    {
      if (strlen(pw)==0) return (0); /* No password given, or req'd */
      error("Player name missing from password file\n");
      return (1);
    } /* Do the EOF check first, to deal with empty file and match on last */
    fscanf (pwf,"%s\n",pwl);
    if (!strncasecmp(P->name,pwl,strlen(P->name))) /* Match ... */
    {
      j=strlen(P->name)+1;
      for(k=0;pwl[k+j];k++) pwfpw[k]=pwl[k+j];
      pwfpw[k]='\0';
      if (strlen (pw)== strlen(pwfpw)) /* Potential match */
      {
        if (stricmp(pw,pwfpw)!=0)
        {
          sprintf(err_tmp,"Password mismatch\n");
          return (1);
        }
        return(0); /* Matched */
      }
      else 
      {
        sprintf(err_tmp,"Password mismatch\n");
        return (1);
      }
    }
  }
  assert (0); /* Should have been given a valid player name */
}
#endif

void *
nametop (void *head, char *s)
{
  list *p;

  for (p = head; p; p = p->next)
    if (!stricmp ((char *) (p + 1), s))
      return p;
  return 0;
}


/*
 * gellings 1/28/93: Fixed to prevent naming planet A w/ the number of planet
 * B from affecting ships sent to planet B using B's number
 */

planet *
nametoplan (planet * head, const char *s)
{
  planet *p;

  for (p = head; p; p = p->next)
    if (!stricmp (p->num, s))
      return p;
  for (p = head; p; p = p->next)
    if (!stricmp (p->name, s))
      return p;
  return 0;
}

int
ptonum (void *base, void *target)
{
  list *p;
  int i = 1;

  for (p = base; p; p = p->next)
  {
    if (p == target)
      return i;
    i++;
  }
  return 0;
}

void *
numtop (void *base, int n)
{
  list *p;
  int i = 0;

  if (!n)
    return 0;
  for (p = base; p; p = p->next)
  {
    i++;
    if (i == n)
      return p;
  }
  return 0;
}

planet *
inputplanet (planet * head, char *prompt)
{
  planet *p;

#ifdef INTERACTIVE
LOOP:
#endif

  printf ("%s%c", prompt, lf);
  getstr ();
  if (buf[0])
  {
    if ((p = nametoplan (head, buf)) != 0)
      return p;
    sprintf (err_tmp, "System \"%s\" not found.\n", buf);

#ifdef  INTERACTIVE
    goto LOOP;
#endif
  }
  else
    sprintf (err_tmp, "No planet given\n");
  return 0;
}

player *
n2inputplayer (char *prompt)
{
  player *p;
  char *nbuf;
  char name[MAXTEXT + 1];
  char password[MAXTEXT + 1];
  int i;

  printf ("%s%c", prompt, lf);
  for (;;)
  { /* Keep reading lines of input until EOF */
    gets (buf);
    if (feof(stdin)) return(NULL);

    if (buf[0])
    { /* Non-empty line, so see if it has magic #galaxy cookie */
      if (!strncasecmp (buf, "#galaxy", 7))
      {
        nbuf = strchr (buf, ' '); /* Find first space */
        for (; nbuf;) /* Kill whitespace */
          if ((nbuf[0] == ' ') || (nbuf[0] == '\t'))
            nbuf++;
          else
            break;

        nbuf = strchr (nbuf, ' '); /* Find 2nd wordbreak */
        if (!nbuf) break; /* TEMP BUGFIX */
        nbuf++;
        for (; nbuf;)
          if ((nbuf[0] == ' ') || (nbuf[0] == '\t'))
            nbuf++;
          else
            break;

        /* Now we grab the name.... */
        for (i = 0; i < strlen (nbuf); i++)
        {
          /* BUG: #galaxy game "empire name" not handled */
          if ((nbuf[i] != ' ') && (nbuf[0] != '\t'))
            name[i] = nbuf[i];
          else
            break;
        }
        name[i] = '\0';
        nbuf += i;
        for (; nbuf;) /* Find 3rd break's whitespace end */
          if ((nbuf[0] == ' ') || (nbuf[0] == '\t'))
            nbuf++;
          else
            break;
 
        /* Copy password entry */
        for (i = 0; i < strlen (nbuf); i++)
          if ((nbuf[i] != ' ') && (nbuf[0] != '\t'))
            password[i] = nbuf[i];
          else
            break;
        password[i] = '\0';

        printf ("%s's password is %s\n", name, password);

        if ((p = nametop (players, name)) != 0)
        {
#ifdef PASSWORDS
          if(verify_password(p,password)!=0)
            return 0;
#endif
          return p;
        }
        sprintf (err_tmp, "Player \"%s\" not found.\n", buf);
        return 0;
      }
    }
  }
  return(0); /* BUG PROBLEM */
}

player *
inputplayer (player * head, char *prompt)
{
  player *p;

#ifdef INTERACTIVE
LOOP:
#endif

  printf ("%s%c", prompt, lf);
  getstr ();

  if (buf[0])
  {
    if ((p = nametop (head, buf)) != 0)
      return p;
    sprintf (err_tmp, "Player \"%s\" not found.\n", buf);

#ifdef  INTERACTIVE
    goto LOOP;
#endif
  }
  return 0;
}

double
shipcost (shiptype * type, planet * p)
{
  double mass;

  mass = typemass (type);
  assert (p->mat >= 0.0);       /* Stupidity check */
  if (p->mat <= 0.005)          /* Round off error check */
    return ((INDPERSHIP + 1.0 / p->resources) * mass);
  if (p->mat > typemass (type))
    return (INDPERSHIP * mass);
  else
    return (((INDPERSHIP + 1.0 / p->resources) * (mass - p->mat)) + INDPERSHIP * p->mat);
}

void
setproduction (planet * p, int t)
{
  double mass;

  if (p->producing == PR_SHIP)
  {
    mass = typemass (p->producingshiptype);
    if (mass > p->mat)
    {
      p->mat += (p->inprogress / shipcost (p->producingshiptype, p)) * mass;
    }
  }
  /* So why doesn't this work? 
  else
    p->producingshiptype=(shiptype *)0; */
  p->inprogress = 0.0;
  p->producing = t;
}

int
inputproduction (void)
{
  static char *productionname[] =
  {
    "cap",
    "mat",
    "ship",
    "drive",
    "weapons",
    "shields",
    "cargo",
  };
  int i;

#ifdef INTERACTIVE
LOOP:
#endif

  printf ("Production type?%c", lf);
  getstr ();
  for (i = 0; i < sizeof (productionname) / sizeof (char *); i++)

    if (!stricmp (productionname[i], buf))
      return i;
  sprintf (err_tmp, "\"%s\" is not a production type.\n", buf);

#ifdef  INTERACTIVE
  goto LOOP;
#else
  error (err_tmp);
  return 0;
#endif
}

double
inputcomponent (char *s)
{
  double x;

  printf ("%s%c", s, lf);
  x = getf ();
  if (!x)
    return 0;

  if (x < 1.0)
    return (-1.0);
  return x;
}

group *
inputgroup (player * P)
{
  group *g;

#ifndef PREPROC
LOOP:
#endif

  printf ("Group?%c", lf);
  getstr ();
  if (!stricmp (buf, "max"))
  {
    g = P->groups;
    if (!g)
      return 0;
    while (g->next)
      g = g->next;
    return g;
  }
  if (buf[0] && !isdigit (buf[0]))
  {
    sprintf (err_tmp, "Integer expected.\n");

#ifndef PREPROC
    goto LOOP;
#endif
  }
  groupno = atoi (buf);
  if (!groupno)
    return 0;
  g = numtop (P->groups, groupno);
  if (!g)
  {
    sprintf (err_tmp, "There is no group %d.\n", groupno);
    /*error (err_tmp);*/

#ifdef  INTERACTIVE
    goto LOOP;
#endif
  }
  return g;
}

int
inputcargotype (void)
{
  int i;
  static char *cargonames[] =
  {
    "col",
    "cap",
    "mat",
    "emp",
  };

#ifdef INTERACTIVE
LOOP:
#endif

  printf ("Cargo?%c", lf);
  getstr ();
  if (buf[0] == 0)
    return -1;
  buf[3] = 0;
  for (i = 0; i < sizeof (cargonames) / sizeof (char *); i++)

    if (!stricmp (cargonames[i], buf))
      return i;
  sprintf (err_tmp, "\"%s\" is not a cargo type.\n", buf);

#ifdef  INTERACTIVE
  goto LOOP;
#else
  return 0;
#endif
}

void
send (group * g, planet * p)
{
  g->from = g->where;
  g->where = p;
  g->dist = dist (p, g->from);
}

shiptype *
inputshiptype (player * P)
{
  shiptype *T;

#ifdef  INTERACTIVE
  for (;;)
#endif

  {
    printf ("Ship Type?%c", lf);
    getstr ();
    if (!buf[0])
      return 0;
    for (T = shiptypes; T; T = T->next)
      if (T->owner == P && !stricmp (T->name, buf))
        return T;
    sprintf (err_tmp, "\"%s\" is not a ship type.\n", buf);

#ifndef INTERACTIVE
    return 0;
#endif
  }
}

void
addcol (planet * p, double x)
{
  double x2 = p->size - p->pop;

  x *= POPPERCOL;
  if (x2 > x)
    x2 = x;
  p->pop += x2;
  x -= x2;
  p->mat += x2 / POPPERCOL * MATPERCOL;
  p->col += x / POPPERCOL;
}

void
unloadgroup (group * g, player * P)
{
  double x;
  planet *p;

  x = g->load * g->ships;
  p = g->where;

  assert (p->size);             /* can't unload onto size 0 systems; die
                                 * nothing if try */

  switch (g->loadtype)
  {
  case CG_CAP:
    p->cap += x;
    break;
  case CG_MAT:
    p->mat += x;
    break;
  case CG_COL:
    /*
     * GE: cannot settle size 0 systems
     */
    if (p->size != 0.0)
    {
      if (p->owner == NULL)
      {
        p->owner = P;
        p->producing = PR_CAP;
      }
      if (p->owner == P)
        addcol (p, x);

      else
        p->mat += x * MATPERCOL;
    }
    break;
  default:
    assert (0);
  }
  g->load = 0;
  g->loadtype = CG_EMPTY;

}

void
set_defend (player * P, int status, planet * p)
{
  planetdefense *df;

  if (P)
  {
    for (df = defender; df; df = df->next)
      if ((df->planet == p) && (df->defender == P))
      {                         /* They've changed a current one */
        if (status == FLUSH)
          removelist (&defender, df);
        else
          df->dipstat = status;
        break;
      }
    if (!df)
    {                           /* Or added one */
      df = alloc (sizeof (planetdefense));
      df->dipstat = status;
      df->planet = p;
      df->defender = P;
      addlist (&defender, df);
    }
  }
  else                          /* Or cleaning one up */
    for (df = defender; df; df = df->next)
      if (df->planet == p)
        removelist (&defender, df);
}

void
enterturn (void)
{
  player *P;


#ifdef PREPROC
  P = n2inputplayer ("");
  n_order = 0;
#else
  P = n2inputplayer ("Player?");
#endif

  if (P == NULL)
  {

#ifdef PREPROC
    /*sprintf (err_tmp, "Unknown player name %s\n", buf); */
    error (err_tmp);
#endif

    return;
  }

#ifdef PREPROC

#ifdef FORECAST
  build_seen_list (P);
#endif

#endif

  P->lastorders = turn + 1;

  for (;;)
  {

    orders[0] = '\0';

#ifndef PREPROC
    printf ("%s>%c", P->name,lf);
    fflush (stdout);
#else
    n_order++;
    printf ("%s:%d>\n", P->name, n_order);
#endif

  LOOP:
    gets (buf);
    if (feof(stdin)) 
    {
      error ("Missing #end, assuming that it is there\n");
      strcpy(buf,"#end");
    }
    append_cmd (orders, buf);
    if (!buf[0])
      goto LOOP; /* Blank line */
    if ((strlen(buf)==1) && (buf[0]==' ' || buf[0]=='\t'))
      goto LOOP; /* Space */
    switch (tolower (buf[0]))
    {
    case 'a':
      a_cmd (buf, P);
      break;
    case 'b':
      b_cmd (buf, P);
      break;
    case 'c':
      c_cmd (buf, P);
      break;
    case 'd':
      d_cmd (buf, P);
      break;
    case 'e':
      e_cmd (buf, P);
      break;
    case 'f':
      f_cmd (buf, P);
      break;

#ifdef V3
    case 'g':
      g_cmd (buf, P);
#else
    case 'h':
      h_cmd (buf, P);
#endif

      break;

#ifdef V3
    case 'h':                   /* def mod */
      h_cmd (buf, P);
#else
    case 'g':                   /* def mod */
      g_cmd (buf, P);
#endif

      break;
    case 'i':
      i_cmd (buf, P);
      break;

#ifdef UPGRADE
    case 'j':
      j_cmd (buf,P);
      break;
#endif

#ifdef KCMD
    case 'k':
      k_cmd (buf, P);
      break;
#endif

    case 'l':
      l_cmd (buf, P);
      break;
    case 'm':
      m_cmd (buf, P);
      break;
    case 'n':
      n_cmd (buf, P);
      break;
    case 'o':
      o_cmd (buf, P);
      break;
    case 'p':
      p_cmd (buf, P);
      break;

#ifndef UPGRADE
    case 'q':

#ifdef FORECAST
      if (P->opts2 & FCAST)
      {
        while (P->lastorders > turn)
          go ();
        forecast_report (P);
      }
#endif
#endif

      return;
    case 'r':
      r_cmd (buf, P);
      break;
    case 's':
      s_cmd (buf, P);
      break;
    case 't':
      t_cmd (buf, P);
      break;

    case 'u':
      u_cmd (buf, P);
      break;
    case 'w':
      w_cmd (buf, P);
      break;
    case 'x':
      x_cmd (buf, P);
      break;
    case ';':
      break;
    case '#':
      if (!strncasecmp(buf,"#end",4))
      {
#ifdef FORECAST
        if (P->opts2 & FCAST)
        {
          while (P->lastorders > turn)
            go ();
          forecast_report (P);
        }
#endif
        return;
      }
      break;

    default:
      sprintf(err_tmp,"Huh? %s\n",buf);
      printf ("\"%s\" is not a valid command.\n", buf);
      printf ("Available commands:\n");
      printf ("\n");
      printf ("A = Declare Peace\n");
      printf ("B = Break Up Group\n");
      printf ("C = Change Player Name\n");
      printf ("D = Design Ship Type\n");
      printf ("E = Erase Ship Type\n");
      printf ("F = Full system request\n");

#ifndef V3
      printf ("G = Declare Defensive\n");
      printf ("H = Upgrade\n");
#else
      printf ("G = Upgrade\n");
      printf ("H = Declare Defensive\n");
#endif

      printf ("I = Intercept\n");
#ifdef UPGRADE
      printf ("J = Join\n");
#endif

#ifdef KCMD
      printf ("K = Planet protection\n");
#endif

      printf ("L = Load Cargo\n");
      printf ("M = Define Map Area\n");
      printf ("N = Name System\n");
      printf ("P = Set System Production\n");
      printf ("Q = Quit\n");
      printf ("R = Set Route\n");
      printf ("S = Send Group\n");
      printf ("T = Name Ship Type\n");
      printf ("U = Unload Cargo\n");
      printf ("W = Declare War\n");
      printf ("X = Scrap\n");
    }
  }
}
