static char *rcsid = "$Header: /navy/homes/zeus/SRC/RCS/cmds.c,v 2.42 1994/05/17 13:43:15 bampton Exp bampton $";

/*
 *
 * $Log: cmds.c,v $
 * Revision 2.42  1994/05/17  13:43:15  bampton
 * *** empty log message ***
 *
 * Revision 2.41  1994/04/08  03:11:28  bampton
 * Revision 2.39  1994/03/09  20:26:10  bampton
 * Revision 0.0  1993/12/24  16:47:26  zeus
 * RCS prototype.
 *
 */

#define NOTIMEB

#include "common.h"
#include "prot.h"
#include "protos/enterturn.h"
#include "protos/cmds.h"

extern char err_tmp[];
extern int groupno;
extern int turn;
extern player *players;
extern planet *planets;
extern shiptype *shiptypes;
extern battle *battles;
extern double galaxysize;
extern tmppname *tmpname;
extern fleetname *fleets;
extern planetdefense *defender;

char tbuf[100];
int pos = 0;
int comment = 0;
int null_planet_ok;             /* Used to differentiate between missing planet name,
      and optional one. */

static char *productionname[] =
{
  "cap",
  "mat",
  "ship",
  "drive",
  "weapons",
  "shields",
  "cargo",
};

void
cmds_rcsid (void)
{
  printf ("%s\n", rcsid);
}

char y[80];

/* THis is a "safe" strcpy- null termination guarenteed, and no overrun */
void
hstrcpy (char *a, const char *b)
{
  int x;

  a[0] = '\0';
  if (b == NULL)
    return;
  for (x = 0; b[x]; x++)
  {
    a[x] = b[x];
  }
  a[x] = b[x];
}

void
hstrncpy (char *a, const char *b, const int sz)
{
  int x;

  a[0] = '\0';
  a[sz - 1] = '\0';
  if (b == NULL)
    return;
  for (x = 0; b[x] && x < sz; x++)
  {
    a[x] = b[x];
  }
  if (x < sz)
    a[x] = '\0';
}

char *
next_token (void)
{
  int i;
  int pos2;

  if (!tbuf[pos])
    return (NULL);
  for (;;)
  {
    if ((tbuf[pos] == '\0') || ((tbuf[pos] != ' ') && tbuf[pos] != '\t'))
      break;
    else
      pos++;
  }
  if (tbuf[pos] != '\0')
  {
    if (tbuf[pos]=='"')
    {
      for (tbuf[pos]=' ',pos2=pos+1;;pos2++)
      {
        if (tbuf[pos]=='\0')
          return (NULL);  /* Bugish Should distinguish btw bad quote and empty*/
        if (tbuf[pos2]=='"')
        {
          tbuf[pos2]=' ';
          break;
        }
        if (tbuf[pos2]==' ')
        {
          tbuf[pos2]='_';
        }
      }
      pos++;
      if (tbuf[pos]=='\0') /* String was " */
        return(NULL);
    }
    i = 0;
    for (;;)
    {
      if ((!tbuf[pos + i]) || (tbuf[pos + i] == ' ') || (tbuf[pos + i] == '\t'))
      {
        hstrncpy (y, &tbuf[pos], i);
        pos += i;
        y[i] = '\0';
        return (y);
      }
      i++;
    }
  }
  else
    return (NULL);
}

void
extra_token (void)
{
  char t[100];
  char *x;

  if (comment)
  {
    comment = 0;
    return;
  }
  if (tbuf[pos] == '\0')
    return;
  x = next_token ();
  if (x == NULL)
    return;
  strcpy (t, x);
  if ((t[0] == ';') || (t[0] == '#'))
    return;
  sprintf (err_tmp, "Warning!!! Extra token %s ignored\n", t);
  error (err_tmp);
}

int
ngeti (void)
{
  char cmd[100];

  hstrcpy (cmd, next_token ());
  if (cmd[0] && !isdigit (cmd[0]) && cmd[0] != ';' && cmd[0] != '#')
  {
    sprintf (err_tmp, "Integer expected.\n");

#ifndef PREPROC
    fprintf (stderr, "%s", err_tmp);
#endif

    return BADI;
  }
  if (!cmd[0])
  {
    sprintf (err_tmp, "Missing integer?\n");
    return (MISSINGI);
  }
  if (cmd[0] == ';' || cmd[0] == '#')
  {
    sprintf (err_tmp, "Comment?\n");
    return (-3);
  }
  return atoi (cmd);
}


/* BUG : What what to return if not an float */
double
ngetf (void)
{
  char cmd[100];

  hstrcpy (cmd, next_token ());
  if (cmd[0] && !isdigit (cmd[0]) && cmd[0] != '.')
  {
    sprintf (err_tmp, "Number expected.\n");
    return (BADF);
  }
  if (!cmd[0])
  {
    sprintf (err_tmp, "Missing number?\n");
    return (MISSINGF);
  }
  return atof (cmd);
}

/* BUG : What what to return if not an float */
double
ngetf2 (void)
{
  char cmd[100];
  float z;

  hstrcpy (cmd, next_token ());
  if (!cmd[0])
  {
    sprintf (err_tmp, "Mising number?\n");
    return (-10000.0);
  }
  if (cmd[0] && !isdigit (cmd[0]) && cmd[0] != '.' && cmd[0] != '-')
  {
    sprintf (err_tmp, "Number expected.\n");
    return (-1.0);
  }
  sscanf (cmd, "%f", &z);
  return ((double) z);
}


double
ninputcomponent ()
{
  double x;

  x = ngetf ();
  if (!x)
    return (0.0);
  if (x == MISSINGF)
    return (MISSINGF);
  if (x < 1.0)
    return (BADF);
  return (x);
}

int
ninputcargotype (void)
{
  char cmd[MAXTEXT];
  int i;
  static char *cargonames[] =
  {
    "col",
    "cap",
    "mat",
    "emp",
  };

  hstrncpy (cmd, next_token (), MAXTEXT);
  cmd[MAXTEXT - 1] = '\0';
  if (!cmd[0])
  {
    sprintf (err_tmp, "No cargo type specified!\n");
    return -1;
  }
  cmd[3] = 0;
  for (i = 0; i < sizeof (cargonames) / sizeof (char *); i++)

    if (!stricmp (cargonames[i], cmd))
      return i;
  sprintf (err_tmp, "\"%s\" is not a cargo type.\n", cmd);
  return -1;
}


int
ninputcargotype2 (void)
{
  char cmd[MAXTEXT];
  int i;
  static char *cargonames[] =
  {
    "col",
    "cap",
    "mat",
    "emp",
    "all",
  };

  hstrncpy (cmd, next_token (), MAXTEXT);
  cmd[MAXTEXT - 1] = '\0';
  if (!cmd[0])
  {
    sprintf (err_tmp, "No cargo type specified!\n");
    return -1;
  }
  cmd[3] = 0;
  for (i = 0; i < sizeof (cargonames) / sizeof (char *); i++)

    if (!stricmp (cargonames[i], cmd))
      return i;
  sprintf (err_tmp, "\"%s\" is not a cargo type.\n", cmd);
  return -1;
}

int
ninputproduction (player * P, planet * p)
{
  int i;
  char t[MAXTEXT];
  shiptype *T;

  hstrncpy (t, next_token (), MAXTEXT);
  t[MAXTEXT - 1] = '\0';
  if (t[0])
  {
    for (i = 0; i < sizeof (productionname) / sizeof (char *); i++)

      if (!stricmp (productionname[i], t))
        if (i == PR_SHIP)
        {
          hstrncpy (t, next_token (), MAXTEXT);
          t[MAXTEXT - 1] = '\0';
          break;
        }
        else
          return i;

    if (t[0])
    {
      for (T = shiptypes; T; T = T->next)
        if (T->owner == P && !stricmp (T->name, t))
        {
          if ((p->producing==PR_SHIP) && (p->producingshiptype == T)) 
                        /* Short circut */
            return (-1); /* So you don't scrap the partial ship */
          p->producingshiptype = T;
          return (PR_SHIP);
        }

      sprintf (err_tmp, "\"%s\" is not a production type.\n", t);
      error (err_tmp);
      return (0);
    }
  }
  error ("No production type given!\n");
  return 0;
}

shiptype *
ninputshiptype (player * P)
{
  shiptype *T;
  char cmd[MAXTEXT];

  hstrncpy (cmd, next_token (), MAXTEXT);

  if (!cmd[0])
  {
    sprintf (err_tmp, "No ship type name given!\n");
    return 0;
  }
  for (T = shiptypes; T; T = T->next)
    if (T->owner == P && !stricmp (T->name, cmd))
      return T;
  sprintf (err_tmp, "\"%s\" is not a ship type.\n", cmd);

  return 0;
}

group *
ninputgroup (player * P)
{
  group *g, *g2;
  char cmd[MAXTEXT];

  hstrncpy (cmd, next_token (), MAXTEXT);
  cmd[MAXTEXT - 1] = '\0';

  if (!cmd[0])
  {
    sprintf (err_tmp, "No group # specified!\n");
    return (NULL);
  }

  if (!stricmp (cmd, "max"))
  {
    g = P->groups;
    g2 = NULL;
    if (!g)
      return 0;
    if (P->opts2 & UNSAFEMAX)
    {
      while (g->next)
      {
        if (g->dist == 0.0)
          g2 = g;
        g = g->next;
      }
      g = g2;
    }
    else
    {
      while (g->next)
        g = g->next;
    }
    return g;
  }
  if (cmd[0] && !isdigit (cmd[0]))
  {
    sprintf (err_tmp, "Integer expected.\n");
  }
  groupno = atoi (cmd);
  if (!groupno)
    return 0;
  g = numtop (P->groups, groupno);
  if (!g)
  {
    sprintf (err_tmp, "There is no group %d.\n", groupno);
  }
  return g;
}

group *
matchgroup (player * P, char *cmd)
{
  group *g;

  if (!cmd[0])
  {
    sprintf (err_tmp, "No group # specified!\n");
    return (NULL);
  }

  if (!stricmp (cmd, "max"))
  {
    g = P->groups;
    if (!g)
      return 0;
    while (g->next)
      g = g->next;
    return g;
  }
  if (cmd[0] && !isdigit (cmd[0]))
  {
    sprintf (err_tmp, "Source Group or fleet not recognized\n");
  }
  groupno = atoi (cmd);
  if (!groupno)
    return 0;
  g = numtop (P->groups, groupno);
  if (!g)
  {
    sprintf (err_tmp, "There is no group %d.\n", groupno);
  }
  return g;
}

#ifdef UPGRADE
fleetname *
matchfleet (player * P, char *cmd)
{
  fleetname *fl;

  if (!cmd[0])
  {
    sprintf (err_tmp, "No group/fleet specified!\n");
    return (NULL);
  }

  for (fl = fleets; fl; fl = fl->next)
  {
    if (!(strcmp (cmd, fl->name)) && (fl->owner == P))
      return (fl);
  }
  sprintf (err_tmp, "There is no fleet %s.\n", cmd);
  return (NULL);
}

shiptype *
matchtype (player * P, char *cmd)
{
  shiptype *T;

  if (!cmd[0])
  {
    sprintf (err_tmp, "No shiptype!\n");
    return (NULL);
  }

  for (T = shiptypes; T; T = T->next)
  {
    if (!(strcmp (cmd, T->name)) && (T->owner == P))
      return (T);
  }
  sprintf (err_tmp, "There is no shiptype %s.\n", cmd);
  return (NULL);
}
#endif

planet *
ninputplanet (void)
{
  planet *p;
  char cmd[MAXTEXT];

  hstrncpy (cmd, next_token (), MAXTEXT);
  cmd[MAXTEXT - 1] = '\0';
  if (cmd[0])
  {
    if ((p = nametoplan (planets, cmd)) != 0)
      return p;
    sprintf (err_tmp, "System \"%s\" not found.\n", cmd);
    if (!((strlen (cmd) == 1) && ((cmd[0] == '-') || (cmd[0] == '_'))))
      null_planet_ok = 0;       /* Special planet name -/_ not used */
  }
  else
    sprintf (err_tmp, "No planet given\n");

  return NULL;
}

player *
ninputplayer (void)
{
  player *p;
  char cmd[MAXTEXT];

  hstrncpy (cmd, next_token (), MAXTEXT);
  cmd[MAXTEXT - 1] = '\0';
  if (cmd[0])
  {
    if ((p = nametop (players, cmd)) != 0)
      return p;
    sprintf (err_tmp, "Player \"%s\" not found.\n", cmd);
    return 0;
  }
  sprintf (err_tmp, "No Empire name specified!\n");
  return 0;
}

void
a_cmd (char *buf, player * P)
{
  player *P2;
  alliance *a;
  defensive *d;

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  P2 = ninputplayer ();
  if (P2)
  {
    if (P2 == P)                /* do this with everyone */
    {
      for (P2 = players; P2; P2 = P2->next)
        if (P2 != P)
        {
          for (a = P->allies; a; a = a->next)
            if (a->ally == P2)
              break;
          for (d = P->defend; d; d = d->next)
            if (d->defend == P2)
              removelist (&P->defend, d);
          if (!a)
          {
            a = alloc (sizeof (alliance));
            a->ally = P2;
            addlist (&P->allies, a);
          }
        }                       /* end of inner "if not self" test */
    }                           /* end of outer "if not self" test */
    else
    {
      for (a = P->allies; a; a = a->next)
        if (a->ally == P2)
          break;
      for (d = P->defend; d; d = d->next)
        if (d->defend == P2)
          removelist (&P->defend, d);
      if (!a)
      {
        a = alloc (sizeof (alliance));
        a->ally = P2;
        addlist (&P->allies, a);
      }
    }
  }
  else
  {
    error (err_tmp);
  }
  extra_token ();
}

void
b_cmd (char *buf, player * P)
{

  group *g, *g2;
  int i;

#ifdef UPGRADE
  fleetname *fl;
  char v[80];

#endif

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  g = ninputgroup (P);
  if (!g)
  {
    error (err_tmp);
    return;
  }

#ifdef UPGRADE
  hstrcpy (v, next_token ());
  fl = matchfleet (P, v);
  if (fl)
  {
    if (g->dist)
    {
      error ("Fleet is in hyperspace\n");
      return;
    }

    if (g->fleet != fl)
    {
      sprintf (err_tmp, "Group %d not a part of fleet %s\n", ptonum (P->groups, g),
               fl->name);
      error (err_tmp);
    }
    g->fleet = 0;
    return;
  }
  if (strlen (v) == 0)
  {
    error ("Missing Fleet or number of ships!\n");
    return;
  }
  i = atoi (v);
#else
  i = ngeti ();
#endif

  if (i < 0)
  {
    error (err_tmp);
    return;
  }
  if (i == 0)
    i = g->ships;
  if (i >= g->ships)
  {
    sprintf (err_tmp, "Not enough ships (%d/%d) in group %d.\n", i, g->ships, groupno);
    error (err_tmp);
    return;
  }
  g2 = alloc (sizeof (group));
  *g2 = *g;
  g2->ships = i;
  g->ships -= i;
  addlist (&P->groups, g2);
  extra_token ();
}

void
c_cmd (char *buf, player * P)
{
  char t[MAXTEXT];
  player *P2;
  tmppname *tp;

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  hstrncpy (t, next_token (), MAXTEXT);
  t[MAXTEXT - 1] = '\0';
  if (t[0])
  {
    P2 = nametop (players, t);
    if (P2)
    {
      sprintf (err_tmp, "Race name \"%s\" is already in use.\n", t);
      error (err_tmp);
    }
    else
    {
      tp = alloc (sizeof (tmppname));
      hstrncpy (tp->nname, t, MAXTEXT);
      tp->nname[MAXTEXT - 1] = '\0';
      hstrcpy (tp->oname, P->name);
      addlist (&tmpname, tp);
    }
  }
  else
    error ("No new name specified!\n");
  extra_token ();
}

void
d_cmd (char *buf, player * P)
{
  char t[MAXTEXT];
  shiptype *T, *T2;
  int i;

#ifdef UPGRADE
  fleetname *fl, *f;
  int x, ok;

#endif

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  hstrncpy (t, next_token (), MAXTEXT);
  if (!t[0])
  {
    error ("No type name given!\n");
    return;
  }
  for (i = 0; i < 7; i++)       /* BUG: 7 should be done with #def or something */
  {
    if (strcmp (productionname[i], "ship") && !(stricmp (productionname[i], t)))
    {
      sprintf (err_tmp, "ship name %s collides with produciton type\n",
               productionname[i]);
      error (err_tmp);
      return;
    }
  }

#ifdef UPGRADE
  if (!stricmp ("fleet", t))
  {
    char v[80];

    hstrcpy (v, next_token ());
    if (!v[0])
    {
      error ("No Fleet name given\n");
      return;
    }
    for (f = fleets; f; f = f->next)
      if ((P == f->owner) && !(stricmp (f->name, t)))
      {
        sprintf (err_tmp, "Fleet name %s already in use\n", t);
        error (err_tmp);
        return;
      }
    for (T2 = shiptypes; T2; T2 = T2->next)
      if (T2->owner == P && !stricmp (T2->name, v))
      {
        sprintf (err_tmp, "Ship of type name \"%s\" is already in use.\n", v);
        error (err_tmp);
        return;
      }
    for (x = 0, ok = 1; v[x] && ok; x++)
      if (!isdigit (v[x]))
        ok = 0;
    if (ok)
    {
      error ("Fleet names can not be numbers.\n");
      return;
    }
    if (!stricmp (v,"max"))
    {
      error ("Fleet name of \"max\" is illegal\n");
      return;
    }
    fl = alloc (sizeof (fleetname));
    hstrcpy (fl->name, v);
    fl->fleetspeed = 1000.0;
    fl->owner = P;
    addlist (&fleets, fl);
    return;
  }
#endif

  for (T2 = shiptypes; T2; T2 = T2->next)
    if (T2->owner == P && !stricmp (T2->name, t))
    {
      sprintf (err_tmp, "Ship type name \"%s\" is already in use.\n", t);
      error (err_tmp);
      return;
    }

#ifdef SIZEBUG
  T = alloc (sizeof (shiptype) + sizeof (int));

#else
  T = alloc (sizeof (shiptype));
#endif

  addlist (&shiptypes, T);
  hstrncpy (T->name, t, MAXTEXT);       /* Bug patch */
  /* T->name[MAXTEXT - 1] = '\0'; Redundant? */
  T->owner = P;

  T->drive = ninputcomponent ();
  if (T->drive == MISSINGF)
  {
    error ("Missing Drive component\n");
    removelist (&shiptypes, T);
    return;
  }
  T->nguns = ngeti ();
  if (T->nguns == MISSINGI)
  {
    error ("Missing number of guns component\n");
    removelist (&shiptypes, T);
    return;
  }
  T->guns = ninputcomponent ();
  if (!T->nguns)
    T->guns = 0;
  if (!T->guns)
    T->nguns = 0;
  if (T->guns == MISSINGF)
  {
    error ("Missing Gun size component\n");
    removelist (&shiptypes, T);
    return;
  }
  T->shields = ninputcomponent ();
  if (T->shields == MISSINGF)
  {
    error ("Missing Shields component\n");
    removelist (&shiptypes, T);
    return;
  }
  T->cargo = ninputcomponent ();
  if (T->cargo == MISSINGF)
  {
    error ("Missing Cargo component\n");
    removelist (&shiptypes, T);
    return;
  }
  if (!T->drive && !T->nguns && !T->shields && !T->cargo)
  {
    sprintf (err_tmp, "At least one component must be non-zero.\n");
    error (err_tmp);
    removelist (&shiptypes, T);
    return;
  }
  if ((T->drive == BADF) || (T->nguns == BADI) || (T->shields == BADF)
      || (T->cargo == BADF))
  {
    sprintf (err_tmp, "Components can not be between 0.01 and 0.99.\n");
    error (err_tmp);
    removelist (&shiptypes, T);
    return;
  }
  if (!T->drive && T->cargo)
  {
    sprintf (err_tmp, "Driveless cargo ships?\n");
    error (err_tmp);
    removelist (&shiptypes, T);
    return;
  }
  extra_token ();
}

void
e_cmd (char *buf, player * P)
{
  shiptype *T;
  group *g;
  planet *p;
  battle *B;
  shot *S;

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  T = ninputshiptype (P);
  if (!T)
  {
    error (err_tmp);
    return;
  }
  for (g = P->groups; g; g = g->next)
    if (g->type == T)
    {
      sprintf (err_tmp, "%s ships still exist.\n", T->name);
      error (err_tmp);
      return;
    }
  for (p = planets; p; p = p->next)
    if (p->owner && p->producing == PR_SHIP &&
        p->producingshiptype == T)
    {
      sprintf (err_tmp, "Systems still producing %s ships.\n", T->name);
      error (err_tmp);
      return;
    }
  for (B = battles; B; B = B->next)
  {
    for (S = B->shots; S; S = S->next)
      if (S->attacker == T || S->target == T)
      {
        sprintf (err_tmp, "Battle involving %s ships still on record.\n",
                 T->name);
        error (err_tmp);
        return;
      }
  }
  removelist (&shiptypes, T);
  extra_token ();
}

void
f_cmd (char *buf, player * P)
{
  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  P->opts1 ^= FULL;
  extra_token ();
}

void

#ifdef V3
g_cmd (char *buf, player * P)
#else
h_cmd (char *buf, player * P)
#endif

{
  int i;
  group *g, *g2;
  char err_tmp2[80];
  double cost_each, ind_avail, z;
  int num_to_do;
  planet *p;
  shiptype *T;

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();

  g = ninputgroup (P);
  if (!g)
  {

#ifdef V3
    sprintf (err_tmp2, "Upgrade command failed. Did you mean Guard (h)?\n%s",
             err_tmp);
#endif

    error (err_tmp2);
    return;
  }
  if (g->dist)
  {
    sprintf (err_tmp, "Group %d is still in hyperspace.\n", groupno);
    error (err_tmp);
    return;
  }
  if (g->where->owner != P)
  {
    sprintf (err_tmp, "You don't own system %s.\n", g->where->num);
    error (err_tmp);
    return;
  }
  i = ngeti ();
  if (i == -3)
    comment = 1;
  if (i == -2)
  {
    error (err_tmp);
    return;
  }
  if (i < 0)
    i = 0;                      /* Too few tokens */
  if ((i > 0) && (g->ships != i))
  {
    if (i >= g->ships)
    {
      sprintf (err_tmp, "Not enough ships in group %d.\n", groupno);
      error (err_tmp);
      return;
    }
    g2 = alloc (sizeof (group));
    *g2 = *g;
    g->ships -= i;
    g2->ships = i;
    addlist (&P->groups, g2);
    g = g2;
  }
  if (i == 0)
    i = g->ships;
  p = g->where;
  T = g->type;

  num_to_do = i;
  ind_avail = effective_ind (p) - p->spent;
/*
  hstrcpy (v, next_token ());
  if (v[0])
  {
     need to create new P2, put techs into it
     assign p2=p in other case
     check boundaries.
     bleck!
  }
  else */
  {
    cost_each = upgrade_cost (P, g);
    if (ind_avail <= 0.0)
    {
      sprintf (err_tmp, "Planet %s has no remaining industry\n", p->num);
      error (err_tmp);
      return;
    }
    if (cost_each * num_to_do > ind_avail)      /* Can we do enitre group ? */
    {                           /* no, so do as many as possible */
      num_to_do = ind_avail / cost_each;
      if (num_to_do == 0)
        num_to_do++;            /* BUGFIX HJB */
      if ((num_to_do == 1) && (g->ships > 1))
      {
        g2 = alloc (sizeof (group));
        *g2 = *g;
        g->ships -= num_to_do;
        g2->ships = num_to_do;
        addlist (&P->groups, g2);
        g = g2;
      }
    }
    z = ind_avail / num_to_do;
    if (z >= cost_each)         /* Can we do an enitire ship or group  ? */
    {
      memcpy (&g->tech.drive, &P->tech.drive, 4 * sizeof (double));
    }
    else
    {                           /* Nope, do partial */
      z /= cost_each;
      cost_each *= z;
      g->tech.drive = g->tech.drive + (P->tech.drive - g->tech.drive) * z;
      g->tech.guns = g->tech.guns + (P->tech.guns - g->tech.guns) * z;
      g->tech.shields = g->tech.shields +
        (P->tech.shields - g->tech.shields) * z;
      g->tech.cargo = g->tech.cargo + (P->tech.cargo - g->tech.cargo) * z;
    }
    cktech (g);
    g->dist = -3.0;
    p->spent += cost_each * num_to_do;
    assert (p->spent <= effective_ind (p) + ALMOSTZERO);
    extra_token ();
  }
}

void

#ifdef V3
h_cmd (char *buf, player * P)
#else
g_cmd (char *buf, player * P)
#endif

{
  player *P2;
  alliance *a;
  defensive *d;

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();

  P2 = ninputplayer ();
  if (P2)
    if (P2 == P)                /* do this with everyone */
    {
      for (P2 = players; P2; P2 = P2->next)
        if (P2 != P)
        {
          for (a = P->allies; a; a = a->next)
            if (a->ally == P2)
              removelist (&P->allies, a);
          for (d = P->defend; d; d = d->next)
            if (d->defend == P2)
              break;
          if (!d)
          {
            d = alloc (sizeof (defensive));
            d->defend = P2;
            addlist (&P->defend, d);
          }
        }                       /* end of inner "if not self" test */
    }                           /* end of outer "if not self" test */
    else
    {
      for (a = P->allies; a; a = a->next)
        if (a->ally == P2)
          removelist (&P->allies, a);
      for (d = P->defend; d; d = d->next)
        if (d->defend == P2)
          break;
      if (!d)
      {
        d = alloc (sizeof (defensive));
        d->defend = P2;
        addlist (&P->defend, d);
      }
    }
  else
  {
    error (err_tmp);
  }
  extra_token ();
}

void
i_cmd (char *buf, player * P)
{
  group *g, *g2;
  int i;
  planet *p;
  char v[80];
  fleetname *fl;

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();

#ifdef UPGRADE
  hstrcpy (v, next_token ());
  fl = matchfleet (P, v);
  if (!fl)
    g = matchgroup (P, v);
  else
    g = NULL;
  if (!g && !fl)
#else
  g = ninputgroup (P);
  if (!g)
#endif

  {
    error (err_tmp);
    return;
  }

#ifdef UPGRADE
  if (fl)
  {
    for (g = P->groups; g; g = g->next)
    {
      if ((g->fleet == fl) && (g->dist))
      {
        error ("Fleet is in hyperspace\n");
        return;
      }
      if ((g->fleet == fl) && (!g->type->drive))
      {
        error ("Fleet cannot move");
        return;
      }
    }
  }
  else
#endif

  {
    if (g->type->drive == 0)
    {
      sprintf (err_tmp, "Ships in group %d can't move.\n", groupno);
      error (err_tmp);
      return;
    }
    if (g->dist)
    {
      sprintf (err_tmp, "Group %d is still in hyperspace.\n", groupno);
      error (err_tmp);
      return;
    }
  }
  p = ninputplanet ();
  if (!p)
  {
    error (err_tmp);
    return;
  }

#ifdef UPGRADE
  if (fl)
  {
    for (g = P->groups; g; g = g->next)
    {
      if (g->fleet == fl)
      {
        g->from = p;
        g->dist = -1.0;
      }
    }
    return;
  }
#endif

  i = ngeti ();
  if (i == -3)
    comment = 1;
  if (i == BADI)
  {
    error (err_tmp);
    return;
  }
  if (i == MISSINGI)
    i = 0;
  if ((i > 0) && (g->ships != i))
  {
    if (i >= g->ships)
    {
      sprintf (err_tmp, "Not enough ships in group %d.\n", groupno);
      error (err_tmp);
      return;
    }
    g2 = alloc (sizeof (group));
    *g2 = *g;
    g2->ships = i;
    g->ships -= i;
    addlist (&P->groups, g2);
    g2->from = p;
    g2->dist = -1.0;

#ifdef UPGRADE
    g2->fleet = NULL;
#endif
  }
  else
  {
    g->from = p;
    g->dist = -1.0;
  }
  extra_token ();
}

#ifdef UPGRADE
void
j_cmd (char *buf, player * P)
{
  planet *p;
  planet *p2;
  group *g;
  group *g2;
  double dist;
  double dist2;
  fleetname *fl;
  fleetname *fl2;
  int i;
  char v[80];
  char v2[80];

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();

  hstrcpy (v, next_token ());
  fl = matchfleet (P, v);
  if (!fl)
    g = matchgroup (P, v);
  else
    g = NULL;
  if (!g && !fl)
  {
    error (err_tmp);
    return;
  }
  if (fl)
  {
    hstrcpy (v2, next_token ());
    fl2 = matchfleet (P, v2);
    if (!fl2)
    {
      sprintf (err_tmp, "Destination fleet %s not recognized\n", v2);
      error (err_tmp);
      return;
    }
    dist = 0.0;
    dist2 = 0.0;
    p2 = NULL;
    for (g = P->groups; g; g = g->next)
    {
      if (g->fleet == fl)
      {
        p = g->where;
        dist = g->dist;
      }
      if (g->fleet == fl2)
      {
        p2 = g->where;
        dist2 = g->dist;
      }
    }
    if (dist)
    {
      error ("First fleet is in hyperspace\n");
      return;
    }
    if (dist2)
    {
      error ("Second fleet is in hyperspace\n");
      return;
    }
    if ((p != p2) && (p2))
    {
      error ("Fleets are not at the same planet\n");
      return;
    }
    for (g = P->groups; g; g = g->next)
      if (g->fleet == fl)
        g->fleet = fl2;
    return;
  }
  /* Joining a group to a fleet */
  hstrcpy (v2, next_token ());
  if (g->dist > 0.0)
  {
    error ("Group is in hyperspace\n");
    return;
  }
  fl = matchfleet (P, v2);
  if (!fl)
  {
    error ("Fleet name not recognized\n");
    return;
  }
  i = ngeti ();
  if (i == -3)
    comment = 1;
  if (i == BADI)
  {
    error (err_tmp);
    return;
  }
  if (i == MISSINGI)
    i = 0;

  if ((i > 0) && (g->ships != i))
  {
    if (i > g->ships)
    {
      error ("Not enough ships, all available used\n");
      return;
    }
    g2 = alloc (sizeof (group));
    *g2 = *g;
    addlist (&P->groups, g2);
    g->ships -= i;
    g2->ships = i;
    g = g2;
  }
  for (g2 = P->groups; g2; g2 = g2->next)
  {
    if ((g2->fleet == fl) && (g2->dist > 0.0))
    {
      error ("Fleet is in hyperspace\n");
      return;
    }
    if ((g2->fleet == fl) && (!g2->dist) && (g2->where != g->where))
    {
      error ("Group is at the wrong planet\n");
      return;
    }
  }
  g->fleet = fl;
}
#endif

#ifdef KCMD
void
k_cmd (char *buf, player * P)
{
  char t[MAXTEXT];
  int status;
  planet *p;
  player *P2;
  planetdefense *pd;

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();

  null_planet_ok = 1;
  p = ninputplanet ();
  if (p)
  {
    if (p->owner == P)
    {
      hstrncpy (t, next_token (), MAXTEXT);
      t[MAXTEXT - 1] = '\0';
      status = GUARD;
      if (!stricmp ("war", t))
        status = WAR;
      if (!stricmp ("peace", t))
        status = PEACE;
      if (!stricmp ("-", t))
        status = FLUSH;
      if (!stricmp ("_", t))
        status = FLUSH;
      if (!t[0])
        status = FLUSH;
      if (status == GUARD)      /* they botched it */
      {
        sprintf (err_tmp, "Unrecognized status \"%s\", Try war|peace\n", t);
        error (err_tmp);
        return;
      }
      else
      {
        P2 = ninputplayer ();
        /* They entered a valid player, or a null one */
        if (P2 == P)
        {
          error ("Shooting at yourself?\n");
          return;
        }
        if ((P2) || (t[0] == '-') || (!t[0]))
        {
          set_defend (P2, status, p);
        }
        else
        {
          error (err_tmp);
          return;
        }
      }
    }
    else
    {
      sprintf (err_tmp, "You don't own system %s.\n", p->num);
      error (err_tmp);
      return;
    }
  }
  else
  {
    if (null_planet_ok == 0)
    {
      error (err_tmp);
      return;
    }
    /* Need to code for K - - empire */
    hstrncpy (t, next_token (), MAXTEXT);
    if ((t[0] == '-') && (strlen (t) == 1))     /* Possible K - - empire */
    {
      P2 = ninputplayer ();
      /* They entered a valid player, or a null one */
      if (P2 == P)
      {                         /* Kill _ALL_ K-cmd's */
        for (P2 = players; P2; P2 = P2->next)
        {
          if (P2 != P)
          {
            for (pd = defender; pd; pd = pd->next)
              if ((pd->defender == P2) && (pd->planet->owner == P))
              {
                removelist (&defender, pd);
              }
          }
        }
      }
      else
      {                         /* Kill K-cmds relatind to P2 from P */
        for (pd = defender; pd; pd = pd->next)
          if ((pd->defender == P2) && (pd->planet->owner == P))
          {
            removelist (&defender, pd);
          }
      }
    }
    else
    {
      sprintf (err_tmp, "Unrecognized status \"%s\", Try war|peace\n", t);
      error (err_tmp);
      return;
    }

  }
  extra_token ();
}
#endif

void
l_cmd (char *buf, player * P)
{
  group *g, *g2;
  int i, j;
  double x, x2;
  planet *p;

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  g = ninputgroup (P);
  if (!g)
  {
    error (err_tmp);
    return;
  }
  if (g->type->cargo == 0)
  {
    sprintf (err_tmp, "Ships in group %d can't carry cargo.\n", groupno);
    error (err_tmp);
    return;
  }
  if ((g->dist > 0) || (g->dist == -1.0))
    /* -1 == intercept */
  {
    sprintf (err_tmp, "Group %d is in hyperspace.\n", groupno);
    error (err_tmp);
    return;
  }
  x = cargospace (g);
  if (x <= g->load)
  {
    sprintf (err_tmp, "Group %d is fully loaded.\n", groupno);
    error (err_tmp);
    return;
  }
  p = g->where;
  if (p->owner != P)
  {
    sprintf (err_tmp, "Group %d is not at one of your systems.\n",
             groupno);
    error (err_tmp);
    return;
  }
  x = (x - g->load) * g->ships;
  i = ninputcargotype ();
  if (i == -1)
  {
    error (err_tmp);
    return;
  }
  if (g->load && g->loadtype != i)
  {
    sprintf (err_tmp, "Group %d is already carrying a different load.\n", groupno);
    error (err_tmp);
    return;
  }
  j = ngeti ();
  if (j == -3)
    comment = 1;
  if (j == -2)
  {
    error (err_tmp);
    return;
  }
  if (j > g->ships)
  {
    j = g->ships;
    sprintf (err_tmp, "Only %d ships can be loaded.\n", j);
    error (err_tmp);
  }
  if (j <= 0)
    j = g->ships;
  if (j != g->ships)
  {
    g2 = alloc (sizeof (group));
    *g2 = *g;
    addlist (&P->groups, g2);
    g->ships -= j;
    g = g2;
    g2->ships = j;
    /* bug fix- HJB */
    x = (cargospace (g) - g->load) * g->ships;
  }
  switch (i)
  {
  case CG_CAP:
    x2 = p->cap;
    if (!x2)
    {
      sprintf (err_tmp, "No capital available for group %d.\n", groupno);
      error (err_tmp);
      break;
    }
    if (x2 > x)
      x2 = x;
    g->load += x2 / g->ships;
    p->cap -= x2;
    g->loadtype = CG_CAP;
    break;
  case CG_MAT:
    x2 = p->mat;
    if (!x2)
    {
      sprintf (err_tmp, "No materials available for group %d.\n", groupno);
      error (err_tmp);
      break;
    }
    if (x2 > x)
      x2 = x;
    g->load += x2 / g->ships;
    p->mat -= x2;
    g->loadtype = CG_MAT;
    break;
  case CG_COL:
    x2 = p->col;
    if (!x2)
    {
      sprintf (err_tmp, "No colonists available for group %d.\n", groupno);
      error (err_tmp);
      break;
    }
    if (x2 > x)
      x2 = x;
    g->load += x2 / g->ships;
    p->col -= x2;
    g->loadtype = CG_COL;
    break;
  }
  extra_token ();
}

void
m_cmd (char *buf, player * P)
{
  double tx, ty, ts;

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();

  tx = ngetf2 ();
  if (tx == -10000.0)
  {
    error (err_tmp);
    return;
  }
  ty = ngetf2 ();
  if (ty == -10000.0)
  {
    error (err_tmp);
    return;
  }
  ts = ngetf ();
  if (fabs (tx) > galaxysize)
  {
    error ("map X can not be larger than galaxy size\n");
    return;
  }
  if (fabs (ty) > galaxysize)
  {
    error ("map Y can not be larger than galaxy size\n");
    return;
  }
  if ((ts == BADF) || (ts == MISSINGF))
  {
    error (err_tmp);
    return;
  }
  if (ts < 1.0)
  {
    error ("map size must be at least 1\n");
    return;
  }
  if (ts > galaxysize)
  {
    error ("map size can not be larger than galaxy size\n");
    return;
  }
  P->opts1 |= MAP;
  P->x = (int) tx;
  P->y = (int) ty;
  P->size = (int) ts;
  extra_token ();
}

void
n_cmd (char *buf, player * P)
{
  planet *p;
  char t[MAXTEXT];

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  p = ninputplanet ();
  if (p)
  {
    if (p->owner != P)
    {
      sprintf (err_tmp, "You don't own system %s.\n", p->num);
      error (err_tmp);
      return;
    }
    hstrncpy (t, next_token (), MAXTEXT);
    t[MAXTEXT - 1] = '\0';


    if (t[0])
    {
      if (nametop (planets, t))
      {
        sprintf (err_tmp, "System name \"%s\" is already in use.\n", t);
        error (err_tmp);
        return;
      }
      if ((!t[1]) && ((t[0] == '-') || (t[0] == '_')))
      {
        sprintf (err_tmp, "System name \"%s\" illegal.\n", t);
        error (err_tmp);
        return;
      }
      hstrcpy (p->name, t);
    }
  }
  else
  {
    error (err_tmp);
  }
  extra_token ();
}

void
o_cmd (char *buf, player * P)
{
  const int opt = 0xff;
  int optmask = 0, on = 1;
  char t[80];
  double x;

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  hstrcpy (t, next_token ());
  if (t[0])
  {
    if (!stricmp (t, "no"))
    {
      hstrcpy (t, next_token ());
      on = 0;
    }

    if (!stricmp (t, "map"))
    {
      optmask = MAP;
    }
    if (!stricmp (t, "fullreport"))
    {
      optmask = FULL;
    }
    if (!stricmp (t, "production"))
    {
      optmask = PROD;
    }
    if (!stricmp (t, "smartmap"))
    {
      optmask = MAPPLUS;
    }
    if (!stricmp (t, "unknown"))
    {
      optmask = UNKNOWN;
    }
    if (!stricmp (t, "battlesum"))
    {
      optmask = BATTLESUM;
    }
    if (!stricmp (t, "longbattle"))
    {
      optmask = LONGBATTLE;
    }
    if (!stricmp (t, "fulltype"))
    {
      optmask = FULLTYPE;
    }
    if (!stricmp (t, "underscores"))
    {
      optmask = UNDERSCORES;
    }
    if (optmask)
    {
      if (on)
        P->opts1 = P->opts1 | optmask;
      else
        P->opts1 = P->opts1 & (opt ^ optmask);
      return;
    }
    if (!stricmp (t, "techs"))
    {
      optmask = TECHS;
    }
    if (!stricmp (t, "sortgroups"))
    {
      optmask = SORTGROUPS;
    }
    if (!stricmp (t, "forecast"))
    {
      int x;

      optmask = FCAST;
      x = ngeti ();

      if (x == -3)
        comment = 1;

      if (x == -1)
        x = 0;

#ifdef PREPROC
      P->lastorders = x;
#endif

      if (x == -2)
      {
        error (err_tmp);

#ifdef PREPROC
        P->lastorders = turn + 1;
#endif
      }
      if (x > turn + 5)
      {
        error ("Forcasts can not be done for more than 5 turns in the future\n");

#ifdef PREPROC
        P->lastorders = turn + 5;
#endif
      }

#ifdef PREPROC
      if (x == 0)
        P->lastorders = turn + 1;
      if (turn >= P->lastorders)
      {
        error ("Forcasts have to be done for turns in the future\n");
        P->lastorders = turn + 1;
      }
#endif
    }
    if (!stricmp (t, "showopts"))
    {
      optmask = SHOWOPT;
    }
    if (!stricmp (t, "techplus"))
    {
      optmask = TECHPLUS;
    }
    if (!stricmp (t, "autounload"))
    {
      optmask = AUTOUNLOAD;
    }
    if (!stricmp (t, "upgradecost"))
    {
      optmask = UPCOST;
    }
    if (!stricmp (t, "twospace"))
    {
      optmask = TWOSPACE;
    }
    if (!stricmp (t, "sortplanets"))
    {
      optmask = SORTPLANETS;
    }
    if (!stricmp (t, "longforecast"))
    {
      optmask = LONGFORECAST;
    }
    if (!stricmp (t, "unsafemax"))
    {
      optmask = UNSAFEMAX;
    }
    if (optmask)
      if (on)
        P->opts2 = P->opts2 | optmask;
      else
        P->opts2 = P->opts2 & (opt ^ optmask);
    if (!stricmp (t, "xcenter"))
    {
      x = ngetf2 ();
      if (x == -10000.0)
      {
        error (err_tmp);
      }
      else
      {
        P->homex += x;
        optmask++;
      }
    }
    if (!stricmp (t, "ycenter"))
    {
      x = ngetf2 ();
      if (x == -10000.0)
      {
        error (err_tmp);
      }
      else
        P->homey += x;
      optmask++;
    }
    if (!optmask)
    {
      sprintf (err_tmp, "Unrecognized option: %s\n", t);
      error (err_tmp);
    }
  }
  else
  {
    error ("Missing option\n");
  }
  extra_token ();
}

void
p_cmd (char *buf, player * P)
{
  planet *p;
  int i;

#ifdef NEW1
  double dt, wt, st, ct;

#endif

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  p = ninputplanet ();
  if (p)
  {
    if (p->owner == P)
    {
      i = ninputproduction (P, p);

#ifdef NEW1
      if (p->producing == PR_SHIP) {
      dt = ninputcomponent ();
      if (dt == BADF)
      {
        error (err_tmp);
        return;
      }
      if (dt > P->tech.drive)
      {
        error ("Drive tech out of range\n");
        return;
      }
      if (dt != MISSINGF)
      {
        wt = ninputcomponent ();
        if (wt == BADF)
        {
          error (err_tmp);
          return;
        }
        if (wt > P->tech.guns)
        {
          error ("Weapons tech out of range\n");
          return;
        }
        if (wt == MISSINGF)
        {
          error (err_tmp);
          return;
        }
        st = ninputcomponent ();
        if (st == BADF)
        {
          error (err_tmp);
          return;
        }
        if (st > P->tech.shields)
        {
          error ("Shield tech out of range\n");
          return;
        }
        if (st == MISSINGF)
        {
          error (err_tmp);
          return;
        }
        ct = ninputcomponent ();
        if (ct == BADF)
        {
          error (err_tmp);
          return;
        }
        if (ct > P->tech.cargo)
        {
          error ("Cargo tech out of range\n");
          return;
        }
        if (ct == MISSINGF)
        {
          error (err_tmp);
          return;
        }
/* Need to check if diff, if so want to call setproduction, else not */
        p->drive = dt;
        p->guns = wt;
        p->shields = st;
        p->cargo = ct;
      }
      }
#endif
     if (i>=0) /* This handles the P planet ship command every turn problem */

      setproduction (p, i);
      extra_token ();           /* Only check for extras if all went well */
    }
    else
    {                           /* don't own system */
      sprintf (err_tmp, "You don't own system %s.\n", p->num);
      error (err_tmp);
    }
  }
  else
    error (err_tmp);
}

void
r_cmd (char *buf, player * P)
{
  planet *p, *p2;
  int i;

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  p = ninputplanet ();
  if (!p)
  {
    error (err_tmp);
    return;
  }
  if (p->owner != P)
  {
    sprintf (err_tmp, "You don't own system %s.\n", p->num);
    error (err_tmp);
    return;
  }
  i = ninputcargotype2 ();
  if (i >= 0)
  {
    null_planet_ok = 1;
    p2 = ninputplanet ();
    if (p2 || null_planet_ok)
      if (i==ALL_CARGO)
        p->routes[COL] =  p->routes[CAP] = p->routes[MAT] = p2;
      else
        p->routes[i] = p2;
    else
      error (err_tmp);
  }
  else
  {
    error (err_tmp);
    return;
  }
  extra_token ();
}

void
s_cmd (char *buf, player * P)
{
  group *g, *g2;
  int i;

#ifdef UPGRADE
  fleetname *fl;
  char v[80];

#endif

  planet *p;

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();

#ifdef UPGRADE
  hstrcpy (v, next_token ());
  fl = matchfleet (P, v);
  if (!fl)
    g = matchgroup (P, v);
  else
    g = NULL;
  if (!g && !fl)
#else
  g = ninputgroup (P);
  if (!g)
#endif

  {
    error (err_tmp);
    return;
  }

#ifdef UPGRADE
  if (fl)
  {
    for (g = P->groups; g; g = g->next)
    {
      if ((g->fleet == fl) && (g->dist))
      {
        error ("Fleet is in hyperspace\n");
        return;
      }
      if ((g->fleet == fl) && (!g->type->drive))
      {
        error ("Fleet cannot move");
        return;
      }
    }
  }
  else
#endif

  {
    if (g->type->drive == 0)
    {
      sprintf (err_tmp, "Ships in group %d can't move.\n", groupno);
      error (err_tmp);
      return;
    }
    if (g->dist)
    {
      sprintf (err_tmp, "Group %d is still in hyperspace.\n", groupno);
      error (err_tmp);
      return;
    }
  }
  p = ninputplanet ();
  if (!p)
  {
    error (err_tmp);
    return;
  }

#ifdef UPGRADE
  if (fl)
  {
    for (g = P->groups; g; g = g->next)
    {
      if (g->fleet == fl)
      {
        send (g, p);
      }
    }
    extra_token ();
    return;
  }
#endif

  i = ngeti ();
  if (i == -3)
    comment = 1;
  if (i == -2)
  {
    error (err_tmp);
    return;
  }
  if (i == -1)
    i = 0;                      /* Too few tokens */
  if (i > g->ships)
  {
    i = g->ships;
    sprintf (err_tmp, "Only %d ships can be sent.\n", i);
    error (err_tmp);
  }
  if (i <= 0)
    i = g->ships;
  if (i != g->ships)
  {
    g2 = alloc (sizeof (group));
    *g2 = *g;
    addlist (&P->groups, g2);
    g->ships -= i;
    g = g2;
    g2->ships = i;
  }
#ifdef UPGRADE
  g->fleet=0;
#endif
  send (g, p);
  extra_token ();
}

void
t_cmd (char *buf, player * P)
{
  shiptype *T, *T2;
  char t[MAXTEXT];

#ifdef UPGRADE
  fleetname *fl, *fl2;
  char v[80];

#endif

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();

#ifdef UPGRADE
  hstrcpy (v, next_token ());
  T = matchtype (P, v);
  fl = matchfleet (P, v);
  if (T || fl)
  {
    hstrncpy (t, next_token (), MAXTEXT);
    t[MAXTEXT - 1] = '\0';
    if (t[0])
    {
      for (T2 = shiptypes; T2; T2 = T2->next)
        if (T2->owner == P && !stricmp (T2->name, t))
        {
          sprintf (err_tmp, "Ship type name \"%s\" is already in use.\n", t);
          error (err_tmp);
          return;
        }
      for (fl2 = fleets; fl2; fl2 = fl2->next)
        if (fl2->owner == P && !stricmp (fl2->name, t))
        {
          sprintf (err_tmp, "Fleet of name \"%s\" is already in use.\n", t);
          error (err_tmp);
          return;
        }
    }
    else
    {
      error (err_tmp);
      return;
    }
  }
  if (T)
    hstrcpy (T->name, t);
  if (fl)
    hstrcpy (fl->name, t);

#else
  T = ninputshiptype (P);
  if (T)
  {
    hstrncpy (t, next_token (), MAXTEXT);
    t[MAXTEXT - 1] = '\0';
    if (t[0])
    {
      for (T2 = shiptypes; T2; T2 = T2->next)
        if (T2->owner == P && !stricmp (T2->name, t))
        {
          sprintf (err_tmp, "Ship type name \"%s\" is already in use.\n", t);
          error (err_tmp);
          return;
        }
      hstrcpy (T->name, t);
    }
  }
  else
  {
    error (err_tmp);
  }
#endif

  extra_token ();
}

void
u_cmd (char *buf, player * P)
{
  group *g, *g2;
  planet *p;
  int i;

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  g = ninputgroup (P);
  if (!g)
  {
    error (err_tmp);
    return;
  }
  if (g->loadtype == CG_EMPTY)
  {
    sprintf (err_tmp, "Group %d isn't carrying cargo.\n", groupno);
    error (err_tmp);
    return;
  }
  if (g->dist)
  {
    sprintf (err_tmp, "Group %d is in hyperspace.\n", groupno);
    error (err_tmp);
    return;
  }
  p = g->where;
  if ((g->loadtype == CG_COL) && (p->owner != P) && p->owner)
  {
    sprintf (err_tmp, "Group %d at %s can't unload COL at alien planet.\n",
             groupno, p->num);
    error (err_tmp);
    return;
  }

  if (!p->size)                 /* can't unload onto size 0   */
  {
    sprintf (err_tmp, "Group %d can not unload- world %4s is size 0.\n",
             groupno, p->num);
    error (err_tmp);
    return;
  }
  i = ngeti ();
  if (i == -3)
    comment = 1;
  if (i == -2)
  {
    error (err_tmp);
    return;
  }
  if (i == -1)
    i = 0;                      /* Too few tokens */
  if (i > g->ships)
  {
    i = g->ships;
    sprintf (err_tmp, "Only %d ships can be unloaded.\n", i);
    error (err_tmp);
  }
  if (i <= 0)
    i = g->ships;
  if (i != g->ships)
  {
    g2 = alloc (sizeof (group));
    *g2 = *g;
    addlist (&P->groups, g2);
    g->ships -= i;
    g2->ships = i;
    g = g2;
  }
  unloadgroup (g, P);
  extra_token ();
}

void
w_cmd (char *buf, player * P)
{
  player *P2;
  alliance *a;
  defensive *d;

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  P2 = ninputplayer ();
  if (P2)
    if (P2 == P)
    {
      for (P2 = players; P2; P2 = P2->next)
        if (P2 != P)
        {
          for (a = P->allies; a; a = a->next)
            if (a->ally == P2)
            {
              removelist (&P->allies, a);
              break;
            }
          for (d = P->defend; d; d = d->next)
            if (d->defend == P2)
            {
              removelist (&P->defend, d);
              break;
            }
        }                       /* end of inner "if not self" test */
    }                           /* end of outer "if not self" test */
    else
    {
      for (a = P->allies; a; a = a->next)
        if (a->ally == P2)
        {
          removelist (&P->allies, a);
          break;
        }
      for (d = P->defend; d; d = d->next)
        if (d->defend == P2)
        {
          removelist (&P->defend, d);
          break;
        }
    }
  else
  {
    error (err_tmp);
  }
  extra_token ();
}

void
x_cmd (char *buf, player * P)
{
  group *g, *g2;
  planet *p;
  int i;

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  g = ninputgroup (P);
  if (!g)
  {
    error (err_tmp);
    return;
  }
  if (g->dist)
  {
    sprintf (err_tmp, "Group %d is still in hyperspace.\n", groupno);
    error (err_tmp);
    return;
  }

  p = g->where;
  if (!p->size)                 /* can't unload onto size 0   */
  {
    sprintf (err_tmp, "Group %d can not be scrapped- world %s is size 0.\n",
             groupno, p->num);
    error (err_tmp);
    return;                     /* systems; do nothing if try */
  }

  if (g->loadtype == CG_COL && g->where->owner && g->where->owner != P)
  {
    sprintf (err_tmp, "Can't unload colonists onto alien planet %s\n", p->num);
    return;
  }
  if (tbuf)
    i = ngeti ();
  else
    i = 0;
  if (i == -3)
    comment = 1;
  if (i == -2)
  {
    error (err_tmp);
    return;
  }
  if (i == -1)
    i = 0;                      /* Too few tokens */
  if ((i > 0) && (g->ships != i))
  {
    if (i >= g->ships)
    {
      sprintf (err_tmp, "Not enough ships in group %d.\n", groupno);
      error (err_tmp);
      return;
    }
    if (i != g->ships)
    {
      g2 = alloc (sizeof (group));
      *g2 = *g;
      g->ships -= i;
      g2->ships = i;
      addlist (&P->groups, g2);
      g = g2;
    }
  }
  if (g->load)
    unloadgroup (g, P);
  g->where->mat += shipmass (g) * g->ships;
  /* removelist (&P->groups, g); */
  g->ships = 0;                 /* Bugfix so we don't renumber groups */
  extra_token ();
}

/*
void
?_cmd (char *buf,player *P)
{
   hstrcpy(tbuf,buf); pos=0;
  (void) next_token();
}
*/
