static char *rcsid = "$Header: /navy/homes/zeus/SRC/RCS/report.c,v 2.42 1994/05/17 13:43:15 bampton Exp bampton $";

/*
 * $Log: report.c,v $
 * Revision 2.42  1994/05/17  13:43:15  bampton
 * *** empty log message ***
 *
 * Revision 2.40  1994/03/09  20:22:55  bampton
 * Revision 2.39  1993/10/28  22:31:20  bampton
 * Revision 2.38  1993/09/27  17:15:54  bampton
 * Revision 2.37  1993/09/07  20:50:32  bampton
 * Revision 2.36  1993/08/19  16:32:29  bampton
 * Revision 2.35  1993/08/14  15:46:12  bampton
 * Revision 2.33  1993/08/03  23:10:13  bampton
 * Revision 2.30  1993/07/14  14:59:26  bampton
 * Full RCS version
 * Revision 0.0 1993/07/14  13:42:25  bampton
 * RCS prototype.
 */

#define NOTIMEB
#include "common.h"
#include "prot.h"
void report_rcsid (void);
void
report_rcsid (void)
{
  printf ("%s\n", rcsid);
}

/* Magic hack to get forcast code to work... */

#ifndef FORECAST

#ifdef PREPROC
#define NOPREPROC
#endif

#else
extern int seenlist[];

#endif

#ifndef NOPREPROC
#include "protos/g-report.h"
#include "protos/report.h"

extern player *players;
extern planet *planets;
extern sorted *sorted_planets;
extern shiptype *shiptypes;
extern battle *battles;
extern bombing *bombings;
extern double galaxysize;
extern char buf[256], buf2[256];
char prname[MAXTEXT] = "con";
#ifdef GAMENAME
extern char gamename[MAXTEXT];
#endif
FILE *pr;
int file;
extern int turn;
extern int nplanets;
int canseeall = 0;
int vieweropts;

#ifdef KCMD
planetdefense *defender;

#endif
fleetname *fleets;

char optf[4];

void
option_on (char *ps, int opt, int popt)
{
  fprintf (pr, ps);
  if (ison (opt, popt))
    fprintf (pr, "on\n");
  else
    fprintf (pr, "off\n");

}

char map[MAPWIDTH][MAPHEIGHT];

typedef struct strlist_s
{
  struct strlist_s *next;
  char *s[20];
}
strlist;


char *fheading;
strlist *fdata;
int fcolumns, fcol;
char *ftypes;
int headflag;

void
inputpr (void)
{
  AGAIN:
  printf ("Output device? [%s] ", prname);
  getstr ();
  if (buf[0])
    strcpy (prname, buf);
  pr = stdout;
  if (stricmp (prname, "con"))
    pr = fopen (prname, "w");
  if (pr == 0)
  {
    printf ("Can't open %s\n", prname);
    goto AGAIN;
  }
}


void
spf (char *s, double x)
{
  int i = 0;

  sprintf (s, "%0.2f", x);
  while (s[i])
    i++;
  while (i && s[i - 1] == '0')
    s[--i] = 0;
  if (i && s[i - 1] == '.')
    s[--i] = 0;
}

void
fpf (FILE * f, double x)
{
  spf (buf, x);
  fprintf (f, buf);
}

void
rpf (double x)
{
  fpf (pr, x);
}

double
wrap (double coord)             /* GE: wraps an idividual coordinate (X or Y)
                                 * so all planets display on a
                                 * player-centered map */
{
  if (coord > (galaxysize / 2))
    return (coord - galaxysize);
  if (coord < (-galaxysize / 2))
    return (coord + galaxysize);
  return coord;
}

int
canseeplanet (player * P, planet * p)
{
  group *g;

  if (canseeall)
    return 1;                   /* gm Cheat mode */
  if (p->owner == P)
    return 1;
  for (g = P->groups; g; g = g->next)
    if (g->dist == 0.0 && g->where == p)
      return 1;
  return 0;
}

void
ckunderscores (char *s)
{
  if (UNDERSCORES & vieweropts)
    while (*s)
    {
      if (*s == ' ')
        *s = '_';
      s++;
    }
}

void
fbegin (char *heading, char *types)
{
  fheading = strdup (heading);
  fcol = fcolumns = strlen (types);
  ftypes = types;
  fdata = 0;
}

void
fs (char *s)
{
  strlist *p2;
  static strlist *p;

  if (fcol == fcolumns)
  {
    p2 = alloc (sizeof (strlist) + fcolumns * sizeof (char *));

    addlist (&fdata, p2);
    p = p2;
    fcol = 0;
  }
  p->s[fcol++] = strdup (s);
  /*ckunderscores (p->s[fcol++]);*/
}

void
ff (double a)
{
  sprintf (buf, "%0.2f", a);
  fs (buf);
}

void
fi (int n)
{
  sprintf (buf, "%d", n);
  fs (buf);
}

void
fend (void)
{
  int *width;
  int i, l;
  strlist *p;

  if (fdata && (!headflag || fdata->next))
  {
    if (*fheading)
      fprintf (pr, "\t\t%s\n\n", fheading);
    for (i = 0; i != fcolumns; i++)
      if (ftypes[i] == 'f')
      {
        int trunc = 1;

        for (p = fdata->next; p; p = p->next)
          if (p->s[i][0] && p->s[i][strlen (p->s[i]) - 1] != '0')
            trunc = 0;
        if (trunc)
        {
          for (p = fdata->next; p; p = p->next)
            if (p->s[i][0])
              p->s[i][strlen (p->s[i]) - 1] = 0;
          for (p = fdata->next; p; p = p->next)
            if (p->s[i][0] && p->s[i][strlen (p->s[i]) - 1] != '0')
              trunc = 0;
          if (trunc)
            for (p = fdata->next; p; p = p->next)
              if (p->s[i][0] && p->s[i][1])
                p->s[i][strlen (p->s[i]) - 2] = 0;
        }
      }
    width = alloc (fcolumns * sizeof (int));
    memset (width, 0, fcolumns * sizeof (int));

    for (p = fdata; p; p = p->next)
      for (i = 0; i != fcolumns; i++)
      {
        l = strlen (p->s[i]);
        if (l > width[i])
          width[i] = l;
      }
    for (p = fdata; p; p = p->next)
    {
      for (i = 0; i != fcolumns; i++)
      {
        l = width[i] - strlen (p->s[i]);
        if (ftypes[i] == 'x')
        {
          fprintf (pr, p->s[i]);
          while (--l >= 0)
            fputc (' ', pr);
        }
        else
        {
          while (--l >= 0)
            fputc (' ', pr);
          fprintf (pr, p->s[i]);
        }
        if (vieweropts & TWOSPACE)
          fprintf (pr, "  ");
        else
          fprintf (pr, " ");
      }
      fputc ('\n', pr);
    }
    fputc ('\n', pr);
    free (width);
  }
  for (p = fdata; p; p = p->next)
    for (i = 0; i != fcolumns; i++)
      free (p->s[i]);
  freelist (fdata);
  free (fheading);
  headflag = 0;
}

void
fhead (char *s)
{
  static char buf[2];

  if (fcol != strlen (s))
    fprintf (stderr, "Header length mismatch!");
  while (*s)
  {
    buf[0] = *s++;
    fs (buf);
  }
  headflag = 1;
}

void
print_options (player * P)
{
  if (P->opts2 & SHOWOPT)
  {
    fprintf (pr, "\t\tOptions:\n");
    option_on ("Full reports (F) ", FULL, P->opts1);
    option_on ("Forecast         ", FCAST, P->opts2);
    option_on ("Long forecasts   ", LONGFORECAST, P->opts2);
    option_on ("Map printing     ", MAP, P->opts1);
    fprintf (pr, "Size:%6.2f centered X:%6.2f Y:%6.2f\n",
             (double) P->size, (double) P->x, (double) P->y);
    option_on ("Production       ", PROD, P->opts1);
    option_on ("Smartmap         ", MAPPLUS, P->opts1);
    option_on ("Unknown          ", UNKNOWN, P->opts1);
    if (((P->opts1 & MAP) && !(P->opts1 & UNKNOWN)) ||
        (!(P->opts1 & MAP) && (P->opts1 & UNKNOWN)))
      fprintf (pr, "An unknown planet list will be printed\n");
    else
      fprintf (pr, "An unknown planet list will NOT be printed\n");
    option_on ("Battlesum        ", BATTLESUM, P->opts1);
    option_on ("Longbattle       ", LONGBATTLE, P->opts1);
    option_on ("Techs            ", TECHS, P->opts2);
    option_on ("Sortgroups       ", SORTGROUPS, P->opts2);
    option_on ("Sortplanets      ", SORTPLANETS, P->opts2);
    option_on ("Techplus         ", TECHPLUS, P->opts2);
    option_on ("Autounload       ", AUTOUNLOAD, P->opts2);
    option_on ("Upgradecost      ", UPCOST, P->opts2);
    option_on ("FullType         ", FULLTYPE, P->opts1);
    option_on ("Showopts         ", SHOWOPT, P->opts2);
    option_on ("Unsafemax        ",UNSAFEMAX,P->opts2);
    fprintf (pr,"MAX will work on the highest group");
    if (P->opts2 & UNSAFEMAX)
      fprintf (pr," ->NOT<- in hyperspace\n");
    else
    fprintf (pr, "\n");
    fprintf (pr, "\n");
  }
}

/* P = player in whose frame of reference to display the planet */

void
printplanet (planet * p, player * P)
{
  static char *productname[] =
  {
    "CAP",
    "MAT",
    0,
    "Drive",
    "Weapons",
    "Shields",
    "Cargo",
  };

  fs (p->name);
  fs (p->num);
  ff (wrap (p->x - P->homex));  /* GE - relative coordinate fix */
  ff (wrap (p->y - P->homey));
  ff (p->size);
  ff (p->pop);
  ff (p->ind);
  ff (p->resources);
  if (p->producing == PR_SHIP)
    fs (p->producingshiptype->name);
  else
    fs (productname[p->producing]);
  ff (p->col);
  ff (p->cap);
  ff (p->mat);
}

int
numinclass (shiptype *T, player *P, int flag)
{
  int num=0;
  group *g;

  for (g=T->owner->groups;g;g=g->next)
  {
    if (g->type==T)
    {
      if (flag) /* We own it or GM cheat mode */
      {
        num += g->ships;
      }
      else
        if (canseeplanet(P,g->where) && (g->dist==0.0))
        num += g->ships;
    }
  }
  if (num==0)
  {
    battle *B;
    shot *S;

    for (B = battles; B; B = B->next)
    {
      for (S = B->shots; S; S = S->next)
        if (S->attacker == T || S->target == T)
        {
          return (-1);
        }
    }
  }
  return (num);
}

void
printshiptype (shiptype * T, player * P, int flag)
{
  double size;

#ifdef CARRYOVER
  techinfo *ti;

#endif
#ifdef UPGRADE
  int num;
#endif

  fs (T->name);
  ff (T->drive);
  fi (T->nguns);
  ff (T->guns);
  ff (T->shields);
  ff (T->cargo);
  size = typemass (T);
  if (P->opts1 & FULLTYPE)
  {
    ff (size);
    if (size > 0)
    {
      if (flag)
      {          /* We either own this ship, or are in GM overseeing mode */
        ff (P->tech.drive * T->drive * DRIVEMAGIC / size);
        ff (P->tech.shields * T->shields /
            pow (size, .333333333333333) * BATTLEMAGIC);
#ifdef UPGRADE /* The sanity check is mostly a bugfix for the upgrade */
        num=numinclass(T,P,1);
        if (T->numbuilt<num) T->numbuilt=num;
        fi(T->numbuilt);
        fi(numinclass(T,P,1));
#endif
      }
      else
      {

#ifdef CARRYOVER
        for (ti = P->othertechs; ti; ti = ti->next)
        {
          if ( ti->whoose == T->owner ) 
            break;
        }
        assert (ti);    /* We can see a ship, so there must be a tech listing */
        ff (ti->tech.drive * T->drive * DRIVEMAGIC / size);
        ff (ti->tech.shields * T->shields /
            pow (size, .333333333333333) * BATTLEMAGIC);
#else
        ff (0.0);
        ff (0.0);
#endif
#ifdef UPGRADE
        fi (0);
        fi(numinclass(T,P,0));
#endif
      }
    }
    else
    {
      ff (0.0);
      ff (0.0);
    }
  }
}

int
canseegroup (player * P, group * g)
{
  group *g2;

  if (g->dist)
    return 0;
  if (g->where->owner == P)
    return 1;
  for (g2 = P->groups; g2; g2 = g2->next)
    if (!g2->dist && g2->where == g->where)
      return 1;
  return 0;
}

void
printgroup (player * owner, group * g, int printno, int fleetflag)
{
  static char *loadtypename[] =
  {
    "COL",
    "CAP",
    "MAT",
    "---",
  };

/* Printno:
   0: Battle (no battlesum, battle)
   1: Show upgradecost, planet name/num, dist (alien group)
   2: Print group #, Show upgradecost, planet name/num, dist (your group)
   3: Print num left (battle)
*/

#ifdef UPGRADE
  if ((g->fleet) && (fleetflag==0)) return;
#endif
  if (printno == 2)
    fi (ptonum (owner->groups, g));

#ifdef V3
  if (printno == 3)
    fi (g->left);
#endif

  fi (g->ships);
  fs (g->type->name);

  if (vieweropts & TECHS)
  {
    ff (g->tech.drive);
    ff (g->tech.guns);
    ff (g->tech.shields);
    ff (g->tech.cargo);
  }
  else
  {
    ff (g->tech.drive * g->type->drive);
    fi (g->type->nguns);
    ff (g->tech.guns * g->type->guns);
    ff (g->tech.shields * g->type->shields * BATTLEMAGIC /
        pow (shipmass (g), .333333333333333));
    ff (cargospace (g));
  }
  if (g->type->owner==owner)
    fs (loadtypename[g->loadtype]);
  else
    if (g->load>0.0)
      fs ("???");
    else
      fs ("---");
  ff (g->load);
  ff (shipmass (g));
  ff (g->type->drive * g->tech.drive * DRIVEMAGIC / shipmass (g));
  if ((printno == 1) || (printno == 2))
  {
    if (vieweropts & UPCOST)
    {
      ff (upgrade_cost (owner, g));
    }
    if (g->dist)
    {

#ifdef FORECAST
      /* Only print a planet name unless you own it * in forcast mode */
      if (seenlist[ptonum (planets, g->where)])
#else
      if (canseeplanet (owner, g->where))
#endif

        fs (g->where->name);
      else
        fs ("?");
      fs (g->where->num);
      ff (g->dist);
    }
    else
    {

#ifdef FORECAST                 /* Only print a planet name unless you own it
                                 * in forcast mode */
      if (seenlist[ptonum (planets, g->where)])
#endif

        fs (g->where->name);

#ifdef FORECAST
      else
        fs ("?");
#endif

      fs (g->where->num);
      fs ("");
    }
  }
}

void
in_production (planet * p)
{
  double pmass;
  double smass;
  double inprog;

  fs (p->name);
  fs (p->num);
  ff (effective_ind (p));
  ff (produce_mat (p));
  ff (produce_cap (p));
  ff (ftrunc (produce_mass (p)));
  if (p->producing == PR_SHIP)
  {
    fs (p->producingshiptype->name);
    smass = typemass (p->producingshiptype);
    pmass = smass * INDPERSHIP;
    inprog = p->inprogress;
    if (smass > p->mat)         /* <== ERROR WAS HERE */
      pmass += (smass - p->mat) / p->resources;
    ff (pmass);
    ff (inprog);
  }
  else
  {
    fs ("-");
    ff (0.0);
    ff (0.0);
  }
}


int
status (player * P1, player * P2)
{
  alliance *a;
  defensive *d;

  if (P1 == P2)
    return 0;
  else
  {
    for (a = P1->allies; a; a = a->next)
      if (a->ally == P2)
      {
        return PEACE;
      }
    for (d = P1->defend; d; d = d->next)
      if (d->defend == P2)
      {
        return GUARD;
      }
  }
  return WAR;
}

int
scrsize (double a, double b)
{
  int i;

  spf (buf, a);
  i = strlen (buf);
  spf (buf, b);
  return i + 1 + strlen (buf);
}

void
putmap (double x1, double y1, double x2, double y2, double x, double y, int c)
{
  int ix, iy;

  ix = (int) ((x - x1) / (x2 - x1) * MAPWIDTH);
  iy = (int) ((y - y1) / (y2 - y1) * MAPHEIGHT);
  if (ix < 0 || ix >= MAPWIDTH || iy < 0 || iy >= MAPHEIGHT)
    return;
  map[ix][iy] = c;
}

void
report_player_status (double *max, double *pop, double *ind, int *i, int *j,
                      player * P, player * P2, int gm)
{
  /* if gm != 0, then we are the GM (i.e. omnipetent) */
  /*
   * P = player we are generating the report for, P2 = Player we are looking
   * for
   */

  planet *p;
  group *g;
  battle *B;
  participant *PA;
  viewer *V;
  bombing *b;

  *pop = *ind = *max = 0.0;
  *j = *i = 0;

  /* Go through each planet, and if you can see it, add to total */
  for (p = planets; p; p = p->next)
    if ((p->owner == P2) && (gm || (canseeplanet (P, p))))
    {
      *max += p->size;
      *pop += p->pop;
      *ind += p->ind;
      (*i)++;
    }

#ifdef CARRYOVER
  {
    techinfo *t;

    for (t = P->othertechs; t; t = t->next)
      if (t->whoose == P2)
      {
        (*j) = 1;
        return;
      }
  }
#endif

  if (!(gm || *i))
    /* Does player have any groups we can see? */
    for (g = P2->groups; g; g = g->next)
      if (canseegroup (P, g))
        (*j)++;
  for (B = battles; B; B = B->next)
  {
    for (V = B->viewers; V; V = V->next)
      if (V->who == P)
        break;
    if (V)
    {
      for (PA = B->participants; PA; PA = PA->next)
      {
        if (PA->who == P2)
          (*j)++;
      }
    }
  }

  for (b = bombings; b; b = b->next)
  {
    for (V = b->viewers; V; V = V->next)
      if ((b->whoose == P2) && (V->who == P))
        (*j)++;
  }
}

void
guess_techs (player * P, player * P2)
{
  double d, w, s, c;
  group *g;
  battle *B;
  participant *PA;
  viewer *V;

#ifdef CARRYOVER
  techinfo *t;

  for (t = P->othertechs; t; t = t->next)
    if (t->whoose == P2)
      break;
  if (t)
  {
    d = t->tech.drive;
    w = t->tech.guns;
    s = t->tech.shields;
    c = t->tech.cargo;
  }
  else
  {
    d = w = s = c = 1.0;
    t = alloc (sizeof (techinfo));
    t->whoose = P2;
    addlist (&P->othertechs, t);
  }
#else
  d = w = s = c = 1.0;
#endif

  for (g = P2->groups; g; g = g->next)
    if (canseegroup (P, g))
    {
      d = max (g->tech.drive, d);
      w = max (g->tech.guns, w);
      s = max (g->tech.shields, s);
      c = max (g->tech.cargo, c);
    }
  for (B = battles; B; B = B->next)
  {
    for (V = B->viewers; V; V = V->next)
      if (V->who == P)
        break;
    if (V)
    {
      for (PA = B->participants; PA; PA = PA->next)
      {
        if (PA->who == P2)
          for (g = PA->groups; g; g = g->next)
          {
            d = max (g->tech.drive, d);
            w = max (g->tech.guns, w);
            s = max (g->tech.shields, s);
            c = max (g->tech.cargo, c);
          }
      }
    }
  }
  ff (d);
  ff (w);
  ff (s);
  ff (c);

#ifdef CARRYOVER
  for (t = P->othertechs; t; t = t->next)
    if (t->whoose == P2)
      break;
  assert (t);
  t->tech.drive = d;
  t->tech.guns = w;
  t->tech.shields = s;
  t->tech.cargo = c;
#endif
}

void
calc_status_mass (player * P, player * P2, int *num, double *mass, double *techmass, int flag)
{
  double tmass;
  group *g;

  *mass = *techmass = 0.0;
  *num = 0;
  for (g = P2->groups; g; g = g->next)
  {
    if ((P == P2) || (flag || canseegroup (P, g)))
    {
      *num += g->ships;
      tmass = g->ships * typemass (g->type);
      *mass += tmass;
      *techmass += g->ships * (g->tech.drive * g->type->drive +
                               g->tech.guns * weaponmass (g->type) +
                               g->tech.shields * g->type->shields +
                               g->tech.cargo * g->type->cargo);
    }
  }
}

void
print_status (player * P, int num)

{
  player *P2;
  double max, pop, ind;
  int i, j;

  if (P->opts2 & TECHPLUS)
  {
    fbegin ("Status of Players", "xfffffffixiff");
    fhead ("NDWSCMPI#R&MT");
  }
  else
  {
    fbegin ("Status of Players", "xfffffffix");
    fhead ("NDWSCMPI#R");
  }
  report_player_status (&max, &pop, &ind, &i, &j, P, P, 0);
  fs (P->name);
  ff (P->tech.drive);
  ff (P->tech.guns);
  ff (P->tech.shields);
  ff (P->tech.cargo);
  ff (max);
  ff (pop);
  ff (ind);
  fi (i);
  fs ("");
  if (P->opts2 & TECHPLUS)
  {
    int num;
    double mass, techmass;

    calc_status_mass (P, P, &num, &mass, &techmass, 0);
    fi (num);
    ff (mass);
    ff (techmass);
  }
  if (num)
  {
    for (P2 = players; P2; P2 = P2->next)
    {
      /*
       * If you cannot see any planets or ships belonging to a player, don't
       * show anything about them
       */
      if (P != P2)
      {
        report_player_status (&max, &pop, &ind, &i, &j, P, P2, 0);
        if (i || j)
        {
          fs (P2->name);
          guess_techs (P, P2);  /* Determine & print tech info */
          ff (max);
          ff (pop);
          ff (ind);
          fi (i);
          switch (status (P, P2))
          {
          case PEACE:
            fs ("P");
            break;
          case GUARD:
            fs ("G");
            break;
          case WAR:
            fs ("W");
            break;
          }
          if (P->opts2 & TECHPLUS)
          {
            int num;
            double mass, techmass;

            calc_status_mass (P, P2, &num, &mass, &techmass, 0);
            fi (num);
            ff (mass);
            ff (techmass);
          }
        }
      }
    }
  }

#ifdef CARRYOVER
  else
  {
    techinfo *t;

    for (t = P->othertechs; t; t = t->next)
      if (t->whoose)
      {
        fs (t->whoose->name);
        ff (t->tech.drive);
        ff (t->tech.guns);
        ff (t->tech.shields);
        ff (t->tech.cargo);
        ff (0.0);
        ff (0.0);
        ff (0.0);
        fi (0);
        switch (status (P, t->whoose))
        {
        case PEACE:
          fs ("P");
          break;
        case GUARD:
          fs ("G");
          break;
        case WAR:
          fs ("W");
          break;
        }
        if (P->opts2 & TECHPLUS)
        {
          fi (0);
          ff (0.0);
          ff (0.0);
        }
      }
  }
#endif

  fend ();
}

void
print_shiptypes (player * P, int flag)
{
  player *P2;
  group *g;
  shiptype *T;
  battle *B;
  viewer *V;
  participant *PA;
  planet *p;

  if (P->opts1 & FULLTYPE)
  {
    fbegin ("Your Ship Types", "xfiffffffii");
    fhead ("NDAWSCMSs#X");
  }
  else
  {
    fbegin ("Your Ship Types", "xfifff");
    fhead ("NDAWSC");
  }
  for (T = shiptypes; T; T = T->next)
    if (T->owner == P)
      printshiptype (T, P, 1);
  fend ();

  if (flag)
  {
    for (P2 = players; P2; P2 = P2->next)
      if (P2 != P)
      {
        for (T = shiptypes; T; T = T->next)
          T->flag = 0;
        for (B = battles; B; B = B->next)
        {
          for (V = B->viewers; V; V = V->next)
            if (V->who == P)
              break;
          if (V)
          {
            for (PA = B->participants; PA; PA = PA->next)
              if (PA->who == P2)
                break;
            if (PA)
              for (g = PA->groups; g; g = g->next)
                g->type->flag = 1;
          }
        }
        for (g = P2->groups; g; g = g->next)
          if (canseegroup (P, g))
            g->type->flag = 1;
        for (p = planets; p; p = p->next)
          if (p->owner == P2 && p->producing == PR_SHIP && canseeplanet (P, p))
            p->producingshiptype->flag = 1;
        strcpy (buf, P2->name);
        ckunderscores (buf);
        strcat (buf, " Ship Types");
        /*sprintf (buf, "%s Ship Types", P2->name);*/
        if (P->opts1 & FULLTYPE)
        {
          fbegin (buf, "xfiffffffii");
          fhead ("NDAWSCMSs#X");
        }
        else
        {
          fbegin (buf, "xfifff");
          fhead ("NDAWSC");
        }
        for (T = shiptypes; T; T = T->next)
          if (T->flag && T->owner == P2)
            printshiptype (T, P, 0);
        fend ();
      }
  }
}

void
print_player_groups_in_battle (player * P, participant * PA)
{
  group *g;
  player *P2;

#ifdef V3
  if (P->opts1 & BATTLESUM)
  {
    if (P->opts2 & TECHS)
    {
      fbegin (buf, "iixffffxfff");
      fhead ("R#TDWSCTQMS");
    }
    else
    {
      fbegin (buf, "iixfifffxfff");
      fhead ("R#TDAWSCTQMS");
    }
    for (g = PA->groups; g; g = g->next)
      printgroup (P, g, 3,1);
    fend ();
  }
  else
#endif

  {
    if (P->opts2 & TECHS)
    {
      fbegin (buf, "ixffffxfff");
      fhead ("#TDWSCTQMS");
    }
    else
    {
      fbegin (buf, "ixfifffxfff");
      fhead ("#TDAWSCTQMS");
    }
    for (g = PA->groups; g; g = g->next)
      printgroup (P2, g, 0,1);
    fend ();
  }
}

void
print_battles (player * P)
{
  player *P2;
  shot *S;
  battle *B;
  viewer *V;
  participant *PA;

  for (B = battles; B; B = B->next)
  {
    for (V = B->viewers; V; V = V->next)
      if (V->who == P)
        break;
    if (V)
    {
      strcpy (buf,B->where->name);
      ckunderscores (buf);
      if (canseeplanet (P, B->where))
        fprintf (pr, "\t\tBattle at %s (%s)\n\n", B->where->num, buf);
      else
        fprintf (pr, "\t\tBattle at %s\n\n", B->where->num);
      for (PA = B->participants; PA; PA = PA->next)
      {
        if (PA->who == P)
        {
          sprintf (buf, "Your Groups");
          print_player_groups_in_battle (P, PA);
          break;
        }
      }
      for (PA = B->participants; PA; PA = PA->next)
      {
        P2 = PA->who;
        if (P2 != P)
        {
          strcpy (buf,P2->name);
          ckunderscores (buf);
          strcat (buf, " Groups");
          /*sprintf (buf, "%s Groups", P2->name);*/
          print_player_groups_in_battle (P, PA);
        }
      }

#ifndef V3
      /*
       * Note: This code is not going to be used because it gives away info
       * that wasn't available eariler in the game. Uncomment it if you wish
       */
      /*
      if (P->opts1 & BATTLESUM) 
      { 
        for (PA = B->participants; PA; PA = PA->next) 
        { 
          P2 = PA->who; 
          sprintf (buf, "%s Remaining Groups", P2 == P ? "Your" : P2->name); 
          fbegin (buf, "xi"); 
          fhead ("T#"); 
          for (g = PA->who->groups; g; g = g->next) 
            if (g->where == B->where && !g->dist) 
            { 
              fs (g->type->name); 
              fi (g->ships); 
            } 
            fend (); 
        }     
      }
      */
#endif

      if (!(P->opts1 & LONGBATTLE))
        /* print the blow-by-blow, but only for those that care... */
      {
        fbegin ("", "xxxxxx");
        for (S = B->shots; S; S = S->next)
        {
          fs (S->attacker->owner->name);
          fs (S->attacker->name);
          fs ("fires on");
          fs (S->target->owner->name);
          fs (S->target->name);
          fs (S->kill ? ":  Destroyed" : ":  Shields");
        }
        fend ();
      }
    }
  }
}

void
print_bombings (player * P)
{
  bombing *b;
  battle *B;
  viewer *V;

  fbegin ("Bombings", "xxxxfffff");
  fhead ("WO#NPIC$M");
  for (b = bombings; b; b = b->next)
  {
    for (V = b->viewers; V; V = V->next)
      if (V->who == P)
        break;
    if (V)                      /* Saw the bombing */
    {
      for (B = battles; B; B = B->next)
        if (B->where == b->where)
          break;
      if (B)                    /* Was a battle */
      {
        for (V = B->viewers; V; V = V->next)
          if (V->who == P)
            break;
        if (V)                  /* Saw the battle */
        {                       /* So print bomber info */
          fs (b->who->name);
        }
        else
          fs ("?");             /* Didn't see battle */
      }
      else if (canseeplanet (P, b->where))      /* No battle, but you did it */
        fs (b->who->name);
      else
        fs ("?");               /* Was no battle */
      fs (b->whoose->name);
      fs (b->where->num);
      fs (b->where->name);
      ff (b->pop);
      ff (b->ind);
      ff (b->col);
      ff (b->cap);
      ff (b->mat);
    }
  }
  fend ();
}

void
print_incoming (player * P, planet * p)
{
  player *P2;
  group *g;

  fbegin ("Incoming Groups", "xxxxfff");
  fhead ("ONDNRSM");
  for (P2 = players; P2; P2 = P2->next)
    if (P2 != P)
      for (g = P2->groups; g; g = g->next)
        if (g->dist && g->where->owner == P &&
            (g->ships * shipmass (g)) > 1.0)
          /* Local report and planet, or global */
          if ((g->where == p) || p == NULL)
          {
            if (canseeplanet (P, g->from))
              fs (g->from->name);
            else
              fs ("?");
            fs (g->from->num);
            fs (g->where->name);
            fs (g->where->num);
            ff (g->dist);
            ff (g->type->drive * g->tech.drive * DRIVEMAGIC / shipmass (g));
            ff (shipmass (g) * g->ships);
          }
  fend ();
}

void
domap (player * P)
{
  int i, j;
  double x1, x2, y1, y2;
  planet *p;

  x1 = P->x - P->size / 2;
  x2 = P->x + P->size / 2;
  y1 = P->y - P->size / 2;
  y2 = P->y + P->size / 2;

  rpf (x1);
  fputc (',', pr);
  rpf (y1);
  for (i = MAPWIDTH - scrsize (x1, y1) - scrsize (x2, y1); i != 0; i--)
    fputc (' ', pr);
  rpf (x2);
  fputc (',', pr);
  rpf (y1);
  fputc ('\n', pr);
  for (i = 0; i < MAPWIDTH; i++)
    fputc ('-', pr);
  fputc ('\n', pr);

  memset (map, ' ', sizeof (map));

#ifdef FORECAST
  /* Planets you can't see */
  for (p = planets; p; p = p->next)
    if (!seenlist[ptonum (planets,p)])
      putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
              wrap (p->y - P->homey), '?');

  /* unowned planets you can see */
  for (p = planets; p; p = p->next) /* Alien col problem */
    if (seenlist[ptonum (planets,p)])
      putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
              wrap (p->y - P->homey), '?');
/*
  for (p = planets; p; p = p->next)
  {
    if ((!p->owner) && seenlist[ptonum (planets, p)])
      if ((P->opts1 & MAPPLUS) && (p->size <= ALMOSTZERO))
        putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
                wrap (p->y - P->homey), '0');
      else if (P->opts1 & MAPPLUS)
        putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
                wrap (p->y - P->homey), '@');
      else
        putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
                wrap (p->y - P->homey), 'o');
  }
*/

  /* Alien planets */
/*
  for (p = planets; p; p = p->next)
    if (p->owner && p->owner != P && seenlist[ptonum (planets, p)])

      if (P->opts1 & MAPPLUS)
      {
        putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
                wrap (p->y - P->homey), p->owner->name[0]);
      }
      else
      {
        putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
                wrap (p->y - P->homey), '+');
      }
*/

  /* your planets */
  for (p = planets; p; p = p->next)
    if ((p->owner == P) && seenlist[ptonum (planets, p)])
      putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
              wrap (p->y - P->homey), '*');

#else
  /* planets you don't know about becuase you can't see them */
  for (p = planets; p; p = p->next)
    if (!(canseeplanet (P, p)))
      putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
              wrap (p->y - P->homey), '?');

  /* Battles you can see. Ones you survived will be clobbered */

  if (P->opts1 & MAPPLUS)
    for (p = planets; p; p = p->next)
    {
      battle *B;
      viewer *V;

      for (B = battles; B; B = B->next)
      {
        if (B->where == p)
          for (V = B->viewers; V; V = V->next)
            if (V->who == P)
            {
              putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
                      wrap (p->y - P->homey), '#');
              break;
            }
      }
    }

  /* unowned planets you can see */
  for (p = planets; p; p = p->next)
  {
    if ((!p->owner) && canseeplanet (P, p))
      if ((P->opts1 & MAPPLUS) && (p->size <= ALMOSTZERO))
        putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
                wrap (p->y - P->homey), '0');
      else if (P->opts1 & MAPPLUS)
        putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
                wrap (p->y - P->homey), '@');
      else
        putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
                wrap (p->y - P->homey), 'o');
  }

  /* owned by someone else planets you can see */
  for (p = planets; p; p = p->next)
    if (p->owner && p->owner != P && canseeplanet (P, p))

      if (P->opts1 & MAPPLUS)
      {
        putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
                wrap (p->y - P->homey), p->owner->name[0]);
      }
      else
      {
        putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
                wrap (p->y - P->homey), '+');
      }

  /* your planets */
  for (p = planets; p; p = p->next)
    if (p->owner == P)
      putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
              wrap (p->y - P->homey), '*');
#endif
  for (i = 0; i < MAPHEIGHT; i++)
  {
    for (j = 0; j < MAPWIDTH; j++)
      fputc (map[j][i], pr);
    fputc ('\n', pr);
  }

  for (i = 0; i < MAPWIDTH; i++)
    fputc ('-', pr);
  fputc ('\n', pr);
  rpf (x1);
  fputc (',', pr);
  rpf (y2);
  for (i = MAPWIDTH - scrsize (x1, y2) - scrsize (x2, y2); i > 0; i--)
    fputc (' ', pr);
  rpf (x2);
  fputc (',', pr);
  rpf (y2);
  fprintf (pr, "\n\n");
}                               /* end of map section */

void
print_groups_at_planet (player * P, planet * p)
{
  group *g;

#ifndef PREPROC
  player *P3;

#endif

  if (P->name[0])               /* Player Name set, i.e. not GM cheat mode */
  {
    sprintf (buf, "Your groups at %s", p->name);
    if ((P->opts2 & TECHS) && (P->opts2 & UPCOST))
    {
      fbegin (buf, "iixffffxffffxxf");
      fhead ("G#TDWSCTQMSIDLR");
    }
    else if (P->opts2 & UPCOST)
    {
      fbegin (buf, "iixfifffxffffxxf");
      fhead ("G#TDAWSCTQMSIDLR");
    }
    else if (P->opts2 & TECHS)
    {
      fbegin (buf, "iixffffxfffxxf");
      fhead ("G#TDWSCTQMSDLR");
    }
    else
    {
      fbegin (buf, "iixfifffxfffxxf");
      fhead ("G#TDAWSCTQMSDLR");
    }

    for (g = P->groups; g; g = g->next)
      if (g->where == p)
        printgroup (P, g, 2,0);
    fend ();
    print_fleet_at_planet (P,p);
  }

#ifndef FORECAST
  /* print all alien groups at the planet */

  for (P3 = players; P3; P3 = P3->next)
    if ((P3 != P) && canseeplanet (P3, p))
    {                           /* then P3 has ships there we should list */
      strcpy (buf2, P3->name);
      ckunderscores (buf2);
      sprintf (buf, "%s groups at ", buf2);
      strcpy (buf2, p->name);
      ckunderscores (buf2);
      strcat (buf,buf2);
      if (P->opts2 & TECHS)
      {
        fbegin (buf, "ixffffxfffxxf");
        fhead ("#TDWSCTQMSDL ");
      }
      else
      {
        fbegin (buf, "ixfifffxfffxxf");
        fhead ("#TDAWSCTQMSDL ");
      }

      {
        int foo = vieweropts;

        if (vieweropts & UPCOST)
          vieweropts = vieweropts ^ UPCOST;
        for (g = P3->groups; g; g = g->next)
        {
          if ((g->where == p) && (g->dist == 0.0) && P)
            printgroup (P3, g, 1,1);
          if ((g->where == p) && P == NULL)     /* GM Cheat mode */
            printgroup (P3, g, 2,1);
        }
        vieweropts = foo;
      }
      fend ();
    }
#endif
}


void
print_unowned_planets (player * P)
{
  planet *p;
  char buf2[MAXTEXT];

  for (p = planets; p; p = p->next)
    if ((p->owner == NULL) && canseeplanet (P, p))
    {
      /* print the planet */

      strcpy (buf2,p->name);
      ckunderscores (buf2);
      sprintf (buf, "\nFull Report on System %s\n", buf2);
      /*sprintf (buf, "\nFull Report on System %s\n", p->name);*/

      fbegin (buf, "xxffff");
      fhead ("N#XYSR");
      fs (p->name);
      fs (p->num);
      ff (wrap (p->x - P->homex));      /* GE: relative coordinate fix */
      ff (wrap (p->y - P->homey));
      ff (p->size);
      ff (p->resources);
      fend ();

      print_groups_at_planet (P, p);
    }
}

void
print_partial_reports (player * P)
{
  /* planets you can't see but are on the way to */
  int lost = 0;
  int *lostg;
  group *g;
  planet *p;

  lostg = alloc (nplanets * sizeof (int));

  for (lost = 0; lost < nplanets; lost++)
    lostg[lost] = 0;

  lost = 0;
  for (g = P->groups; g; g = g->next)   /* Find MIA groups */
#ifdef FORECAST
    if (g->where->owner != P)
#else
    if ((g->dist > 0.0) && !(canseeplanet (P, g->where)))
#endif
    {
      lostg[ptonum (planets, g->where)]++;
      lost++;
    }
  if (lost)                     /* Are there MIA Groups? */
  {
    for (p = planets; (p && lost); p = p->next)
      if (lostg[ptonum (planets, p)])   /* print the planet */
      {
        sprintf (buf, "\nPartial Report on System %s\n", p->num);
        fbegin (buf, "xff");
        fhead ("#XY");
        fs (p->num);
        ff (wrap (p->x - P->homex));
        ff (wrap (p->y - P->homey));
        fend ();

        /* print all groups at the planet */
        sprintf (buf, "Your groups approaching %s", p->num);
        if ((P->opts2 & TECHS) && (P->opts2 & UPCOST))
        {
          fbegin (buf, "iixffffxffffxxf");
          fhead ("G#TDWSCTQMSIDLR");
        }
        else if (P->opts2 & UPCOST)
        {
          fbegin (buf, "iixfifffxffffxxf");
          fhead ("G#TDAWSCTQMSIDLR");
        }
        else if (P->opts2 & TECHS)
        {
          fbegin (buf, "iixffffxfffxxf");
          fhead ("G#TDWSCTQMSDLR");
        }
        else
        {
          fbegin (buf, "iixfifffxfffxxf");
          fhead ("G#TDAWSCTQMSDLR");
        }

        for (g = P->groups; g; g = g->next)
          if (g->where == p)
          {
            printgroup (P, g, 2,1);
            lost--;
          }
        fend ();
        print_fleet_at_planet (P,p);
      }
  }
  free (lostg);
}

#ifdef KCMD
void
print_selective_defenses (player * P)
{
  planetdefense *df;

  fbegin ("Selective Planet Defenses", "xxxx");
  fhead ("N#PS");
  for (df = defender; df; df = df->next)
    if (df->planet)
      if (df->planet->owner == P)
      {
        fs (df->planet->name);
        fs (df->planet->num);
        fs (df->defender->name);
        switch (df->dipstat)
        {
        case PEACE:
          fs ("Peace");
          break;
        case WAR:
          fs ("War");
          break;
        default:
          assert (0);
        }
      }
  fend ();
}

void
print_selective_def_at_p (player * P, planet * p)
{
  planetdefense *df;

  fbegin ("Selective Planet Defense", "xxxx");
  fhead ("N#PS");
  for (df = defender; df; df = df->next)
    if (df->planet)
      if ((df->planet->owner == P) && (df->planet == p))
      {
        fs (df->planet->name);
        fs (df->planet->num);
        fs (df->defender->name);
        switch (df->dipstat)
        {
        case PEACE:
          fs ("Peace");
          break;
        case WAR:
          fs ("War");
          break;
        default:
          assert (0);
        }
      }
  fend ();
}
#endif

void
print_routes (player * P)
{
  planet *p;
  int i;

  fbegin ("Your Routes", "xxxxx");
  fhead ("NC$ME");
  for (p = planets; p; p = p->next)
    if (p->owner == P && !zeromem (p->routes, sizeof (p->routes)))
    {
      fs (p->name);
      for (i = 0; i < MAXCARGO; i++)
        if (p->routes[i])
          if (p->routes[i]->owner == P)
            fs (p->routes[i]->name);
          else
            fs (p->routes[i]->num);
        else
          fs ("-");
    }
  if (P->opts2 & AUTOUNLOAD)
  {
    fs ("AUTO");
    fs ("UNLOAD");
    fs ("IS");
    fs ("CURRENTLY");
    fs ("SET");
  }
  fend ();
}

void
print_all_your_groups (player * P)
{
  group *g;

  if ((P->opts2 & TECHS) && (P->opts2 & UPCOST))
  {
    fbegin ("Your Groups", "iixffffxffffxxf");
    fhead ("G#TDWSCTQMSIDLR");
  }
  else if (P->opts2 & UPCOST)
  {
    fbegin ("Your Groups", "iixfifffxffffxxf");
    fhead ("G#TDAWSCTQMSIDLR");
  }
  else if (P->opts2 & TECHS)
  {
    fbegin ("Your Groups", "iixffffxfffxxf");
    fhead ("G#TDWSCTQMSDLR");
  }
  else
  {
    fbegin ("Your Groups", "iixfifffxfffxxf");
    fhead ("G#TDAWSCTQMSDLR");
  }
  for (g = P->groups; g; g = g->next)
    printgroup (P, g, 2,0);
  fend ();
}

#ifdef UPGRADE
void
print_your_fleets (player * P)
{
  group *g;
  fleetname *fl;
  char buf2[80];
  char buf3[80];

  for (fl = fleets; fl; fl = fl->next)
    if (P == fl->owner)
    {
      strcpy(buf3,fl->name);
      ckunderscores (buf3);
      sprintf (buf2, "Fleet %s (speed %.2f)", buf3, fl->fleetspeed);
      if ((P->opts2 & TECHS) && (P->opts2 & UPCOST))
      {
        fbegin (buf2, "iixffffxffffxxf");
        fhead ("G#TDWSCTQMSIDLR");
      }
      else if (P->opts2 & UPCOST)
      {
        fbegin (buf2, "iixfifffxffffxxf");
        fhead ("G#TDAWSCTQMSIDLR");
      }
      else if (P->opts2 & TECHS)
      {
        fbegin (buf2, "iixffffxfffxxf");
        fhead ("G#TDWSCTQMSDLR");
      }
      else
      {
        fbegin (buf2, "iixfifffxfffxxf");
        fhead ("G#TDAWSCTQMSDLR");
      }
      for (g = P->groups; g; g = g->next)
        if (g->fleet == fl)
          printgroup (P, g, 2,1);
      fend ();
    }
}

void
print_fleet_at_planet (player *P, planet *p)
{
  group *g,*g2;
  fleetname *fl;
  char buf3[MAXTEXT];

  for (fl = fleets; fl; fl=fl->next)
    if (P==fl->owner)
    {
      for (g=P->groups;g;g=g->next)
      {
        if (g->fleet==fl) 
          if (g->where!=p) /* Fleet isn't at planet, bail */
            break;
          else
          {
            strcpy(buf3,fl->name);
            ckunderscores (buf3);
            sprintf (buf2, "Fleet %s (speed %.2f)", buf3, fl->fleetspeed);
            /*sprintf (buf2, 
              "Fleet %s (speed %.2f)", fl->name, fl->fleetspeed);*/
            if ((P->opts2 & TECHS) && (P->opts2 & UPCOST))
            {
              fbegin (buf2, "iixffffxffffxxf");
              fhead ("G#TDWSCTQMSIDLR");
            }
            else if (P->opts2 & UPCOST)
            {
              fbegin (buf2, "iixfifffxffffxxf");
              fhead ("G#TDAWSCTQMSIDLR");
            }
            else if (P->opts2 & TECHS)
            {
              fbegin (buf2, "iixffffxfffxxf");
              fhead ("G#TDWSCTQMSDLR");
            }
            else
            {
              fbegin (buf2, "iixfifffxfffxxf");
              fhead ("G#TDAWSCTQMSDLR");
            }
            for (g2 = g; g2; g2 = g2->next)
              if (g2->fleet == fl)
                printgroup (P, g2, 2,1);
            fend ();
            break;
          }
      }
      /*if (g) break;*/
    }
}
#endif

void
print_alien_groups (player * P)
{
  player *P2;
  group *g;

  for (P2 = players; P2; P2 = P2->next)
    if (P2 != P)
    {
      strcpy(buf2,P2->name);
      ckunderscores (buf2);
      sprintf (buf, "%s Groups", buf2);
      /*sprintf (buf, "%s Groups", P2->name);*/
      if (P->opts2 & TECHS)
      {
        fbegin (buf, "ixffffxfffxxf");
        fhead ("#TDWSCTQMSDL ");
      }
      else
      {
        fbegin (buf, "ixfifffxfffxxf");
        fhead ("#TDAWSCTQMSDL ");
      }
      {
        int oldopts = vieweropts;

        if (vieweropts & UPCOST) /* Upgradecost for alien groups not supported*/
          vieweropts = vieweropts ^ UPCOST;
        for (g = P2->groups; g; g = g->next)
          if (canseegroup (P, g))
            printgroup (P2, g, 1,1);
        fend ();
        vieweropts = oldopts;
      }
    }
}
void
print_alien_planets (player * P)
{
  planet *p;
  player *P2;

  /* alien planets you can see */

  for (P2 = players; P2; P2 = P2->next)
    if (P2 != P)
    {
      strcpy(buf2,P2->name);
      ckunderscores (buf2);
      sprintf (buf, "%s Systems", buf2);
      /*sprintf (buf, "%s Systems", P2->name);*/
      fbegin (buf, "xxffffffxfff");
      fhead ("N#XYSPIRPC$M");
      for (p = planets; p; p = p->next)
        if (p->owner == P2 && canseeplanet (P, p))
          printplanet (p, P);
      fend ();
    }
}

void
print_full_planet (player * P, planet * p)
{
  int i;
  char buf1[MAXTEXT];
  char buf2[MAXTEXT];

  strcpy(buf1,p->name);
  ckunderscores (buf1);
  strcpy(buf2,p->owner->name);
  ckunderscores (buf2);
  if (p->owner == P)
    sprintf (buf, "\nFull Report on System %s\n", buf1);
  else
    sprintf (buf, "\nFull Report on System %s (%s)\n", buf1,buf2);

  fbegin (buf, "xxffffffxfff");
  fhead ("N#XYSPIRPC$M");
  printplanet (p, P);
  fend ();
  if (p->owner == P)
  {
    if (P->opts1 & PROD)
    {
      /* Print production info */
      fbegin ("Ship in production", "xxffffxff");
      fhead ("N#IM$STCU");
      in_production (p);
      fend ();
    }

    fbegin ("Routes", "xxxxx");
    fhead ("NC$ME");
    if (!zeromem (p->routes, sizeof (p->routes)))
    {
      fs (p->name);
      for (i = 0; i < MAXCARGO; i++)
        if (p->routes[i])
          fs (p->routes[i]->name);
        else
          fs ("-");
    }
    fend ();

#ifdef KCMD
    print_selective_def_at_p (P, p);
#endif

    print_incoming (P, p);      /* print all incoming groups to the planet */
  }
  print_groups_at_planet (P, p);
}

void
print_full_your_planet (player * P)
{
  sorted *s;
  planet *p;

  if (P->opts2 & SORTPLANETS)
    for (s = sorted_planets, p = s->p; s; s = s->next)
    {
      p = s->p;
      if (p->owner == P)
        print_full_planet (P, p);
    }
  else
    for (p = planets; p; p = p->next)
      if (p->owner == P)
        print_full_planet (P, p);
}

void
print_full_alien_planet (player * P)
{
  player *P2;
  sorted *s;
  planet *p;

  /* alien planets you can see (full reports with groups) */

  for (P2 = players; P2; P2 = P2->next)
    if (P2 != P)
      if (P->opts2 & SORTPLANETS)
        for (s = sorted_planets, p = s->p; s; s = s->next)
        {
          p = s->p;
          if ((p->owner == P2) && canseeplanet (P, p))
            print_full_planet (P, p);
        }
      else
        for (p = planets; p; p = p->next)
          if ((p->owner == P2) && canseeplanet (P, p))
            print_full_planet (P, p);
}

void
print_uninhabited_planets (player * P)
{
  planet *p;

  fbegin ("Uninhabited Systems", "xxffff");
  fhead ("N#XYSR");
  for (p = planets; p; p = p->next)
    if (!p->owner && canseeplanet (P, p))
    {
      fs (p->name);
      fs (p->num);
      ff (wrap (p->x - P->homex));      /* GE: relative coordinate fix */
      ff (wrap (p->y - P->homey));
      ff (p->size);
      ff (p->resources);
    }
  fend ();
}

void
print_unknown_planets (player * P)
{
  planet *p;

  fbegin ("Unknown Systems", "xff");
  fhead ("#XY");
  for (p = planets; p; p = p->next)
    if ((p->owner != P) && !canseeplanet (P, p) &&
        (fabs (wrap (p->x - P->homex) - P->x) < (double) (P->size / 2)) &&
        (fabs (wrap (p->y - P->homey) - P->y) < (double) (P->size / 2)))
    {
      fs (p->num);
      ff (wrap (p->x - P->homex));      /* GE: relative coordinate fix */
      ff (wrap (p->y - P->homey));
    }
  fend ();
}

#ifdef FULL_REPORTS
void
full_report_header (void)
{
  double ver = VER;
  FILE *pr2;
  char gamename[80];
  char txt[80];

  pr2 = open ("messages", O_RDONLY);
  if (pr2 >= 0)
  {
    /*
       * Want: e-mail @; next due date; subject; messages;
       */
    fscanf (pr2, "%s", gamename);
    fprintf (pr, "\t\tGame %s %s Report for Galaxy Turn %d\n\n", gamename,
             P->name, turn);

    fprintf (pr, "\n");
    fprintf (pr, "Code Version %4.2f\n", ver);
    fprintf (pr, "\n");

    while (fscanf (pr2, "%s", txt) != EOF)
    {
      fprintf (pr, "%s", txt);
    }
    fclose (pr2);
  }
  else
  {
    fprintf (stderr, "messages file is missing!\n");
    fprintf (pr, "\t\t%s Report for Galaxy Turn %d\n\n", P->name, turn);
  }
}
#endif

void
report (player * P)
{
  planet *p;

  vieweropts = P->opts2;

  if (P->lastorders < turn)
  {
    fprintf (pr, "\t\tWarning!!!\nOrders were last received for turn %d\n\n\n",
             P->lastorders);
  }
  print_options (P);

#ifdef FULL_REPORTS
  full_report_header ();
#else
#ifdef GAMENAME
  strcpy (buf, P->name);
  ckunderscores (buf);
  fprintf (pr, "\t\tBlind Galaxy game %s Report for %s, Turn %d\n\n", gamename,buf, turn);
#else
  strcpy (buf, P->name);
  ckunderscores (buf);
  fprintf (pr, "\t\t%s Report for Galaxy Turn %d\n\n", buf, turn);
#endif
#endif

  print_status (P, 1);          /* Do the Status section */
  print_shiptypes (P, 1);       /* Print out visible ship types */
  print_battles (P);
  print_bombings (P);

  if (P->opts1 & MAP)
    domap (P);

  print_incoming (P, NULL);     /* Incoming report section */

  fbegin ("Your Systems", "xxffffffxfff");
  fhead ("N#XYSPIRPC$M");
  for (p = planets; p; p = p->next)
    if (p->owner == P)
      printplanet (p, P);
  fend ();

  if (P->opts1 & PROD)
  {
    fbegin ("Ships in Production", "xxffffxff");
    fhead ("N#IM$STCU");
    for (p = planets; p; p = p->next)
      if (p->owner == P)
        in_production (p);
    fend ();
  }
  print_routes (P);

#ifdef KCMD
  print_selective_defenses (P);
#endif

  print_alien_planets (P);
  print_uninhabited_planets (P);
  if (((P->opts1 & MAP) && !(P->opts1 & UNKNOWN)) ||
      (!(P->opts1 & MAP) && (P->opts1 & UNKNOWN)))
    print_unknown_planets (P);

  print_all_your_groups (P);

#ifdef UPGRADE
  print_your_fleets (P);
#endif

  print_alien_groups (P);

  /* GE: planet-group matrix */

  /* your planets */
  if (P->opts1 & FULL)
  {
    print_full_your_planet (P);
    print_full_alien_planet (P);
    print_unowned_planets (P);
    print_partial_reports (P);
  }
  if (pr && (pr != stdout))
    fclose (pr);
}

#ifdef FORECAST
void
forecast_report (player * P)
{
  planet *p;
  sorted *s;


  vieweropts = P->opts2;

  /* Uncomment out the block below (and comment out the line after it
  if you want unique forecast report names) */
#ifdef FCASTNAMES
  {
    int i; 

    i = strlen (P->name);
    while (i && P->name[i - 1] != ' ' && P->name[i - 1] != '\'') i--;
    sprintf (buf, "%s.F", P->name + i);
    pr = fopen (buf,"w");
  }
#else
  pr = fopen ("forecast.F", "w");
#endif
  if (pr == 0)
  {
    printf ("Can't open %s\n", buf);
    exit (1);
  }

  print_options (P);

  fprintf (pr, "\t\t%s FORECAST for Galaxy Turn %d\n\n", P->name, turn);
  print_status (P, 0);
  print_shiptypes (P, 0);
  if (P->opts1 & MAP)
    domap (P);

  fbegin ("Your Systems", "xxffffffxfff");
  fhead ("N#XYSPIRPC$M");
  for (p = planets; p; p = p->next)
    if ((p->owner == P) && seenlist[ptonum (planets, p)])
      printplanet (p, P);
  fend ();

  if (P->opts1 & PROD)
  {
    fbegin ("Ships in Production", "xxffffxff");
    fhead ("N#IM$STCU");
    for (p = planets; p; p = p->next)
      if (p->owner == P)
        in_production (p);
    fend ();
  }

  print_routes (P);

#ifdef KCMD
  print_selective_defenses (P);
#endif

  if (((P->opts1 & MAP) && !(P->opts1 & UNKNOWN)) ||
      (!(P->opts1 & MAP) && (P->opts1 & UNKNOWN)))
  {
    fbegin ("Possible Unknown Systems", "xff");
    fhead ("#XY");
    for (p = planets; p; p = p->next)
      if (!((seenlist[ptonum (planets, p)]) && (p->owner == P)) &&
          (fabs (wrap (p->x - P->homex) - P->x) < (double) (P->size / 2)) &&
          (fabs (wrap (p->y - P->homey) - P->y) < (double) (P->size / 2)))
      {
        fs (p->num);
        ff (wrap (p->x - P->homex));    /* GE: relative coordinate fix */
        ff (wrap (p->y - P->homey));
      }
    fend ();
  }

  print_all_your_groups (P);
#ifdef UPGRADE
  print_your_fleets (P);
#endif

  if ((P->opts1 & FULL) && (P->opts2 & LONGFORECAST))
  {
    if (P->opts2 & SORTPLANETS)
      for (s = sorted_planets, p = s->p; s; s = s->next)
      {
        p = s->p;
        if ((seenlist[ptonum (planets, p)]) && (p->owner == P))
          print_full_planet (P, p);
      }
    else
      for (p = planets; p; p = p->next)
        if ((seenlist[ptonum (planets, p)]) && (p->owner == P))
          print_full_planet (P, p);
    print_partial_reports (P);
  }

  if (pr && (pr != stdout))
    fclose (pr);
}
#endif

/* This block is GM snooping code */

void
showfull (void)
{
  player *P;
  player *P3;
  planet *p;
  sorted *s;
  group *g;

  vieweropts = 0;
  P = alloc (sizeof (player));
  memset (P, 0, sizeof (*P));
  for (s = sorted_planets; s; s = s->next)
  {
    p = s->p;
    /* print the planet */

    sprintf (buf, "\nFull Report on System %s\n", p->name);

    fbegin (buf, "xxffffffxfff");
    fhead ("N#XYSPIRPC$M");
    printplanet (p, P);
    fend ();

    /* print all groups at/en route to the planet */

    for (P3 = players; P3; P3 = P3->next)
      if (canseeplanet (P3, p))
      {
        sprintf (buf, "%s groups at %s", P3->name, p->name);
        fbegin (buf, "iixfifffxfffxxf");
        fhead ("G#TDAWSCTQMSDLR");

        for (g = P3->groups; g; g = g->next)
          if (g->where == p)
            printgroup (P3, g, 2,1);
        fend ();
      }
  }

  if (pr && (pr != stdout))
    fclose (pr);
  free (P);
}


void
player_status (void)
{
  player *P2;
  int i, j;
  int opts2 = 0;

  printf ("Techplus option?");
  getstr ();
  if (tolower (buf[0]) == 'y')
    opts2 = 1;
  if (opts2)
  {
    fbegin ("Status of Players", "xfffffffiiff");
    fhead ("NDWSCMPI#&MT");
  }
  else
  {
    fbegin ("Status of Players", "xfffffffi");
    fhead ("NDWSCMPI#");
  }
  for (P2 = players; P2; P2 = P2->next)
  {
    double pop, ind, max;

    fs (P2->name);
    ff (P2->tech.drive);
    ff (P2->tech.guns);
    ff (P2->tech.shields);
    ff (P2->tech.cargo);
    report_player_status (&max, &pop, &ind, &i, &j, P2, P2, 1);
    ff (max);
    ff (pop);
    ff (ind);
    fi (i);
    if (opts2)
    {
      int num;
      double mass, techmass;

      calc_status_mass (P2, P2, &num, &mass, &techmass, 1);
      fi (num);
      ff (mass);
      ff (techmass);
    }

  }
  fend ();

  if (pr && (pr != stdout))
    fclose (pr);
}

void
planet_list (void)
{
  planet *p;
  int complete;


  printf ("Standard list? [Y/N] >");
  getstr ();
  switch (tolower (buf[0]))
  {
  case 'y':
    complete = 0;
    break;
  case 'n':
    complete = 1;
    break;
  default:
    complete = 0;
  }

  sprintf (buf, "\nSystem list\n");

  if (complete)
  {
    fbegin (buf, "xxxffffff");
    fhead ("ON#XYSRPI");
  }
  else
  {
    fbegin (buf, "xxxffff");
    fhead ("ON#XYSR");
  }
  for (p = planets; p; p = p->next)
  {
    if (p->owner)
      fs (p->owner->name);
    else
      fs ("-");
    fs (p->name);
    fs (p->num);
    ff (p->x);
    ff (p->y);
    ff (p->size);
    ff (p->resources);
    if (complete)
    {
      ff (p->pop);
      ff (p->ind);
    }
  }
  fend ();

  if (pr && (pr != stdout))
    fclose (pr);
}

void
gm_map (void)
{
  player *P, *P2;

  /* Add player -> unique char printing somehow */
  P = alloc (sizeof (player));
  memset (P, 0, sizeof (*P));

  P->opts1 = P->opts1 & (MAPPLUS ^ 0xff);

#ifdef V3
  P->x = 0.0;
  P->y = 0.0;
  P->size = galaxysize;
#endif

  P->homex = 0.0;
  P->homey = 0.0;
  printf ("\nGM map options:\n");
  printf ("M)ap\n");
  printf ("S)et co-ords\n");
  printf ("D)imensions of map\n");
  printf ("P)layer's viewpoint\n");
  printf ("U)nique letters\n");
  printf ("Q)uit\n");
  for (;;)
  {
    printf ("MAP>");
    getstr ();
    switch (tolower (buf[0]))
    {
    case 'm':
      inputpr ();
      canseeall = 1;
      domap (P);
      canseeall = 0;
      fclose (pr);
      break;
    case 's':
      printf ("X-center? >");
      P->homex = getf ();
      printf ("Y-center? >");
      P->homey = getf ();
      if (fabs (P->homex) > galaxysize)
        P->homex = 0.0;
      if (fabs (P->homey) > galaxysize)
        P->homey = 0.0;
      break;
    case 'd':
      printf ("X-center? >");
      P->x = geti ();
      printf ("Y-center? >");
      P->y = geti ();
      if (abs (P->x) > galaxysize)
        P->homex = 0;
      if (abs (P->y) > galaxysize)
        P->homey = 0;
      printf ("Size? >");
      P->size = geti ();
      if (abs (P->size) > galaxysize)
        P->size = galaxysize;
      break;
    case 'u':
      P->opts1 = P->opts1 | MAPPLUS;
      break;
    case 'p':
      P2 = inputplayer (players, "Player?");
      if (P2)
      {
        P = P2;

#ifdef V3
        P->x = 0;
        P->y = 0;
        P->size = galaxysize;
#endif
      }
      break;
    case 'q':
      return;
    case 'x':
      return;
    default:
      printf ("\nGM map options:\n");
      printf ("M)ap\n");
      printf ("S)et co-ords\n");
      printf ("P)layer's viewpoint\n");
      printf ("U)nique letters\n");
      printf ("Q)uit\n");
    }

  }
}

/* End GM snooping code */
#endif
