static char *rcsid = "$Header: /navy/homes/zeus/SRC/RCS/misc.c,v 2.42 1994/05/17 13:43:15 bampton Exp bampton $";

/*
 * $Log: misc.c,v $
 * Revision 2.42  1994/05/17  13:43:15  bampton
 * *** empty log message ***
 *
 * Revision 2.41  1994/04/08  03:11:28  bampton
 * *** empty log message ***
 *
 * Revision 2.40  1994/03/09  20:22:55  bampton
 * *** empty log message ***
 *
 * Revision 2.39  1993/10/28  22:31:20  bampton
 * Revision 2.38  1993/09/27  17:15:54  bampton
 * Revision 2.37  1993/09/07  20:50:32  bampton
 * Revision 2.33  1993/08/03  23:10:13  bampton
 */

#define NOTIMEB

#include "common.h"
#include "prot.h"
#include "protos/misc.h"

void misc_rcsid (void);
extern double galaxysize;
extern planet *planets;
extern player *players;
extern sorted *sorted_planets;
extern shiptype *shiptypes;

#ifdef KCMD
extern planetdefense *defender;
#endif

#ifdef UPGRADE
extern fleetname *fleets;
#endif

void
misc_rcsid (void)
{
  printf ("%s\n", rcsid);
}

/*
 * just for easier debugging; to stop whenever desired call breakf and put a
 * break on breakf
 */

void
breakf (void)
{
  printf ("break\n");
}

void
findp (int n)
{
  planet *p;

  p = numtop (planets, n);

  printf ("yo\n");
}

void
freelist (void *base)
{
  list *p, *p2;

  p2 = base;
  while (p2)
  {
    p = p2;
    p2 = p2->next;
    free (p);
  }
}

long int
rnd (int x)
{
  return random () % x;
}

double
frand1 (void)
{
  return (double) rnd (10000);
}

double
dist (planet * p1, planet * p2)
{
  double dx = min (fabs (p1->x - p2->x), galaxysize - fabs (p1->x - p2->x));
  double dy = min (fabs (p1->y - p2->y), galaxysize - fabs (p1->y - p2->y));

  return sqrt (dx * dx + dy * dy);
}

double
ftrunc (double x)
{
  long int y;
  double z;

  y = (long int) (100 * x);
  z = ((double) y) / 100.0;
  return (z);
}

void *
alloc (int bytes)
{
  void *s = malloc (bytes);

  if (s == NULL)
  {
    printf ("Out of memory\n");
    exit (1);
  }
  return s;
}

double
shipmass (group * g)
{
  if (g->tech.cargo)

#ifdef V3
    return (typemass (g->type) + g->load / g->tech.cargo);
#else
    return (typemass (g->type) + g->load);
#endif

  else
    return (typemass (g->type));
}

double
typemass (shiptype * t)
{
  return t->drive + weaponmass (t) + t->shields + t->cargo;
}


double
weaponmass (shiptype * t)
{

#ifdef V3
  return (t->nguns ? t->guns : 0) +
  ((t->nguns > 1) ? ((t->nguns - 1) * 0.5 * t->guns) : 0);
#else
  return t->nguns * t->guns;
#endif
}

double
cargospace (group * g)
{
  double size;

  size = g->type->cargo;

#ifdef V3
  return (g->tech.cargo * size * (1 + size / 10));
#else
  return (size * g->tech.cargo);
#endif
}


double
effective_ind (planet * p)
{

#ifdef V3
  return (p->ind * 0.75 + p->pop * 0.25);
#else
  return (p->ind * 0.9 + p->pop * 0.1);
#endif
}

double
produce_cap (planet * p)
{
  double cap;

  cap = effective_ind (p) / INDPERCAP;
  if (cap > p->mat)
    cap = (p->mat) + ((cap * INDPERCAP) - (p->mat * INDPERCAP)) /
      (INDPERCAP + 1.0 / p->resources);
  return (cap);
}

double
produce_mat (planet * p)
{
  double mat;

  mat = effective_ind (p) * p->resources;
  return (mat);
}

double
produce_mass (planet * p)
{
  double mass;

  mass = effective_ind (p) / INDPERSHIP;
  if (mass > p->mat)
    mass= p->mat + ((mass * INDPERSHIP) - (p->mat * INDPERSHIP)) / 
                    (INDPERSHIP + 1.0 / p->resources);
  return (mass);
}

double
downgrade_cost (player *P, shiptype *T,planet *p)
{
  return ( INDPERSHIP * 0.5 *
          ((1.0 - p->drive / P->tech.drive) * T->drive + 
           (1.0 - p->guns / P->tech.guns) * weaponmass (T) + 
           (1.0 - p->shields / P->tech.shields) * T->shields + 
           (1.0 - p->cargo / P->tech.cargo) * T->cargo));
}

double
upgrade_cost (player *P,group *g)
{
  shiptype *T=g->type;

  return (INDPERSHIP * 
          ((1.0 - g->tech.drive / P->tech.drive) * T->drive + 
           (1.0 - g->tech.guns / P->tech.guns) * weaponmass (T) + 
           (1.0 - g->tech.shields / P->tech.shields) * T->shields + 
           (1.0 - g->tech.cargo / P->tech.cargo) * T->cargo));
}

#ifdef UPGRADE
int
fleettonum (group *g)
{
  fleetname *fl;
  int i;

  for (i=0,fl=fleets;fl;fl=fl->next)
  {
    i++;
    if (fl==g->fleet)
      return (i);
  }
  return(0);
}

fleetname *
numtofleet (int i)
{
  fleetname *fl;
  int j;

  if(i==0) return(NULL);
  for (j=0,fl=fleets;fl;fl=fl->next)
  {
    j++;
    if (i==j)
      return (fl);
  }
  assert(0);
  return (0); /* Silly compiler! You can't get here! */
}
#endif

#ifndef PREPROC
double
frand (double x)
{
  double amm = frand1 () / 100000000.0;
  double am = frand1 () / 10000.0;
  double a = frand1 ();
  double ap = frand1 () * 10000.0;
  double app = frand1 () * 100000000.0;

  return fmod (amm + am + a + ap + app, x);
}

#ifdef KCMD
void
wipe_defend (planet * p)
{
  planetdefense *d;

  for (d = defender; d; d = d->next)
    if (d->planet == p)
      removelist (&defender, d);
}
#endif

void
sterilize (planet * p)
{
  p->owner = NULL;
  p->pop = 0.0;
  p->ind = 0.0;
  p->cap = 0.0;
  p->mat = 0.0;
  p->col = 0.0;
  p->inprogress = 0.0;
  p->spent = 0.0;

#ifdef KCMD
  wipe_defend (p);
#endif

  memset (p->routes, 0, sizeof (p->routes));
}
#endif

/* create a list of all inhabited planets, sorted by industry level */

void
sortplanets (void)
{
  planet *p;
  sorted *tmp, *trailer, *new;

  freelist (sorted_planets);
  sorted_planets = NULL;

  for (p = planets; p; p = p->next)
    if (p->owner)
    {
      for (trailer = NULL, tmp = sorted_planets;
           tmp && (tmp->p->ind > p->ind);
           trailer = tmp, tmp = tmp->next)
        ;                       /* just advance pointer */

      new = alloc (sizeof (sorted));
      new->p = p;

      if (trailer)              /* inserting into middle or end of list */
      {
        new->next = tmp;
        trailer->next = new;
      }
      else
        /* inserting at the beginning of the list */
      {
        new->next = tmp;
        sorted_planets = new;
      }
    }                           /* end of: if a settled planet */
}

#ifndef PREPROC
void
dip_status (player * P1, player * P2)
{
  alliance *a;
  defensive *d;

  if (P1 && P2)
  {
    if (P1 == P2)
    {
      printf ("Players equal\n");
      return;
    }
    else
    {
      for (a = P1->allies; a; a = a->next)
        if (a->ally == P2)
        {
          printf ("Peace\n");
          return;
        }
      for (d = P1->defend; d; d = d->next)
        if (d->defend == P2)
        {
          printf ("Guard\n");
          return;
        }
    }
    printf ("War\n");
  }
  return;
}

void
delete_player (player * P, int force)
{
  player *P2;
  shiptype *T, *T2;
  alliance *a;
  defensive *d;
  planet *p;
  planetdefense *df;

  if (force)
  {
    for (p = planets; p; p = p->next)
      if (p->owner == P)
        sterilize (p);
    freelist (P->groups);
  }
  else
    for (p = planets; p && p->owner != P; p = p->next)
      ;                         /* Does he have Planets ? */

  if (!p && !P->groups)         /* No planets or groups... */
  {
    printf ("Deleting dead player %s\n", P->name);
    for (T = shiptypes; T;)
    {
      T2 = T->next;
      if (T->owner == P)
        removelist (&shiptypes, T);
      T = T2;
    }
    for (P2 = players; P2; P2 = P2->next)
      for (a = P2->allies; a; a = a->next)
        if (a->ally == P)
        {
          removelist (&P2->allies, a);
          break;
        }
    freelist (P->allies);
    for (P2 = players; P2; P2 = P2->next)
      for (d = P2->defend; d; d = d->next)
        if (d->defend == P)
        {
          removelist (&P2->defend, d);
          break;
        }
    freelist (P->defend);
#ifdef KCMD
    for (df = defender; df; df = df->next)
    {
      if (df->defender == P)
        removelist (&defender, df);
    }
#endif

#ifdef CARRYOVER
    freelist (P->othertechs);
#endif

    removelist (&players, P);
  }
}

extern FILE *pr;

void
forward_list ()
{
  player *P, *P2;
  planet *p;

  for (P = players; P->next; P = P->next)
  {
    for (P2 = P->next; P2; P2 = P2->next)
    {
      for (p=planets;p;p=p->next)
        if((p->owner==P2) && canseeplanet(P,p))
          break;
      
      if (p)
        fprintf (pr,"%-s:%-s\n",P->name,P2->name);
    }
    fprintf (pr,"%-s:%-s\n",P->name,P->name);
  }
  if (pr && (pr != stdout))
    fclose (pr);
}
#endif

#ifdef ULTRIX
char *
strdup (char *s1)
{
  char *s2;
  int len;

  len = strlen (s1)+1;
  s2 = (char *) alloc (sizeof (char) * len);
  memcpy (s1, s2, len);
  return s2;
}
#endif
