#!/bin/sh

CC='CC=gcc'
CCPIPE='CCPIPE=-pipe'

UNAME=`uname`
REV=`uname -r`

# Turn off all ARCH's here, and then override below!
ARCH='SUNOS4= HPUX9= SOLARIS= ULTRIX= AIX= LINUX= OSF1= IRIX5= IRIX6= BSDI= HPUX10= '

case $UNAME in
  SunOS) case $REV in
           4.1*) echo This looks like a SunOS 4.1 through 4.1.4 system
                 echo This is the OS that this code is most tested on
                 case `/bin/arch` in
                   sun3) CCPIPE='CCPIPE=' ;;
                 esac
             ARCH="$ARCH SUNOS4=-DSUNOS4=1";;
           5.*) echo This looks like a Solaris 2.x system
             ARCH="$ARCH SOLARIS=-DSOLARIS=1";;
        esac;;
  HP-UX) case $REV in
           B.10.*) echo This looks like an HP-UX machine running 10.x
             ARCH="$ARCH HPUX10=-DHPUX10=1 ";;
           A.09.*) echo This looks like an HP-UX machine running 9.x
             ARCH="$ARCH HPUX9=-DHPUX9=1";;
           *) echo This is an unfamiliar version of HP-UX. Good luck
             ARCH="$ARCH HPUX10=-DHPUX10=1";;
        esac;;
  AIX) case $REV in
           *) echo This is AIX
             ARCH="$ARCH AIX=-DAIX=1";;
        esac;;
  ULTRIX) case $REV in
           *) echo This is Ultrix
             CCPIPE='CCPIPE='
             ARCH="$ARCH ULTRIX=-DULTRIX=1";;
        esac;;
  Linux) case $REV in
           *) echo This is Linux $REV
             ARCH="$ARCH LINUX=-DLINUX=1";;
        esac;;
  
  OSF1) echo This is OSF $REV
             CCPIPE='CCPIPE='
             ARCH="$ARCH OSF1=-DOSF1=1";;

  IRIX) case $REV in
           5.*) echo Irix $REV
             CCPIPE='CCPIPE='
             ARCH="$ARCH IRIX5=-DIRIX5=1";;
           6.*) echo "Irix $REV"
             CC='CC=cc'
             CCPIPE='CCPIPE='
             ARCH="$ARCH IRIX6=-DIRIX6=1";;
        esac;;
  BSD/OS) case $REV in
           3.1) echo BSDI $REV
             ARCH="$ARCH BSDI=-DBSDI=1";;
           *) echo BSDI UNTESTED $REV
             ARCH="$ARCH BSDI=-DBSDI=1";;
        esac;;
  *) echo "I have no idea what OS this is. You are on your own."
         exit 1;;
esac
  


make clean  # Start fresh
# Compile with all the trimmings! Main and forecaster
make $CC $CCPIPE $ARCH PREPROC=  FORECAST= Blind KCMD=-DKCMD PTECH=-DPTECH PASSWORDS=-DPASSWORDS SMARTC=-DSMARTC SPEED=-DSPEED=31 QCMD=-DQCMD QADDR=-DQADDR='\"bampton\"' $EXTRA
make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=-DPREPROC FORECAST=-DFORECAST KCMD=-DKCMD PTECH=-DPTECH PASSWORDS=-DPASSWORDS SMARTC=-DSMARTC SPEED=-DSPEED=31 QCMD=-DQCMD QADDR=-DQADDR='\"bampton\"'  dbg-plus $EXTRA

make clean  # Start fresh
# Compile without speed code
make $CC $CCPIPE $ARCH PREPROC=  FORECAST= Blind KCMD=-DKCMD PTECH=-DPTECH PASSWORDS=-DPASSWORDS SMARTC=-DSMARTC  QCMD=-DQCMD QADDR=-DQADDR='\"bampton\"' $EXTRA
make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=-DPREPROC FORECAST=-DFORECAST KCMD=-DKCMD PTECH=-DPTECH PASSWORDS=-DPASSWORDS SMARTC=-DSMARTC QCMD=-DQCMD QADDR=-DQADDR='\"bampton\"' dbg-plus $EXTRA

make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=  FORECAST= Blind KCMD=-DKCMD PTECH=-DPTECH PASSWORDS=-DPASSWORDS  $EXTRA
make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=-DPREPROC FORECAST=-DFORECAST KCMD=-DKCMD PTECH=-DPTECH PASSWORDS=-DPASSWORDS dbg-plus $EXTRA

make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=  FORECAST= Blind KCMD=-DKCMD PTECH=-DPTECH  $EXTRA
make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=-DPREPROC FORECAST=-DFORECAST KCMD=-DKCMD dbg-plus $EXTRA

make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=  FORECAST= KCMD=-DKCMD  Blind $EXTRA
make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=-DPREPROC FORECAST=-DFORECAST dbg-plus $EXTRA

make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=  FORECAST= Blind $EXTRA
make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=-DPREPROC FORECAST=-DFORECAST dbg-plus $EXTRA

# New game stuff
make clean
make New-game $CC  $CCPIPE $ARCH PREPROC=  FORECAST= GAMENAME=-DGAMENAME KCMD=-DKCMD SPEED=-DSPEED=31 NEWGAME=-DNEWGAME=1 RANDPLACE=-DRANDPLACE MINSEP=-DMINSEP=20.0 BALANCE=-DBALANCE $EXTRA

# Server
make clean
make Cserver  $EXTRA
make EDIT=-DEDIT edit PREPROC=-UPREPROC FORECAST=-UFORECAST $EXTRA
rm loadgame.o
make VERBOSE=-UVERBOSE blind2ascii ascii2blind $EXTRA

make clean
make Order PREPROC=-UPREPROC FORECAST=-UFORECAST$CC  $CCPIPE $ARCH ORDER=-DORDER
