/* Return codes:
   2-99 == player error (we hope)
   100+ == GM problem
 */
#define FWDNOSEND 3
#define UNKNOWNSUBJECT 4
#define UNKNOWNPLAYER 6
#define LASTORDEROPEN 7
#define LASTORDERFILEOPEN 8
#define FWDNOTO 9

#define RPOPEN 100
#define GAMESNOTSET 101
#define HOMENOTSET 102
#define SYSTEMFAIL 103
#define MAILOPEN 104
#define XREFOPEN 105


#define LEN 256 /* Buffer lengths */
#define MAXNUMFWD 100 /* Maximum number of players to forward to */

#define MAIL 1 /* Use /bin/mail to send */
#define UCBMAIL 2 /* use /usr/ucb/mail to send */


/* Types of forwards */
#define FWD 1
#define LASTORDERS 2
#define LASTREPORT 3
#define ORDERS 4
#define FWDLIST 5
#define REREPORT 6 /* Regenerate a report with different options, not implemented */



extern char *strerror (int n);
extern int tolower (int c);
extern void *memset (void *s, int c, size_t n);
extern char *strcat (char *dst, const char *src);
extern int strncmp (const char *s1, const char *s2, size_t n);
extern char *strchr (const char *s, int c);
extern int unlink (const char *s);
extern mode_t umask (mode_t cmask);
extern int putenv(const char *string);


int main (int argc, char *argv[]);
void open_races_players (void);
void my_abort (char *error, int code);
void copy_reply (char *dst, char *line, int num);
void copy_subject (char *line);
int next_game (char *this_game);
char *match_game (void);
int match_type (void);
int hstrincmp (const char *s1, const char *s2, const int n);
void verify_fwd (void);
void lastorders (void);
void lastreport (void);
void orders (void);
int parse_subject (void);
void open_player_message (void);
void fwdlist (void);
void send_mailfile (const char * recip, int flag);
void open_x_ref (void);

