#!/bin/sh

PATH=/usr/ucb:/usr/bin:/usr/local/gnu:$HOME/bin:/usr/local/bin:/usr/local/mh



TossMessage ()
{
  (echo Received: $subject ; \
  body.awk $maild/$x) |  mail -s "Tossed message" $gm
  refiled=1
  refile $x +help
}

if [ x$1 = x ] ; then
   echo "Usage : `basename $0` game-name"
   exit 1
fi

game=$1
maild=$HOME/Mail/$game
races=$HOME/$game/races:players
verify=$HOME/$game/X-ref
gm=bampton@cs.utk.edu

export game maild races verify gm x subject use

folder +$game > /dev/null
cd $maild

for x in [1-9] [1-9]? [1-9]?? ; do
  refiled=0
  if [ -r $maild/$x ] ; then
    echo -n "Working on $x ... "
    use=`return.awk < $maild/$x | cut -d"<" -f2 | sed 's/>.*//' | sed 's/(.*)//'`
    subject=`egrep "^""Subject:" $maild/$x|head -1|grep $game`
    if [ "x$subject" = "x" ] ; then
      echo "No subject?"
      grep "^""Subject:" $maild/$x|head -1|grep $game:
      grep "^""Subject:" $maild/$x|head -1
      TossMessage
    fi

    echo $subject | grep -i "forwardlist:" >/dev/null
    if [ $? = 0 ] ; then
      race=`echo $subject | awk -F: '{print $4}'`
      echo "Forwarding list request for $game $race"
      p-Can-Fwd $game $race
      if [ $? = 0 ] ; then
        refile $x +requests
      else
        refile $x +help
      fi
      refiled=1
    fi

    echo $subject | grep -i "lastorders:" >/dev/null
    if [ $? = 0 -a $refiled = 0 ] ; then # is a last set of orders request
      racename=`echo $subject | awk -F: '{print $4}'`
      if [ x$racename = x ] ; then
        TossMessage
      fi
      # Get player's @ from trusted list
      use=`grep -w $racename $HOME/$game/races:players | awk -F: '{print $2}'`
      if [ x$use = x ] ; then
        TossMessage
      fi
      # Get message number of last set of orders from player
      msg=`scan +$game-Turns | grep -w $racename | awk '{print $1}'|tail -1`
      folder +$game > /dev/null # Need to do this to pop back to correct place
      if [ x$msg = x ] ; then
        echo "No orders found for $racename in $game" | \
          mail -s "$game lastorders failure" $use
        refile $x +help
      else
        mail -s "Most recient set of orders for $racename" $use < \
         $HOME/Mail/$game-Turns/$msg
        refile $x +requests
      fi
      refiled=1
    fi

    echo $subject | egrep -i ":fwd:|: fwd:" >/dev/null
    if [ $? = 0 -a $refiled = 0 ] ; then # It is a message fwd attempt...
      msg-forw.sh
      refiled=1
    fi

    echo $subject | good-subject game=$game > /dev/null
    if [ $? = 0 -a $refiled = 0 ] ; then
      echo "might be a turn..."
      #if [ $? != 0 ] ; then
      #  echo "... but is isn't
      #  (echo "Probable bad set of orders, probably a bad subject line."; 
      #   echo "Should be" ; echo "$game orders for racename"; echo ""; \
      #   echo Received: $subject ; \
      #   body.awk $maild/$x) |  mail -s "$game bogus orders?" $use
      #  refile $x +help
      #else 
        race=`echo $subject | awk '{print $5}'`
        grep -i '^'"$race:" $HOME/$game/races:players >/dev/null
        if [ $? != 0 ] ; then
          echo "Unknown race"
          (echo "Probable bad set of orders - unknown race?"; 
           echo "Should be" ; echo "$game orders for racename"; echo ""; \
           echo $subject ; \
           body.awk $maild/$x) |  mail -s "$game bogus orders?" $use
          refile $x +help
        else
          echo "Looks like a turn... refiling to $game-turns"
          doturn=1
          refile $x +$game-turns
        fi
      #fi
      refiled=1
    fi
    
    # Not orders, fwd, lastorders, or forwardlist. Get creative now.
    echo $subject | grep -i help >/dev/null
    if [ $? = 0 -a $refiled = 0 ] ; then # help request
      refiled=1
      return=`return.awk  $maild/$x`
      echo "NOT IMPLEMENTED. See web pages." | mail -s "Help request?" $return
      refile $x +help
    fi

    # Some common player errors
    echo $subject | grep  "${game}: Forwarded message" >/dev/null
    if [ $? = 0 -a $refiled = 0 ] ; then # Someone replied to a forward
      echo $subject | grep "${game}: Forwarded message from GM" >/dev/null
      if [ $? = 0 ] ; then # Someone replied to a forward from the GM
        (echo "player reply to GM wrong"; echo ""; \
         echo ""; echo ""; body.awk $maild/$x) |  \
         mail -s "$game- bad reply" $gm 
        refile $x +sent
        refiled=1
      else
        echo "game OK, bogus forward... HELP"
        (echo "game $game recognized, looks like you replied to the";\
         echo "message and didn't fix the subject line..."; echo ""; \
         echo ""; body.awk $maild/$x) |  \
        mail -s "$game- replied wrong?" $use
        refile $x +help
        refiled=1
      fi
    fi

    if [ $refiled = 0 ] ; then # Who knows what the thing is
      echo "game OK, message type unknown... HELP"
      body.awk $maild/$x |  mail -s "$game- mangled subject?" $gm
      refile $x +help 
      refiled=1
    fi

  fi # Message file exists
done

if  [ x$doturn = x1 ] ; then
  cd $HOME/Mail/$game-turns
  Pre-proc -mail -silent
  folder +$game-turns > /dev/null
  refile all +$game-Turns > /dev/null
  folder +inbox > /dev/null
fi
