static char *rcsid = "$Header: /sanguine/homes/zeus/Blind-2.48/RCS/Str.c,v 2.48 1999/03/14 00:46:08 zeus Exp zeus $";
/* $Log: Str.c,v $
 * Revision 2.48  1999/03/14 00:46:08  zeus
 * *** empty log message ***
 * */

#include "common.h"
#include "str.h"

void str_rcsid (void);

void
str_rcsid (void)
{
  printf ("%s\n", rcsid);
}



/* Case insensitive string comparision (not on all OS's) */

int
hstricmp (const char *s1, const char *s2)
{
  char c1, c2;

  do
  {
    c1 = tolower (*s1++);
    c2 = tolower (*s2++);
    if (c1 != c2)
      return c1 - c2;
  }
  while (c1);
  if (c2)
    return (1);                 /* different string lengths */

  return 0;
}

/* This is a "safer" strcpy- null termination guarenteed */
/* BUG: overrun of bounds is possible */
void
hstrcpy (char *a, const char *b)
{
  int x;

  a[0] = '\0';
  if (b == NULL)
    return;
  for (x = 0; b[x]; x++)
  {
    a[x] = b[x];
  }
  a[x] = b[x];
}


/* This is a "safe" strncpy- null termination guarenteed, and no
   overrun (given correct sizes) */

void
hstrncpy (char *a, const char *b, const int sz)
{
  int x;

  a[0] = '\0';
  if (b == NULL)
    return;
  for (x = 0; b[x] && (x < sz); x++)
  {
    a[x] = b[x];
  }
  if (sz == MAXTEXT)
    a[sz - 1] = '\0';
  if (x < sz)
    a[x] = '\0';
}


/* strcpy, (Howard's Comment-whacking STRCPY) that sets a to NULL 
   if it is a comment, and removes any trailing comment characters/contents. */
void
hcstrcpy (char *a, const char *b)
{
  int x;

  a[0] = '\0';
  if (b == NULL)
    return;
  if ((b[0] == ';') || (b[0] == '#'))
  {
    /* b is a comment in its entirety, so toss back NULL for a */
    return;
  }
  a[0] = b[0];
  if (b[1])                     /* Copy 2nd and later non comment characters */
  {
    for (x = 1; b[x]; x++)
    {
      if (x == MAXSTRLEN)
      {                         /* Prevent string length overrun */
        a[MAXSTRLEN - 1] = '\0';
        return;
      }
      /* Comment char preceeded by whitespace, so puke and return */
      if (((b[x] == ';') || (b[x] == '#')) && ((b[x - 1] == ' ') || (b[x - 1] == '\t')))
      {
        a[x] = '\0';
        return;
      }
      a[x] = b[x];
    }
    a[x] = b[x];
  }
  else
    a[1] = '\0';
}


/* This is a "safe" strncpy- null termination guarenteed, and no overrun
   (given correct sizes). (Howard's Comment STRNCPY)
   This is a strncpy that sets a to NULL if it is a comment. */
void
hcstrncpy (char *a, const char *b, const int sz)
{
  int x = 0;

  assert (sz);                  /* Just in case.... */
  a[0] = '\0';                  /* Ensure NULL string returned */
  if (b == NULL)
    return;
  if ((b[0] == ';') || (b[0] == '#'))
    return;
  a[0] = b[0];
  if ((b[1]) && (sz > 1))       /* Continue copying */
  {
    for (x = 1; b[x] && (x < sz); x++)
    {
      if (((b[x] == ';') || (b[x] == '#')) && ((b[x - 1] == ' ') || (b[x - 1] == '\t')))
      {  /* Comment char preceeded by whitespace, so puke and return */
        a[x] = '\0';
        return;
      }
      a[x] = b[x];
    }
    if (sz == MAXTEXT)
      a[sz - 1] = '\0';
  }
  if (x < sz)
    a[x] = '\0';
}
