static char *rcsid = "$Header: /sanguine/homes/zeus/Blind-2.48/RCS/findplayer.c,v 2.48 1999/03/14 00:46:08 zeus Exp zeus $";

/*
 * $Log: findplayer.c,v $
 * Revision 2.48  1999/03/14 00:46:08  zeus
 * *** empty log message ***
 *
 *
 */

#ifndef ORDER
#ifdef PREPROC
static const char     lf = '\n';
 
#else
static const char     lf = ' ';
 
#endif

#endif
#include "common.h"
#include "prototypes.h"
#include "findplayer.h"

#ifdef PASSWORDS
#include <errno.h>
#include "exit.h"
#endif

void findplayer_rcsid (void);

extern char buf[MAXSTRLEN];
extern player *players;
extern char err_tmp[];

#ifdef GAMENAME
extern char gamename[MAXTEXT];

#endif

#ifdef ORDER
extern char galaxy_line[];
#endif

#ifdef PREPROC
extern int bad;
extern int n_order;
extern char orders[];
#endif

void
findplayer_rcsid (void)
{
  printf ("%s\n", rcsid);
}


player *
n2inputplayer (char *prompt)
{
  int i;
  player *p;
  char *nbuf;
  char name[MAXSTRLEN];
  int quoted;                   /* For enabling "empire name" */

#ifdef PASSWORDS
  char password[MAXSTRLEN];

#endif

#ifndef ORDER
  printf ("%s%c", prompt, lf);
#endif
  for (;;)
  {                             /* Keep reading lines of input until EOF */
    fgets (buf,MAXSTRLEN-1,stdin);

    i=strlen(buf);
    if (i) /* If string is 1+chars, whack the \n */
    {buf[i-1]='\0'; }
    if (feof (stdin))
      return (NULL);

    if (buf[0])
    {
      /* Non-empty line, so see if it has magic #galaxy cookie */
      if (!strncasecmp (buf, "#galaxy", 7))
      {
        nbuf = strchr (buf, ' ');       /* Find first space */
        if (nbuf == NULL)
        {
          sprintf (err_tmp, "Null gamename- \"%s\"\n", buf);
          return (NULL);
        }
        for (; nbuf;)           /* Kill whitespace */
          if ((nbuf[0] == ' ') || (nbuf[0] == '\t'))
            nbuf++;
          else
            break;

#ifdef GAMENAME
        {
          char gname[MAXSTRLEN];
          char *j;

          /* copy the gamename, and then truncate the string at first
             space or tab, then do comparison of gamename. */
          hstrncpy (gname, nbuf, MAXSTRLEN);
          for (j = gname; j; j++)
          {
            if ((j[0] == ' ') || (j[0] == '\t'))
            {
              j[0] = '\0';
              break;
            }
          }
          if (hstricmp (gname, gamename) != 0)
          {
            sprintf (err_tmp, "Gamename mismatch- \"%s\"\n", gname);
            return (NULL);
          }
        }
#endif

        /* have found & checked "#galaxy gamename" */
        nbuf = strchr (nbuf, ' ');      /* Find 2nd wordbreak */
        if (!nbuf)
          break;                /* TEMP BUGFIX */
        nbuf++;
        for (; nbuf;)
          if ((nbuf[0] == ' ') || (nbuf[0] == '\t'))
            nbuf++;
          else
            break;

        /* Now we look for and grab the playername.... */
        if (nbuf[0] == '"')     /* "blah blah" */
        {
          nbuf++;
          quoted = 1;
        }
        else
          quoted = 0;

        for (i = 0; i < strlen (nbuf); i++)
        {
          if ((nbuf[i] != ' ') && (nbuf[i] != '\t') && (nbuf[i] != '"'))
            name[i] = nbuf[i];  /* Normal */
          else
          {
            if ((nbuf[i] == ' ') && quoted)     /* quoted name, and space */
              name[i] = '_';
            else
              break;
          }
        }
        name[i] = '\0';
        /* Clean up with quoted name */
        if (quoted)
        {
          nbuf++;               /* advance by one, to dispose of trailing " */
        }

#ifdef PASSWORDS
        nbuf += i;
        for (; nbuf;)           /* Find 3rd break's whitespace end */
          if ((nbuf[0] == ' ') || (nbuf[0] == '\t'))
            nbuf++;
          else
            break;

        /* Copy password entry */
        for (i = 0; i < strlen (nbuf); i++)
          if ((nbuf[i] != ' ') && (nbuf[0] != '\t'))
            password[i] = nbuf[i];
          else
            break;
        password[i] = '\0';
#endif

        if ((p = nametop (players, name)) != 0)
        {

#ifdef ORDER
          hstrncpy(galaxy_line,buf,MAXSTRLEN);
#endif
#ifdef PASSWORDS
          if (verify_password (p, password) != 0)
          {

#ifdef PREPROC
            error (err_tmp);
            exit (BADPW);
#else
            fprintf (stderr, "%s", err_tmp);
            return (NULL);
#endif
          }
#endif

          return p;
        }
        sprintf (err_tmp, "Player \"%s\" not found.\n", buf);
        return (NULL);
      }
    }
  }
  return (NULL);                /* BUG PROBLEM */
}

#ifdef PASSWORDS

int
verify_password (player * P, const char *pw)
{
  FILE *pwf;
  char pwfpw[MAXTEXT], pwl[MAXSTRLEN];
  int j, k;

  memset (pwl, 0, MAXSTRLEN);
  pwf = fopen (PASSWORDFILE, "r");
  if (pwf == NULL)
  {
    sprintf (buf,"Password file missing!?! (%s)\n",strerror (errno));
    error (buf);
    exit (MISSINGPW);           /* Urk. No file? */
  }
  j = strlen (P->name) + 1;     /* Needed later */
  for (;;)
  {
    if (feof (pwf))             /* Player name not matched in file */
    {
      fclose (pwf);
      if (strlen (pw) == 0)
        return (0);             /* No password given, or req'd */
      error ("Player name missing from password file\n");
      return (1);
    }
    /* Do the EOF check first, to deal with empty file and match on last */
    fscanf (pwf, "%s\n", pwl);

    /* Match empire name check. */
    if ((!strncasecmp (P->name, pwl, STRNCMPT strlen (P->name))) && (pwl[j - 1] == ':'))
    {
      for (k = 0; pwl[k + j]; k++)
        pwfpw[k] = pwl[k + j];
      pwfpw[k] = '\0';
      if (strlen (pw) == strlen (pwfpw))        /* Potential match */
      {
        fclose (pwf);
        if (hstricmp (pw, pwfpw) != 0)
        {
          sprintf (err_tmp, "Password %s not matched for %s\n", pw, P->name);
          return (1);
        }
        return (0);             /* Matched */
      }
      else
      {
        fclose (pwf);
        sprintf (err_tmp, "Password %s not matched for %s\n", pw, P->name);
        return (1);
      }
    }
  }
  assert (0);                   /* Should have been given a valid player name */
  return (1);
}
#endif

void
error (char msg[])
{

#ifdef PREPROC
  bad++;
  fprintf (stderr, "Mistake (%0d):'%s'\n", n_order, orders);
  fprintf (stderr, "%s", msg);
  return;
#else
  printf ("%s\n", msg);
#endif
}
