static char *rcsid = "$Header: /sanguine/homes/zeus/Blind-2.48/cmds/RCS/x.c,v 2.46 1997/04/18 12:13:56 zeus Exp $";

/*
 *
 * $Log: x.c,v $
 * Revision 2.46  1997/04/18 12:13:56  zeus
 * *** empty log message ***
 *
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 */

#define NOTIMEB
 
#include "common.h"
#include "prototypes.h"
#include "enterturn-g.h"
#include "cmds.h"
#include "cmds-g.h"

extern char tbuf[];
extern int groupno;
extern char err_tmp[];
extern int comment;

void x_cmd_rcsid (void);

void
x_cmd_rcsid (void)
{
  printf ("%s\n",rcsid);
}

void
x_cmd (char *buf, player * P)
{
  group *g;
  planet *p;
  int i;

  cmd_init(buf);
  g = ninputgroup (P);
  if (!g)
  {
    error (err_tmp);
    return;
  }
  if (group_check (P, g, NULL, groupno, G_DIST))
  {
    error (err_tmp);
    return;
  }

  p = g->where;
  if (!p->size)			/* can't unload onto size 0   */
  {
    sprintf (err_tmp, "Group %d can not be scrapped- world %s is size 0.\n",
	     groupno, p->num);
    error (err_tmp);
    return;			/* systems; do nothing if try */
  }

  if ((g->loadtype == CG_COL) && (g->where->owner) && (g->where->owner != P))
  {
    sprintf (err_tmp, "Can't unload colonists onto alien planet %s\n", p->num);
    return;
  }
  if (tbuf)
    i = ngeti ();
  else
    i = 0;
  if (i == NAI)
    comment = 1;
  if (i == BADI)
  {
    error (err_tmp);
    return;
  }
  if (i == MISSINGI)
    i = 0;			/* Too few tokens */
  if ((i > 0) && (g->ships != i))
  {
    if (i > g->ships)
    {
      sprintf (err_tmp, "Not enough ships in group %d.\n", groupno);
      error (err_tmp);
      return;
    }
    if (i != g->ships)
    {
      g = new_group (P, g, i);
    }
  }
  if (g->load)
    unloadgroup (g, P);
  g->where->mat += shipmass (g) * g->ships;
  g->ships = 0;			/* Bugfix so we don't renumber groups */
  g->dist = 1.0;		/* So that UNSAFEMAX finds grp /w ships */
  extra_token ();
}
