static char *rcsid = "$Header: /sanguine/homes/zeus/Blind-2.48/cmds/RCS/u.c,v 2.46 1997/04/18 12:13:56 zeus Exp $";

/*
 *
 * $Log: u.c,v $
 * Revision 2.46  1997/04/18 12:13:56  zeus
 * *** empty log message ***
 *
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 */

#define NOTIMEB
 
#include "common.h"
#include "prototypes.h"
#include "enterturn-g.h"
#include "cmds.h"
#include "cmds-g.h"

extern int groupno;
extern int comment;
extern char err_tmp[];

void u_cmd_rcsid (void);

void
u_cmd_rcsid (void)
{
  printf ("%s\n",rcsid);
}


void
u_cmd (char *buf, player * P)
{
  group *g;
  planet *p;
  int i;

  cmd_init(buf);
  g = ninputgroup (P);
  if (!g)
  {
    error (err_tmp);
    return;
  }
  if (g->loadtype == CG_EMPTY)
  {
    sprintf (err_tmp, "Group %d isn't carrying cargo.\n", groupno);
    error (err_tmp);
    return;
  }
  if (group_check (P, g, NULL, groupno, G_DIST))
  {
    error (err_tmp);
    return;
  }
  p = g->where;
  if ((g->loadtype == CG_COL) && (p->owner != P) && p->owner)
  {
    sprintf (err_tmp, "Group %d at %s can't unload COL at alien planet.\n",
	     groupno, p->num);
    error (err_tmp);
    return;
  }

  if (!p->size)			/* can't unload onto size 0   */
  {
    sprintf (err_tmp, "Group %d can not unload- world %4s is size 0.\n",
	     groupno, p->num);
    error (err_tmp);
    return;
  }
  i = ngeti ();
  if (i == BADI)
  {
    error (err_tmp);
    return;
  }
  if (i == MISSINGI)
    i = 0;			/* Too few tokens */
  if (i > g->ships)
  {
    i = g->ships;
    sprintf (err_tmp, "Only %d ships can be unloaded.\n", i);
    error (err_tmp);
    return;
  }
  if (i <= 0)
    i = g->ships;
  if (i != g->ships)
    g = new_group (P, g, i);
  unloadgroup (g, P);
  extra_token ();
}
