static char *rcsid = "$Header: /sanguine/homes/zeus/Blind-2.48/cmds/RCS/r.c,v 2.48 1999/03/14 00:48:48 zeus Exp zeus $";

/*
 *
 * $Log: r.c,v $
 * Revision 2.48  1999/03/14 00:48:48  zeus
 * *** empty log message ***
 *
 * Revision 2.47  1998/04/15 21:34:50  zeus
 * *** empty log message ***
 *
 * Revision 2.46  1997/04/18 12:13:56  zeus
 * *** empty log message ***
 *
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 */

#define NOTIMEB
 
#include "common.h"
#include "prototypes.h"
#include "enterturn-g.h"
#include "cmds.h"
#include "cmds-g.h"
#include "options.h"

extern char err_tmp[];
extern int null_planet_ok;
#ifdef FORECAST
extern int seenlist[];
extern planet *planets;
#endif

void r_cmd_rcsid (void);

void
r_cmd_rcsid (void)
{
  printf ("%s\n",rcsid);
}

void
r_cmd (char *buf, player * P)
{
  planet *p, *p2;
  int i;

  cmd_init(buf);
  p = ninputplanet (P);
  if (!p)
  {
    error (err_tmp);
    return;
  }
  if (p->owner != P)
  {
    sprintf (err_tmp, "You don't own that system.\n");
    error (err_tmp);
    return;
  }
  i = ninputcargotype2 ();
  if (i >= 0)
  {
    null_planet_ok = ANY;
    p2 = ninputplanet (P);
    if (p2 || null_planet_ok)
    {
#ifdef FORECAST

      if ((seenlist[ptonum (planets, p2)]==0) && (P->opts2 & PEDANTIC))
      {
        sprintf (err_tmp,"WARNING: Route to unseen system!\n");
        error (err_tmp); /* Warning only! */
      }
      if (((i == ALL_CARGO) || (i == COL)) && (p->col > 0.0 ) && (P->opts2 & PEDANTIC) && (p==p2))
      {
        sprintf (err_tmp,"WARNING: COL Route from %s goes back to itself!\n",p->name);
        error (err_tmp); /* Warning only! */
      }
#endif

      if (i == ALL_CARGO)
	p->routes[COL] = p->routes[CAP] = p->routes[MAT] = p2;
      else
	p->routes[i] = p2;
      if (!p2 && null_planet_ok) 
        return; /* They aleady had a comment, so stop checking input */
      else
      {
        extra_token ();
        return;
      }
    }
    else
    {
      error (err_tmp);
      return;
    }
  }
  else
  {
    error (err_tmp);
    return;
  }
  extra_token ();
}

