/*
 * $Header: /a/beepbeep/navy/homes/zeus/Zeus/SRC/RCS/common.h,v 0.0
 * 1993/07/14 13:42:37 bampton Exp bampton $
 * 
 * $Log: common.h,v $
 * Revision 2.46  1997/04/18 12:16:55  zeus
 * *** empty log message ***
 *
 * Revision 2.45  1997/01/01  00:11:19  zeus
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 * Revision 2.42  1994/05/17  13:43:15  bampton
 * Revision 2.40  1994/03/09  20:22:55  bampton
 * Revision 2.39  1993/10/28  22:31:20  bampton
 * Revision 2.38  1993/09/27  17:15:54  bampton
 * Revision 2.37  1993/09/07  20:50:32  bampton
 * Revision 2.34  1993/08/09  23:06:20  bampton
 * Revision 2.33  1993/08/03  23:10:13  bampton
 * Revision 2.30  1993/07/14  14:59:26  bampton
 * Revision 0.0  1993/07/14  13:42:37  bampton RCS prototype.
 * 
 */

#include        <stdio.h>
#include        <stdlib.h>
#include        <string.h>
#include        <fcntl.h>
#include        <ctype.h>
#include        <math.h>
#include        <assert.h>

#ifndef NOTIMEB
#include <sys/time.h>
#endif

/* To get stat info */
#if (LINUX || HPUX9 || SOLARIS || AIX || ULTRIX) && SPEED&1
#include <sys/stat.h>
#endif

#ifdef SMARTC
#include <errno.h> /* for errno */
#endif

#include        "global.h"

#define ALMOSTZERO              0.00000000001   /* don't change! */
#define ROUNDOFF                0.001         /* Round off error fudger */
#define MAXTEXT                 16      /* name lengths */
#define MAXPOP                  1000.0  /* Homeworld size */
#define MATPERCOL               ALMOSTZERO      /* modifiable */
#define POPPERCOL               8.0
#define POPINC                  .08
#define INDPERCOL               ALMOSTZERO      /* modifiable */
#define INDPERSHIP              10.0
#define INDPERCAP               6.0
#define INDFROMCAP              2.0     /* Blind add-on, 1.0 for std games */
#define INDPERRESEARCH          5000
#define BATTLEMAGIC             3.107232506
#define DRIVEMAGIC              20.0
#define MAPWIDTH                80
#define MAPHEIGHT               40
#define LOADSAPLANETS           40
#define MAXSTRLEN               256

#ifndef O_BINARY
#define O_BINARY                0
#endif

#define TRUE 1
#define FALSE 0
#define min(x,y) (x>y  ? y : x)
#define max(x,y) (x<y  ? y : x)

/* Status's for K cmd: (flush == clear it out) */
#define PEACE 0
#define GUARD 1
#define WAR 2
#define FLUSH 3

/* For magic values for g->dist */
#define UPG -3.0
#define INTERCEPT -1.0

/* For print_status */
#define FORE_STS 0
#define NORM_STS 1

#ifdef IO

#ifdef PREPROC
static char     lf = '\n';

#else
static char     lf = ' ';

#endif

#endif



#ifdef  INTERACTIVE
#define throwstr()
#else
#define throwstr()              getstr()
#endif

enum
{
  PR_CAP,
  PR_MAT,
  PR_SHIP,
  PR_DRIVE,
  PR_GUNS,
  PR_SHIELDS,
  PR_CARGO,
  PR_NOTHING
};

enum
{
  CG_COL,
  CG_CAP,
  CG_MAT,
  CG_EMPTY,
  MAXCARGO
};

struct playerstruct;
typedef struct playerstruct player;

typedef struct liststruct
{
  struct liststruct *next;
}               list;

typedef struct tmppname
{
  struct tmppname *next;
  char  nname[MAXTEXT];
  char  oname[MAXTEXT];
} tmppname;

typedef struct
{
  double          drive;
  double          guns;
  double          shields;
  double          cargo;
}               Tech;

typedef struct shiptypestruct
{
  struct shiptypestruct *next;
  char            name[MAXTEXT];
  player         *owner;
  double          drive;
  int             nguns;
  double          guns;
  double          shields;
  double          cargo;
  int             flag;
  int numbuilt;
}               shiptype;

typedef struct planetstruct
{
  struct planetstruct *next;
  char            name[MAXTEXT];
  char            num[MAXTEXT];
  player         *owner;
  double          x, y;
  double          size;
  double          resources;
  double          pop;
  double          ind;
  int             producing;
  shiptype       *producingshiptype;
  double          col;
  double          cap;
  double          mat;
  double          inprogress;
  double          spent;
  struct planetstruct *routes[MAXCARGO];
  double          drive;
  double          guns;
  double          shields;
  double          cargo;
}               planet;

typedef struct fleetname {
        struct fleetname *next;
        char name[MAXTEXT];
        double fleetspeed;
        player *owner;
}               fleetname;

typedef struct groupstruct
{
  struct groupstruct *next;
  shiptype       *type;
  Tech            tech;
  int             loadtype;
  double          load;
  planet         *from;
  planet         *where;
  double          dist;
  int             ships;
  int             left;
  struct groupstruct   *alias;
  fleetname        *fleet;
}               group;

typedef struct alliancestruct
{
  struct alliancestruct *next;
  player         *ally;
}               alliance;

typedef struct defensivestruct  /* def mod */
{
  struct defensivestruct *next;
  player         *defend;
}               defensive;

typedef struct planetdefense
{
  struct planetdefense *next;
  int       dipstat;
  player         *defender;
  planet         *planet;
}               planetdefense;

typedef struct techinfo
{
  struct techinfo *next;
  Tech            tech;
  player         *whoose;
}               techinfo;

typedef struct sortedstruct
{
  struct sortedstruct *next;
  planet         *p;
}               sorted;

typedef struct shotstruct
{
  struct shotstruct *next;
  shiptype       *attacker;
  shiptype       *target;
  int             kill;
}               shot;

typedef struct viewerstruct
{
  struct viewerstruct *next;
  player         *who;
}               viewer;

typedef struct participantstruct
{
  struct participantstruct *next;
  player         *who;
  group          *groups;
}               participant;

typedef struct battlestruct
{
  struct battlestruct *next;
  planet         *where;
  shot           *shots;
  viewer         *viewers;
  participant    *participants;
}               battle;

typedef struct bombingstruct
{
  struct bombingstruct *next;
  planet         *where;
  player         *who;
  viewer         *viewers;
  player         *whoose;
  double          pop;
  double          ind;
  double          col;
  double          cap;
  double          mat;
}               bombing;

struct playerstruct
{
  player         *next;
  char            name[MAXTEXT];
  Tech            tech;
  alliance       *allies;
  defensive      *defend;       /* def mod */
  group          *groups;

  int             opts1, opts2, opts3, lastorders;
  double          homex, homey; /* GE: homex, homey = 0,0 in player's view */
  int             x, y, size;
  techinfo       *othertechs;
};

typedef struct bombsum
{
  struct bombsum      *next;
  player       *bomber;
  player       *owner;
  int          num_bombed;
  /* Note: The code doesn't use this, but I might fix it some day... */
  double       size; 
  double       pop, ind, col, cap, mat;
}      bombsum;
