static char *rcsid = "$Header: /plaid/homes/zeus/Blind-2.47/cmds/RCS/t.c,v 2.46 1997/04/18 12:13:56 zeus Exp $";

/*

 * $Log: t.c,v $
 * Revision 2.46  1997/04/18 12:13:56  zeus
 * *** empty log message ***
 *
 * Revision 2.45  1997/01/01  00:05:49  zeus
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 */

#define NOTIMEB

#include "common.h"
#include "prototypes.h"
#include "enterturn-g.h"
#include "cmds.h"
#include "cmds-g.h"

extern char err_tmp[];
extern shiptype *shiptypes;
extern fleetname *fleets;

void t_cmd_rcsid (void);

void
t_cmd_rcsid (void)
{
  printf ("%s\n", rcsid);
}

void
t_cmd (char *buf, player * P)
{
  shiptype *T, *T2;
  char t[MAXTEXT];
  fleetname *fl, *fl2;
  char v[MAXTEXT];

  cmd_init(buf);
  hstrncpy (v, next_token (), MAXTEXT);
  T = matchtype (P, v);
  fl = matchfleet (P, v);
  if (T || fl)
  {
    hstrncpy (t, next_token (), MAXTEXT);
    if (t[0])
    {
      for (T2 = shiptypes; T2; T2 = T2->next)
        if ((T2->owner == P) && (!hstricmp (T2->name, t)) && (T2 != T))
        {
          sprintf (err_tmp, "Ship type name \"%s\" is already in use.\n", t);
          error (err_tmp);
          return;
        }
      for (fl2 = fleets; fl2; fl2 = fl2->next)
        if ((fl2->owner == P) && !hstricmp (fl2->name, t) && (fl2 != fl))
        {
          sprintf (err_tmp, "Fleet of name \"%s\" is already in use.\n", t);
          error (err_tmp);
          return;
        }
    }
    else
    {
      error (err_tmp);
      return;
    }
  }
  else
  {
    error ("No matching fleet or ship type.\n");
    return;
  }
  if (legal_name (t, 0))
  {
    error (err_tmp);
    return;
  }
  if (T)
    hstrncpy (T->name, t, MAXTEXT);
  if (fl)
    hstrncpy (fl->name, t, MAXTEXT);
  extra_token ();
}
