static char *rcsid = "$Header: /plaid/homes/zeus/Blind-2.47/cmds/RCS/m.c,v 2.46 1997/04/18 12:13:56 zeus Exp $";

/*
 *
 * $Log: m.c,v $
 * Revision 2.46  1997/04/18 12:13:56  zeus
 * *** empty log message ***
 *
 * Revision 2.45  1996/12/31  23:59:06  zeus
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 */

#define NOTIMEB
 
#include "common.h"
#include "prototypes.h"
#include "enterturn-g.h"
#include "cmds.h"
#include "cmds-g.h"
#include "options.h"

extern double galaxysize;
extern char err_tmp[];

void m_cmd_rcsid (void);

void 
m_cmd_rcsid (void)
{
  printf ("%s\n",rcsid);
}

void
m_cmd (char *buf, player * P)
{
  double tx, ty, ts;

  cmd_init(buf);
  tx = ngetf2 ();
  if ((tx == MISSINGF) || (tx == NAF))
  {
    error (err_tmp);
    return;
  }
  ty = ngetf2 ();
  if ((ty == MISSINGF) || (ty == NAF))
  {
    error (err_tmp);
    return;
  }
  ts = ngetf ();
  if (fabs (tx) > galaxysize)
  {
    error ("map X can not be larger than galaxy size\n");
    return;
  }
  if (fabs (ty) > galaxysize)
  {
    error ("map Y can not be larger than galaxy size\n");
    return;
  }
  if ((ts == BADF) || (ts == MISSINGF) || (ts == NAF))
  {
    error (err_tmp);
    return;
  }
  if (ts < 1.0)
  {
    error ("map size must be at least 1\n");
    return;
  }
  if (ts > galaxysize)
  {
    sprintf (err_tmp,"map size can not be larger than galaxy size: %0.0f\n",galaxysize);
    error (err_tmp);
    return;
  }
  P->opts1 |= MAP;
  P->x = (int) tx;
  P->y = (int) ty;
  P->size = (int) ts;
  extra_token ();
}
