static char *rcsid = "$Header: /plaid/homes/zeus/Blind-2.47/cmds/RCS/l.c,v 2.47 1998/04/15 21:34:50 zeus Exp zeus $";

/*

 * $Log: l.c,v $
 * Revision 2.47  1998/04/15 21:34:50  zeus
 * *** empty log message ***
 *
 * Revision 2.46  1997/04/18 12:13:56  zeus
 * *** empty log message ***
 *
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 */

#define NOTIMEB

#include "common.h"
#include "prototypes.h"
#include "enterturn-g.h"
#include "cmds.h"
#include "cmds-g.h"

extern char err_tmp[];
extern int groupno;
extern int comment;


void l_cmd_rcsid (void);

void
l_cmd_rcsid (void)
{
  printf ("%s\n", rcsid);
}

void
l_cmd (char *buf, player * P)
{
  group *g;
  int i, j;
  double x, x2, amt;
  planet *p;

  cmd_init (buf);
  amt = 0;
  g = ninputgroup (P);
  if (!g)
  {
    error (err_tmp);
    return;
  }
  if (g->type->cargo == 0.0)
  {
    sprintf (err_tmp, "Ships in group %d can't carry cargo.\n", groupno);
    error (err_tmp);
    return;
  }
  if (group_check (P, g, NULL, groupno, G_DIST | G_OWNPLANET | G_INTERCEPT))
  {
    error (err_tmp);
    return;
  }

  x = cargospace (g);
  if (x <= g->load)
  {
    sprintf (err_tmp, "Group %d is fully loaded.\n", groupno);
    error (err_tmp);
    return;
  }
  p = g->where;
  x = (x - g->load) * g->ships;
  i = ninputcargotype ();
  if (i == NOCARGO)
  {
    error (err_tmp);
    return;
  }
  if (g->load && g->loadtype != i)
  {
    sprintf (err_tmp, "Group %d is already carrying a different load.\n", groupno);
    error (err_tmp);
    return;
  }
  j = ngeti ();
  if (j == NAI)
    comment = 1;
  if (j == BADI)
  {
    error (err_tmp);
    return;
  }
  if (j > g->ships)
  {
    j = g->ships;
    sprintf (err_tmp, "Only %d ships can be loaded.\n", j);
    error (err_tmp);
  }
  if (j <= 0)
    j = g->ships;
  if (j != g->ships)
  {
    g = new_group (P, g, j);
    x = (cargospace (g) - g->load) * g->ships;  /* bug fix- HJB */
  }
  /* Code to get optional amt of cargo for all ships */
  amt = ngetf ();
  if (amt == MISSINGF)
    amt = 0;
  if (amt == NAF)
  {
    error (err_tmp);
    return;
  }
  if (amt > x)
  {
    sprintf (err_tmp, "Group capacity %0.2f, requested load %0.2f\n", x, amt);
    error (err_tmp);
    return;
  }

  switch (i)
  {
  case CG_CAP:
    x2 = p->cap;
    if (!x2)
    {
      sprintf (err_tmp, "No capital available for group %d.\n", groupno);
      error (err_tmp);
      break;
    }
    if (x2 > x)
      x2 = x;
    if (amt > x2)
    {
      /* Not that much CAP */
      sprintf (err_tmp, "Warning: requested load %0.2f, available CAP %0.2f\n", amt, x2);
      error (err_tmp);
      amt = x2;
    }
    else
    {
      /* If amt set, we want that much, not x2 */
      if (amt > 0)
        x2 = amt;
    }
    g->load += x2 / g->ships;
    p->cap -= x2;
    g->loadtype = CG_CAP;
    break;
  case CG_MAT:
    x2 = p->mat;
    if (!x2)
    {
      sprintf (err_tmp, "No materials available for group %d.\n", groupno);
      error (err_tmp);
      break;
    }
    if (amt > x2)
    {
      /* Not that much MAT */
      sprintf (err_tmp, "Warning: requested load %0.2f, available MAT %0.2f\n", amt, x2);
      error (err_tmp);
      amt = x2;
    }
    else
    {
      /* If amt set, we want that much, not x2 */
      if (amt > 0)
        x2 = amt;
    }
    if (x2 > x)
      x2 = x;
    g->load += x2 / g->ships;
    p->mat -= x2;
    g->loadtype = CG_MAT;
    break;
  case CG_COL:
    x2 = p->col;
    if (!x2)
    {
      sprintf (err_tmp, "No colonists available for group %d.\n", groupno);
      error (err_tmp);
      break;
    }
    if (x2 > x)
      x2 = x;
    if (amt > x2)
    {
      /* Not that much COL */
      sprintf (err_tmp, "Warning: requested load %0.2f, available COL %0.2f\n", amt, x2);
      error (err_tmp);
      amt = x2;
    }
    else
    {
      /* If amt set, we want that much, not x2 */
      if (amt > 0)
        x2 = amt;
    }

    g->load += x2 / g->ships;
    p->col -= x2;
    g->loadtype = CG_COL;
    break;
  }
  extra_token ();
}
