static char *rcsid = "$Header: /plaid/homes/zeus/Blind-2.47/cmds/RCS/k.c,v 2.47 1998/04/15 21:34:50 zeus Exp zeus $";

/*
 *
 * $Log: k.c,v $
 * Revision 2.47  1998/04/15 21:34:50  zeus
 * *** empty log message ***
 *
 * Revision 2.46  1997/04/18 12:13:56  zeus
 * *** empty log message ***
 *
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 */

#define NOTIMEB
 
#include "common.h"

void k_cmd_rcsid (void);

void
k_cmd_rcsid (void)
{
  printf ("%s\n",rcsid);
}

#ifdef KCMD
#include "prototypes.h"
#include "cmds.h"
#include "cmds-g.h"
#include "enterturn-g.h"

extern int null_planet_ok;
extern player *players;
extern planetdefense *defender;
extern char err_tmp[];

void
k_cmd (char *buf, player * P)
{
  char t[MAXTEXT],v[MAXTEXT];
  int status;
  planet *p;
  player *P2;
  planetdefense *pd, *pd2;
  techinfo *tx;
  int comment;

  cmd_init(buf);
  null_planet_ok = DASH;
  comment=0;
  p = ninputplanet (P);
  if (p)
  { /* Only a specific planet */
    if (p->owner == P)
    {
      hstrncpy (t, next_token (), MAXTEXT);
      status = GUARD;
      if (!hstricmp ("war", t))
	status = WAR;
      if (!hstricmp ("peace", t))
	status = PEACE;
      if (!hstricmp ("-", t))
	status = FLUSH;
      if (!hstricmp ("_", t))
	status = FLUSH;
      if (!t[0])
	status = FLUSH;
      /* t never has comment chars, so redundant */
      /*if ((t[0] && !(t[1]) && (t[0]==';' || t[0]=='#')) || (!t[0]))*/
      if (!t[0])
      {
        comment=1;
	status = FLUSH;
      }
      if (status == GUARD)	/* they botched it */
      {
	sprintf (err_tmp, "Unrecognized status \"%s\", Try war|peace\n", t);
	error (err_tmp);
	return;
      }
      else
      {
        P2=NULL;
        if (!comment)
        { 
          hstrncpy (v, next_token (), MAXTEXT);
          if (v[0]) /* Not null racename...*/
          { /* Not a -, then check for valid racename */
            if (v[1] || (v[0]!='-'))
            {
              P2 = nametop (players, v);
              if (!P2)
              { 
                sprintf (err_tmp, "Player \"%s\" not found.\n", v);
                error (err_tmp);
                return;
              }
            }
          }
          else
          {
            error ("Missing player name\n");
            return;
          }
	  /* They entered a valid player */
	  if (P2 == P)
	  { /* Themselves, so now things get interesting... */
	    /* error ("Shooting at yourself?\n");*/
            for (tx=P->othertechs; tx; tx = tx->next)
            {
	      set_defend (tx->whoose, status, p);
            }
	    return;
          }
	}
        if (!known_empire(P,P2))
        {
          sprintf (err_tmp,"You haven't encountered %s yet (if they exist!)\n",P2->name);
          error(err_tmp);
          return;
        }
	set_defend (P2, status, p);
      }
    }
    else
    {
      sprintf (err_tmp, "You don't own system %s.\n", p->num);
      error (err_tmp);
      return;
    }
  }
  else
  { /* Planet name is "-" aka all planets */
    if (null_planet_ok == 0)
    {
      error (err_tmp);
      return;
    }
    hstrncpy (t, next_token (), MAXTEXT);
    if ((t[0] == '-') && (strlen (t) == 1))	/* Possible K - - empire */
    {
       hstrncpy (v, next_token (), MAXTEXT);
       if (!v[0]) /* null racename...*/
       {
         error ("Missing racename\n");
         return;
       }
       if (v[0]=='-' || v[0]=='_') 
         P2=NULL;
       else
       { /* Not a -, then check for valid racename */
         P2 = nametop (players, v);
         if (!P2)
         { 
           sprintf (err_tmp, "Player \"%s\" not found.\n", v);
           error (err_tmp);
           return;
         }
      }
      /* They entered a valid player, or a null one */
      if (P2 == P)
      {				/* Kill _ALL_ K-cmd's */
	for (P2 = players; P2; P2 = P2->next)
	{
	  if (P2 != P)
	  {
	    for (pd = defender; pd; pd=pd2)
            {
              pd2 = pd->next;
	      if ((pd->defender == P2) && (pd->planet->owner == P))
	      {
		removelist (&defender, pd);
	      }
            }
	  }
	}
      }
      else
      {				/* Kill K-cmds related to P2 from P */
	for (pd = defender; pd; pd = pd2)
        {
          pd2 = pd->next;
	  if ((pd->defender == P2) && (pd->planet->owner == P))
	  {
	    removelist (&defender, pd);
	  }
        }
      }
    }
    else
    {
      sprintf (err_tmp, "Unrecognized status \"%s\", Try war|peace\n", t);
      error (err_tmp);
      return;
    }

  }
  if (!comment)
    extra_token ();
}
#endif
