#!/bin/sh

CC='CC=gcc'
CCPIPE='CCPIPE=-pipe'

UNAME=`uname`
REV=`uname -r`

case $UNAME in
  SunOS) case $REV in
           4.1*) echo This looks like a SunOS 4.1 through 4.1.4 system
                 echo This is the OS that this code is most tested on
             ARCH='SUNOS4=-DSUNOS4=1 HPUX9= SOLARIS= ULTRIX= AIX= LINUX= OSF1= IRIX5= IRIX6=';;
           5.*) echo This looks like a Solaris 2.x system
             ARCH='SUNOS4= HPUX9= SOLARIS=-DSOLARIS=1 ULTRIX= AIX= LINUX= OSF1= IRIX5= IRIX6=';;
        esac;;
  HP-UX) case $REV in
           A.09.*) echo This looks like an HP-UX machine running 9.x
             ARCH='SUNOS4= HPUX9=-DHPUX9=1 SOLARIS= ULTRIX= AIX= LINUX= OSF1= IRIX5= IRIX6=';;
           *) echo This is an unfamiliar version of HP-UX. Good luck
             ARCH='SUNOS4= HPUX9=-DHPUX9=1 SOLARIS= ULTRIX= AIX= LINUX= OSF1= IRIX5= IRIX6=';;
        esac;;
  AIX) case $REV in
           *) echo This is AIX
             ARCH='SUNOS4= HPUX9= SOLARIS= ULTRIX= AIX=-DAIX=1 LINUX= OSF1= IRIX5= IRIX6=';;
        esac;;
  ULTRIX) case $REV in
           *) echo This is Ultrix
             CCPIPE='CCPIPE='
             ARCH='SUNOS4= HPUX9= SOLARIS= ULTRIX=-DULTRIX=1 AIX= LINUX= OSF1= IRIX5= IRIX6=';;
        esac;;
  Linux) case $REV in
           *) echo This is Linux $REV
             ARCH='SUNOS4= HPUX9= SOLARIS= ULTRIX= AIX= LINUX=-DLINUX=1 OSF1= IRIX5= IRIX6=';;
        esac;;
  
  OSF1) echo This is OSF $REV
             CCPIPE='CCPIPE='
             ARCH='SUNOS4= HPUX9= SOLARIS= ULTRIX= AIX= LINUX= OSF1=-DOSF1 IRIX5= IRIX6=';;

  IRIX) case $REV in
           5.*) echo Irix $REV
             CCPIPE='CCPIPE='
             ARCH='SUNOS4= HPUX9= SOLARIS= ULTRIX= AIX= LINUX= OSF1= IRIX5=-DIRIX5 IRIX6=';;
           6.*) echo "Irix $REV"
             CC='CC=cc'
             CCPIPE='CCPIPE='
             ARCH='SUNOS4= HPUX9= SOLARIS= ULTRIX= AIX= LINUX= OSF1= IRIX5= IRIX6=-DIRIX6';;
        esac;;

  *) echo "I have no idea what OS this is. You are on your own.";;

  
esac
  

make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=  FORECAST= Blind KCMD=-DKCMD PTECH=-DPTECH PASSWORDS=-DPASSWORDS SMARTC=-DSMARTC SPEED=-DSPEED=31
make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=-DPREPROC FORECAST=-DFORECAST KCMD=-DKCMD PTECH=-DPTECH PASSWORDS=-DPASSWORDS SMARTC=-DSMARTC SPEED=-DSPEED=31 dbg-plus

make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=  FORECAST= Blind KCMD=-DKCMD PTECH=-DPTECH PASSWORDS=-DPASSWORDS SMARTC=-DSMARTC 
make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=-DPREPROC FORECAST=-DFORECAST KCMD=-DKCMD PTECH=-DPTECH PASSWORDS=-DPASSWORDS SMARTC=-DSMARTC dbg-plus

make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=  FORECAST= Blind KCMD=-DKCMD PTECH=-DPTECH PASSWORDS=-DPASSWORDS 
make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=-DPREPROC FORECAST=-DFORECAST KCMD=-DKCMD PTECH=-DPTECH PASSWORDS=-DPASSWORDS dbg-plus

make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=  FORECAST= Blind KCMD=-DKCMD PTECH=-DPTECH 
make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=-DPREPROC FORECAST=-DFORECAST KCMD=-DKCMD dbg-plus

make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=  FORECAST= KCMD=-DKCMD  Blind
make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=-DPREPROC FORECAST=-DFORECAST dbg-plus

make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=  FORECAST= Blind
make clean  # Start fresh
make $CC $CCPIPE $ARCH PREPROC=-DPREPROC FORECAST=-DFORECAST dbg-plus

# New game stuff
make clean
make New-game $CC  $CCPIPE $ARCH PREPROC=  FORECAST= GAMENAME=-DGAMENAME KCMD=-DKCMD SPEED=-DSPEED=31 NEWGAME=-DNEWGAME=1 RANDPLACE=-DRANDPLACE MINSEP=-DMINSEP=20.0 BALANCE=-DBALANCE
