static char *rcsid = "$Header: /plaid/homes/zeus/Blind-2.47/report/RCS/gm.c,v 2.47 1998/04/15 21:37:54 zeus Exp zeus $";

/*
 *
 * $Log: gm.c,v $
 * Revision 2.47  1998/04/15 21:37:54  zeus
 * *** empty log message ***
 *
 * Revision 2.46  1997/04/18 12:25:12  zeus
 * *** empty log message ***
 *
 *
*/

#define NOTIMEB
#include "common.h"
#include "prototypes.h"
#include "report-g.h"
#include "report.h"
#include "options.h"
#include "gm.h"

/* Code used for GM examination of turn reports. */

extern player *players;
extern char buf[];
extern FILE *pr;
extern planet *planets;
extern double galaxysize;
extern int canseeall;
extern int vieweropts;
extern sorted *sorted_planets;
extern bombing *bombings;

void report_gm_rcsid (void);

void
report_gm_rcsid (void)
{
  printf ("%s\n", rcsid);
}

#ifndef NEWGAME
void
showfull (void)                 /* On all systems */
{
  player *P;
  planet *p;
  sorted *s;

  vieweropts = 0;
  P = alloc (sizeof (player));
  memset (P, 0, sizeof (*P));
  for (s = sorted_planets; s; s = s->next)
  {
    /* print the planet */
    sprintf (buf, "\nFull Report on System %s (%s)\n", s->p->name,
      s->p->owner->name);
  
    fbegin (buf, "xxffffffxfff");
    fhead ("N#XYSPIRPC$M");
    printplanet (s->p, P);
    fend ();

    gm_show_owned (P,s->p);
  }
  for (p=planets; p; p=p->next)
  {
    if (!p->owner)
    {
      sprintf (buf, "\nFull Report on System %s\n", p->name);
    
      fbegin (buf, "xxffffff");
      fhead       ("N#XYSR$M");
      fs (p->name);
      fs (p->num);
      ff (wrap (p->x - P->homex));  /* GE - relative coordinate fix */
      ff (cartesian(wrap (p->y - P->homey)));
      ff (p->size);
      ff (p->resources);
      ff (p->cap);
      ff (p->mat);
      fend ();

      gm_show_owned (P,p);
    }
  }
  free (P);
}

void
gm_show_owned (const player *P, planet *p)
{
  player *P3;
  group *g;


  /* print all groups at/en route to the planet */

  for (P3 = players; P3; P3 = P3->next)
    if (canseeplanet (P3, p, 0))
    {
      sprintf (buf, "%s groups at %s", P3->name, p->name);
      fbegin (buf, "iixfifffxfffxxf");
      fhead ("G#TDAWSCTQMSDLR");

      for (g = P3->groups; g; g = g->next)
        if (g->where == p)
          printgroup (P3, g, PG_FULL, 1);
      fend ();
    }
}


void
player_status (void)            /* For all players */
{
  player *P2;
  double pop, ind, max;
  double tpop, tind, tmax, tmass,tttechmass;
  int i, j;
  long int ti, tnum;
  int opts2 = 0;

  ti=tnum=0;
  tpop=tind=tmax=tmass=tttechmass=0.0;

  printf ("Techplus option?");
  getstr ();
  if (tolower (buf[0]) == 'y')
    opts2 = 1;
  if (opts2)
  {
    fbegin ("Status of Players", "xfffffffiiff");
    fhead ("NDWSCMPI#&MT");
  }
  else
  {
    fbegin ("Status of Players", "xfffffffi");
    fhead ("NDWSCMPI#");
  }
  for (P2 = players; P2; P2 = P2->next)
  {
    fs (P2->name);
    ff (P2->tech.drive);
    ff (P2->tech.guns);
    ff (P2->tech.shields);
    ff (P2->tech.cargo);
    report_player_status (&max, &pop, &ind, &i, &j, P2, P2, 1);
    ff (max);
    ff (pop);
    ff (ind);
    fi (i);
    tmax+=max;
    tpop+=pop;
    tind+=ind;
    ti+=i;
    if (opts2)
    {
      int num;
      double mass, techmass;

      calc_status_mass (P2, P2, &num, &mass, &techmass, 1);
      fi (num);
      ff (mass);
      ff (techmass);
      tnum+=num;
      tmass+=mass;
      tttechmass+=techmass;
    }

  }
  fs("Total"); 
  ff(0.0);
  ff(0.0);
  ff(0.0);
  ff(0.0);
  ff(tmax); ff(tpop); ff(tind); fi(ti); 
  if (opts2)
  {
    fi(tnum); ff(tmass);ff(tttechmass);
  }
  fend ();
}
#endif

void
planet_list (void)
{
  planet *p;
  int complete;


  printf ("Standard list? [Y/N] >");
  getstr ();
  switch (tolower (buf[0]))
  {
  case 'y':
    complete = 0;
    break;
  case 'n':
    complete = 1;
    break;
  default:
    complete = 0;
  }

  sprintf (buf, "\nSystem list\n");

  if (complete)
  {
    fbegin (buf, "xxxffffff");
    fhead ("ON#XYSRPI");
  }
  else
  {
    fbegin (buf, "xxxffff");
    fhead ("ON#XYSR");
  }
  for (p = planets; p; p = p->next)
  {
    if (p->owner)
      fs (p->owner->name);
    else
      fs ("-");
    fs (p->name);
    fs (p->num);
    ff (p->x);
    ff (p->y);
    ff (p->size);
    ff (p->resources);
    if (complete)
    {
      ff (p->pop);
      ff (p->ind);
    }
  }
  fend ();
}

void
gm_map (void)
{
  player *P, *P2, *Phold;

  /* Add player -> unique char printing somehow */
  P = alloc (sizeof (player));
  memset (P, 0, sizeof (*P));
  Phold = P;

  P->opts1 = P->opts1 & (MAPPLUS ^ 0xff);
  P->x = 0.0;
  P->y = 0.0;
  P->size = galaxysize;
  P->homex = 0.0;
  P->homey = 0.0;
  printf ("\nGM map options:\n");
  printf ("M)ap\n");
  printf ("S)et co-ords\n");
  printf ("D)imensions of map\n");
  printf ("P)layer's viewpoint\n");
  printf ("U)nique letters\n");
  printf ("Q)uit\n");
  for (;;)
  {
    printf ("MAP>");
    fflush (stdout);
    getstr ();
    switch (tolower (buf[0]))
    {
    case 'm':
      inputpr ();
      canseeall = 1;
      domap (P);
      canseeall = 0;
      if (pr && (pr != stdout))
        fclose (pr);
      break;
    case 's':
      printf ("X-center? >");
      P->homex = getf ();
      printf ("Y-center? >");
      P->homey = getf ();
      if (fabs (P->homex) > galaxysize)
        P->homex = 0.0;
      if (fabs (P->homey) > galaxysize)
        P->homey = 0.0;
      break;
    case 'd':
      printf ("X-center? >");
      P->x = geti ();
      printf ("Y-center? >");
      P->y = geti ();
      if (abs (P->x) > galaxysize)
        P->homex = 0;
      if (abs (P->y) > galaxysize)
        P->homey = 0;
      printf ("Size? >");
      P->size = geti ();
      if (abs (P->size) > galaxysize)
        P->size = galaxysize;
      break;
    case 'u':
      P->opts1 = P->opts1 | MAPPLUS;
      break;
    case 'p':
      P2 = inputplayer (players, "Player?");
      if (P2)
      {
        P = P2;
        P->x = 0.0;
        P->y = 0.0;
        P->size = galaxysize;
      }
      break;
    case 'q':
      free (Phold);
      return;
    case 'x':
      free (Phold);
      return;
    default:
      printf ("\nGM map options:\n");
      printf ("M)ap\n");
      printf ("S)et co-ords\n");
      printf ("P)layer's viewpoint\n");
      printf ("U)nique letters\n");
      printf ("Q)uit\n");
    }

  }
}

#ifndef NEWGAME
void
gm_bombing (void)
{
  bombing *b;
  bombsum *br, *br2;
  int num;
  double pop, ind, col, cap, mat;

  pop=ind=col=cap=mat=0.0;
  num=0;
  br = alloc (sizeof (bombsum));
  fbegin ("Bombing Summary", "xxifffff");
  fhead ("WO#PIC$M");

  for (b = bombings; b; b = b->next)
  {
     add_bomb_rec (b, br, SAW_IT);
     num++;
     pop+=b->pop;
     ind+=b->ind;
     col+=b->col;
     cap+=b->cap;
     mat+=b->mat;
  }
  for (br2 = br->next; br2; br2 = br2->next)
  {
    fs (br2->bomber->name);
    fs (br2->owner->name);
    fi (br2->num_bombed);
    ff (br2->pop);
    ff (br2->ind);
    ff (br2->col);
    ff (br2->cap);
    ff (br2->mat);
  }
  freelist (br);
  fs ("Overall");
  fs ("Total");
  fi (num);
  ff (pop); ff(ind); ff(col); ff(cap); ff(mat);
  fend ();
}

void
gm_battle (void)
{
  print_battle_sum (NULL);
}

#endif
