static char *rcsid = "$Header: /plaid/homes/zeus/Blind-2.46/cmds/RCS/j.c,v 2.46 1997/04/18 12:13:56 zeus Exp zeus $";

/*
 *
 * $Log: j.c,v $
 * Revision 2.46  1997/04/18 12:13:56  zeus
 * *** empty log message ***
 *
 * Revision 2.45  1996/12/31  23:58:44  zeus
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 */

#define NOTIMEB
 
#include "common.h"
#include "prototypes.h"
#include "cmds.h"
#include "cmds-g.h"
#include "enterturn-g.h"

void j_cmd_rcsid (void);

void j_cmd_rcsid (void)
{
  printf ("%s\n",rcsid);
}

extern int groupno;
extern char err_tmp[];
extern int comment;

void
j_cmd (char *buf, player * P)
{
  planet *p=NULL; /* for lint */
  planet *p2;
  group *g;
  group *g2;
  double dist1;
  double dist2;
  fleetname *fl;
  fleetname *fl2;
  int i;
  char v[MAXTEXT];
  char v2[MAXTEXT];

  cmd_init(buf);
  hstrncpy (v, next_token (),MAXTEXT);
  fl = matchfleet (P, v);
  if (!fl)
    g = matchgroup (P, v);
  else
    g = NULL;
  if (!g && !fl)
  {
    error (err_tmp);
    return;
  }
  if (fl)
  {
    hstrncpy (v2, next_token (),MAXTEXT);
    if (!v2[0])
    {
      error ("Missing fleet to join to!\n");
      return;
    }
    fl2 = matchfleet (P, v2);
    if (!fl2)
    {
      sprintf (err_tmp, "Destination fleet %s not recognized\n", v2);
      error (err_tmp);
      return;
    }
    dist1 = 0.0;
    dist2 = 0.0;
    p2 = NULL;
    for (g = P->groups; g; g = g->next)
    {
      if (g->fleet == fl)
      {
	p = g->where;
	dist1 = g->dist;
      }
      if (g->fleet == fl2)
      {
	p2 = g->where;
	dist2 = g->dist;
      }
    }
    if (dist1 > 0.0)
    {
      error ("First fleet is in hyperspace\n");
      return;
    }
    if (dist2 > 0.0)
    {
      error ("Second fleet is in hyperspace\n");
      return;
    }
    if ((p != p2) && (p2))
    {
      error ("Fleets are not at the same planet\n");
      return;
    }
    for (g = P->groups; g; g = g->next)
      if (g->fleet == fl)
	g->fleet = fl2;
    return;
  }
  /* Joining a group to a fleet */
  hstrncpy (v2, next_token (),MAXTEXT);
  if (!v2[0])
  {
    error ("Missing fleet to join to!\n");
    return;
  }
  group_check (P, g, NULL, groupno, G_DIST);
  fl = matchfleet (P, v2);
  if (!fl)
  {
    sprintf (err_tmp,"Fleet \"%s\" not recognized\n",v2);
    error (err_tmp);
    return;
  }
  i = ngeti ();
  if (i == NAI)
    comment = 1;
  if (i == BADI)
  {
    error (err_tmp);
    return;
  }
  if (i == MISSINGI)
    i = 0;

  if ((i > 0) && (g->ships != i))
  {
    if (i > g->ships)
    {
      error ("Not enough ships, all available used\n");
      return;
    }
    g = new_group (P, g, i);
  }
  for (g2 = P->groups; g2; g2 = g2->next)
  {
    if ((g2->fleet == fl) && (g2->dist > 0.0))
    {
      error ("Fleet is in hyperspace\n");
      return;
    }
    if ((g2->fleet == fl) && (!g2->dist) && (g2->where != g->where))
    {
      error ("Group is at the wrong planet\n");
      return;
    }
  }
  if (g->dist > 0.0) 
  {
    error ("Group is in hyperspace\n");
    return;
  }
  g->fleet = fl;
}
