static char *rcsid = "$Header: /plaid/homes/zeus/Blind-2.46/cmds/RCS/e.c,v 2.46 1997/04/18 12:13:15 zeus Exp zeus $";

/*

 * $Log: e.c,v $
 * Revision 2.46  1997/04/18 12:13:15  zeus
 * *** empty log message ***
 *
 * Revision 2.45  1996/12/31  23:57:50  zeus
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 */

#define NOTIMEB

#include "common.h"
#include "prototypes.h"
#include "enterturn-g.h"
#include "cmds.h"
#include "cmds-g.h"

extern char err_tmp[];
extern planet *planets;
extern shiptype *shiptypes;
extern battle *battles;
extern fleetname *fleets;

void e_cmd_rcsid (void);

void
e_cmd_rcsid (void)
{
  printf ("%s\n", rcsid);
}

void
e_cmd (char *buf, player * P)
{
  shiptype *T;
  group *g;
  planet *p;
  battle *B;
  shot *S;
  fleetname *f;
  char t[MAXTEXT];

  cmd_init(buf);
  hstrncpy (t, next_token (), MAXTEXT);
  if (!t[0])
  {
    error ("No type name/FLEET given!\n");
    return;
  }
  if (!hstricmp ("fleet", t))
  {
    char v[MAXTEXT];

    hstrncpy (v, next_token (), MAXTEXT);
    if (!v[0])
    {
      error ("No Fleet name given\n");
      return;
    }
    for (f = fleets; f; f = f->next)
      if ((P == f->owner) && !(hstricmp (f->name, v)))
      {
        for (g = P->groups; g; g = g->next)
        {
          if (g->fleet == f) 
          {
            if (g->dist <= 0.0)
              g->fleet = NULL;    /* Fleetphase () will do cleanup */
            else
            {
              error ("Fleet is in hyperspace!\n");
              return;
            }
          }
        }
        return;
      }
    sprintf (err_tmp, "No fleet matching \"%s\" belongs to you!\n", v);
    error (err_tmp);
    return;
  }
  T = matchtype (P, t);

  if (!T)
  {
    error (err_tmp);
    return;
  }

  for (g = P->groups; g; g = g->next)
    if (g->type == T)
    {
      sprintf (err_tmp, "%s ships still exist.\n", T->name);
      error (err_tmp);
      return;
    }
  for (p = planets; p; p = p->next)
    if (p->owner && p->producing == PR_SHIP &&
        p->producingshiptype == T)
    {
      sprintf (err_tmp, "Systems still producing %s ships.\n", T->name);
      error (err_tmp);
      return;
    }
  for (B = battles; B; B = B->next)
  {
    for (S = B->shots; S; S = S->next)
      if (S->attacker == T || S->target == T)
      {
        sprintf (err_tmp, "Battle involving %s ships still on record.\n",
                 T->name);
        error (err_tmp);
        return;
      }
  }
  removelist (&shiptypes, T);
  extra_token ();
}
