static char *rcsid = "$Header: /plaid/homes/zeus/Blind-2.46/RCS/new-galaxy.c,v 2.46 1997/04/18 12:06:12 zeus Exp zeus $";

/*
 * $Log: new-galaxy.c,v $
 * Revision 2.46  1997/04/18 12:06:12  zeus
 * *** empty log message ***
 *
 * Revision 2.45  1996/12/31  23:40:54  zeus
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 */


#include "protos/common.h"
#include "protos/prototypes.h"
#include "protos/new-game.h"

#ifndef MINSEP
#define MINSEP 20.0
#endif

int main (int argc, char *argv[]);
void new_galaxy_rcsid (void);

extern int file;
planetdefense *defender;

#ifdef GAMENAME
char gamename[MAXTEXT];

#endif



player *players;
int nplanets;
planet *planets;
double galaxysize;
int randseed;
int turn_run = 1;
sorted *sorted_planets;
int turn;
bombing *bombings;
battle *battles;
tmppname *tmpname;
shiptype *shiptypes;
char buf[MAXSTRLEN], buf2[MAXSTRLEN];
fleetname *fleets;

void
new_galaxy_rcsid (void)
{
  printf ("%s\n", rcsid);
}

int
main (int argc, char *argv[])
{

  float version = VER;
  player *P;
  int player_flag = 0;

  printf ("Galaxy v2.9 by Russell Wallace  " __DATE__ "\n");
  printf ("Blind  v%4.2f\n", version);
  printf ("New game version\n");
  printf ("Checking for existing blindrc....\n");
  file = open ("blindrc", O_RDWR | O_BINARY);
  if (file >= 0)
  {
    fprintf (stderr, "Won't overwrite existing blindrc!\n");
    close(file);
    exit (1);
  }

  assert (MINSEP >= 0.0);
  galaxysize = 0.0;
  do
  {
    printf ("Size of galaxy? ");
    galaxysize = getf ();
  }
  while (galaxysize < MINSEP);  /* Just to ensure a sane value */

  /* Seed random number genorator... */

#if (HPUX9==1) || (SOLARIS==1) || (USESRAND48==1)
  /* Don't really need to trunciate, but so what */
  srand48 ((long) (time (NULL)) % 32768);
#else
  srandom ((time (NULL)) % 32768);
#endif

  for (;;)                      /* MAIN INPUT LOOP */
  {
    printf ("> ");
    getstr ();
    switch (tolower (buf[0]))
    {

    case '+':                   /* redo seed */
      printf ("New random seed?");
      randseed = geti ();

#if (HPUX9==1) || (SOLARIS==1) || (USESRAND48==1)
      srand48 ((long) randseed);
#else
      srandom (randseed);
#endif

      break;
    case 'x':                   /* exit, no changes */
      return 0;
    case 'c':
      if (player_flag == 1)
      {
        player_flag = 2;
        create_galaxy ();
        sortplanets ();
        defender = NULL;
      }
      else
        printf ("Need to do players first, or only do this once.\n");
      break;
    case 'q':
      if (player_flag != 2)
      {
        printf ("Aborting, due to human input\n");
        return 1;
      }
      savegame ();

#ifdef BACKUPS
      {
        char tmp[MAXSTRLEN];

        sprintf (tmp, "cp blindrc blindrc.%d.bak", turn);
        system (tmp);
      }
#endif

      return 0;
    case 'p':                   /* add a player */
      if (player_flag == 2)
        printf ("Rest of galaxy done, won't do it.\n");
      else
      {
        player_flag = 1;
        addplayer ();
      }
      break;
    case 'd':                   /* Delete player */
      printf ("Player name? ");
      getstr ();
      if (!buf[0])
        break;
      if (!(P = nametop (players, buf)))
      {
        printf ("Player %s is not in use.\n", buf);
        break;
      }
      else
        delete_player (P, 1);
      break;
    case 'l':
      inputpr ();
      planet_list ();
      break;
    case 'm':
      gm_map ();
      break;
    case 'n':
      if (player_flag == 2)
        manual_move_planet ();
      else
        printf ("Rest of galaxy has to be done first.\n");
      break;
    case 'v':
      version_info ();
      break;
    case 'z':
      full_version ();
      break;

    default:
      printf (
               "Q = Quit playing around, and finish galaxy\n"
               "X = Exit without saving\n"
               "\n"
               "+ = New random seed\n"
               "D = Delete player\n"
               "C = Create rest of galaxy\n"
               "L = pLanet info\n"
               "M = Map\n"
               "N = New location for a world\n"
               "P = Create Player\n"
               "V = Version info\n"
               "Z = RCS Version info\n"
        );
    }
  }
}
