static char *rcsid = "$Header: /plaid/homes/zeus/Blind-2.45/cmds/RCS/t.c,v 2.45 1997/01/01 00:05:49 zeus Exp zeus $";

/*

 * $Log: t.c,v $
 * Revision 2.45  1997/01/01  00:05:49  zeus
 * *** empty log message ***
 *
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 */

#define NOTIMEB

#include "../protos/common.h"
#include "../protos/prototypes.h"
#include "../protos/enterturn-g.h"
#include "../protos/cmds.h"
#include "../protos/cmds-g.h"

extern char tbuf[];
extern int pos;
extern char err_tmp[];
extern shiptype *shiptypes;
extern fleetname *fleets;

void t_cmd_rcsid (void);

void
t_cmd_rcsid (void)
{
  printf ("%s\n", rcsid);
}

void
t_cmd (char *buf, player * P)
{
  shiptype *T, *T2;
  char t[MAXTEXT];

#ifdef UPGRADE
  fleetname *fl, *fl2;
  char v[MAXTEXT];

#endif

  hcstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();

#ifdef UPGRADE
  hstrncpy (v, next_token (), MAXTEXT);
  T = matchtype (P, v);
  fl = matchfleet (P, v);
  if (T || fl)
  {
    hstrncpy (t, next_token (), MAXTEXT);
    if (t[0])
    {
      for (T2 = shiptypes; T2; T2 = T2->next)
        if ((T2->owner == P) && (!hstricmp (T2->name, t)) && (T2 != T))
        {
          sprintf (err_tmp, "Ship type name \"%s\" is already in use.\n", t);
          error (err_tmp);
          return;
        }
      for (fl2 = fleets; fl2; fl2 = fl2->next)
        if ((fl2->owner == P) && !hstricmp (fl2->name, t) && (fl2 != fl))
        {
          sprintf (err_tmp, "Fleet of name \"%s\" is already in use.\n", t);
          error (err_tmp);
          return;
        }
    }
    else
    {
      error (err_tmp);
      return;
    }
  }
  else
  {
    error ("No matching fleet or ship type.\n");
    return;
  }
  if (legal_name (t, 0))
  {
    error (err_tmp);
    return;
  }
  if (T)
    hstrncpy (T->name, t, MAXTEXT);
  if (fl)
    hstrncpy (fl->name, t, MAXTEXT);

#else
  T = ninputshiptype (P);
  if (T)
  {
    hstrncpy (t, next_token (), MAXTEXT);
    if (t[0])
    {
      for (T2 = shiptypes; T2; T2 = T2->next)
        if (T2->owner == P && !hstricmp (T2->name, t))
        {
          sprintf (err_tmp, "Ship type name \"%s\" is already in use.\n", t);
          error (err_tmp);
          return;
        }
      hstrcpy (T->name, t);
    }
  }
  else
  {
    error (err_tmp);
  }
#endif

  extra_token ();
}
