static char *rcsid = "$Header: /plaid/homes/zeus/Blind-2.45/cmds/RCS/d.c,v 2.45 1996/12/31 23:56:55 zeus Exp zeus $";

/*

 * $Log: d.c,v $
 * Revision 2.45  1996/12/31  23:56:55  zeus
 * *** empty log message ***
 *
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * *** empty log message ***
 *
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 *
 */

#define NOTIMEB

#include "../protos/common.h"
#include "../protos/prototypes.h"
#include "../protos/enterturn-g.h"
#include "../protos/cmds.h"
#include "../protos/cmds-g.h"

extern char tbuf[];
extern int pos;
extern char err_tmp[];
extern shiptype *shiptypes;

#ifdef UPGRADE
extern fleetname *fleets;

#endif

static char *productionname[] =
{
  "cap",
  "mat",
  "ship",
  "drive",
  "weapons",
  "shields",
  "cargo",
};

void d_cmd_rcsid (void);
void
d_cmd_rcsid (void)
{
  printf ("%s\n", rcsid);
}

void
d_cmd (char *buf, player * P)
{
  char t[MAXTEXT];
  shiptype *T, *T2;
  int i;

#ifdef UPGRADE
  fleetname *fl, *f;
  int x, ok;

#endif

  hcstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  hstrncpy (t, next_token (), MAXTEXT);
  if (!t[0])
  {
    error ("No type name given!\n");
    return;
  }
  for (i = 0; i < sizeof (productionname) / sizeof (char *); i++)

  {
    if (strcmp (productionname[i], "ship") && !(hstricmp (productionname[i], t)))
    {
      sprintf (err_tmp, "ship name %s collides with produciton type\n",
               productionname[i]);
      error (err_tmp);
      return;
    }
  }

#ifdef UPGRADE
  if (!hstricmp ("fleet", t))
  {
    char v[MAXTEXT];

    hstrncpy (v, next_token (), MAXTEXT);
    if (!v[0])
    {
      error ("No Fleet name given\n");
      return;
    }
    for (f = fleets; f; f = f->next)
      if ((P == f->owner) && !(hstricmp (f->name, t)))
      {
        sprintf (err_tmp, "Fleet name \"%s\" already in use\n", t);
        error (err_tmp);
        return;
      }
    for (T2 = shiptypes; T2; T2 = T2->next)
      if (T2->owner == P && !hstricmp (T2->name, v))
      {
        sprintf (err_tmp, "Ship of type name \"%s\" is already in use.\n", v);
        error (err_tmp);
        return;
      }
    for (x = 0, ok = 1; v[x] && ok; x++)
      if (!isdigit (v[x]))
        ok = 0;
    if (ok)
    {
      error ("Fleet names can not be numbers.\n");
      return;
    }
    if (!hstricmp (v, "max"))
    {
      error ("Fleet name of \"max\" is illegal\n");
      return;
    }
    fl = alloc (sizeof (fleetname));
    hstrncpy (fl->name, v, MAXTEXT);
    fl->fleetspeed = 1000.0;
    fl->owner = P;
    addlist (&fleets, fl);
    return;
  }
#endif

  for (T2 = shiptypes; T2; T2 = T2->next)
    if (T2->owner == P && !hstricmp (T2->name, t))
    {
      sprintf (err_tmp, "Ship type name \"%s\" is already in use.\n", t);
      error (err_tmp);
      return;
    }

#ifdef SIZEBUG
  T = alloc (sizeof (shiptype) + sizeof (int));
  memset (T, 0, sizeof (shiptype) + sizeof (int));

#else
  T = alloc (sizeof (shiptype));
  memset (T, 0, sizeof (shiptype));
#endif

  addlist (&shiptypes, T);
  hstrncpy (T->name, t, MAXTEXT);       /* Bug patch */
  T->owner = P;

#ifdef UPGRADE
  T->numbuilt = 0;
#endif

  T->drive = ninputcomponent ();
  if (T->drive == MISSINGF)
  {
    error ("Missing Drive component\n");
    removelist (&shiptypes, T);
    return;
  }
  if (T->drive == NAF)
  {
    error (err_tmp);
    removelist (&shiptypes, T);
    return;
  }
  T->nguns = ngeti ();
  if (T->nguns == MISSINGI)
  {
    error ("Missing number of guns component\n");
    removelist (&shiptypes, T);
    return;
  }
  if (T->nguns == BADI)
  {
    error ("Malformed number of guns component\n");
    removelist (&shiptypes, T);
    return;
  }
  T->guns = ninputcomponent ();
  if (!T->nguns)
    T->guns = 0.0;
  if (!T->guns)
    T->nguns = 0;
  if (T->guns == MISSINGF)
  {
    error ("Missing Gun size component\n");
    removelist (&shiptypes, T);
    return;
  }
  if (T->guns == NAF)
  {
    error (err_tmp);
    removelist (&shiptypes, T);
    return;
  }
  T->shields = ninputcomponent ();
  if (T->shields == MISSINGF)
  {
    error ("Missing Shields component\n");
    removelist (&shiptypes, T);
    return;
  }
  if (T->shields == NAF)
  {
    error (err_tmp);
    removelist (&shiptypes, T);
    return;
  }
  T->cargo = ninputcomponent ();
  if (T->cargo == MISSINGF)
  {
    error ("Missing Cargo component\n");
    removelist (&shiptypes, T);
    return;
  }
  if (T->cargo == NAF)
  {
    error (err_tmp);
    removelist (&shiptypes, T);
    return;
  }
  if (!T->drive && !T->nguns && !T->shields && !T->cargo)
  {
    sprintf (err_tmp, "At least one component must be non-zero.\n");
    error (err_tmp);
    removelist (&shiptypes, T);
    return;
  }
  if ((T->drive == BADF) || (T->nguns == BADI) || (T->shields == BADF)
      || (T->cargo == BADF))
  {
    sprintf (err_tmp, "Components can not be between 0.01 and 0.99.\n");
    error (err_tmp);
    removelist (&shiptypes, T);
    return;
  }
  if (!T->drive && T->cargo)
  {
    sprintf (err_tmp, "Driveless cargo ships?\n");
    error (err_tmp);
    removelist (&shiptypes, T);
    return;
  }
  if ((T->drive > 1.0) && (T->nguns == 0) && (T->shields == 0) && (T->cargo == 0))
  {
    error ("A ship with drive 1.0, would be cheaper\n");
  }
  extra_token ();
}
