static char *rcsid = "$Header: /silver/homes/zeus/Blind-2.44/RCS/report-gm.c,v 2.44 1995/12/31 19:45:18 zeus Exp zeus $";

#define NOTIMEB
#include "common.h"
#include "prototypes.h"
#include "report-g.h"
#include "report.h"
#include "options.h"
 
/* Code used for GM examination of turn reports. */

extern player *players;
extern char buf[];
extern FILE *pr;
extern planet *planets;
extern double galaxysize;
extern int canseeall;
extern int vieweropts;
extern sorted *sorted_planets;

void report_gm_rcsid (void);

void
report_gm_rcsid (void)
{
  printf ("%s\n", rcsid);
}

#ifndef NEWGAME 
void
showfull (void)  /* On all systems */
{
  player *P;
  player *P3;
  planet *p;
  sorted *s;
  group *g;
 
  vieweropts = 0;
  P = alloc (sizeof (player));
  memset (P, 0, sizeof (*P));
  for (s = sorted_planets; s; s = s->next)
  {
    p = s->p;
    /* print the planet */
 
    sprintf (buf, "\nFull Report on System %s\n", p->name);
 
    fbegin (buf, "xxffffffxfff");
    fhead ("N#XYSPIRPC$M");
    printplanet (p, P);
    fend ();
 
    /* print all groups at/en route to the planet */
 
    for (P3 = players; P3; P3 = P3->next)
      if (canseeplanet (P3, p, 0))
      {
        sprintf (buf, "%s groups at %s", P3->name, p->name);
        fbegin (buf, "iixfifffxfffxxf");
        fhead ("G#TDAWSCTQMSDLR");
 
        for (g = P3->groups; g; g = g->next)
          if (g->where == p)
            printgroup (P3, g, PG_FULL,1);
        fend ();
      }
  }
 
  if (pr && (pr != stdout))
    fclose (pr);
  free (P);
}

void
player_status (void)  /* For all players */
{
  player *P2;
  double pop, ind, max;
  int i, j;
  int opts2 = 0;

  printf ("Techplus option?");
  getstr ();
  if (tolower (buf[0]) == 'y')
    opts2 = 1;
  if (opts2)
  {
    fbegin ("Status of Players", "xfffffffiiff");
    fhead ("NDWSCMPI#&MT");
  }
  else
  {
    fbegin ("Status of Players", "xfffffffi");
    fhead ("NDWSCMPI#");
  }
  for (P2 = players; P2; P2 = P2->next)
  {
    fs (P2->name);
    ff (P2->tech.drive);
    ff (P2->tech.guns);
    ff (P2->tech.shields);
    ff (P2->tech.cargo);
    report_player_status (&max, &pop, &ind, &i, &j, P2, P2, 1);
    ff (max);
    ff (pop);
    ff (ind);
    fi (i);
    if (opts2)
    {
      int num;
      double mass, techmass;

      calc_status_mass (P2, P2, &num, &mass, &techmass, 1);
      fi (num);
      ff (mass);
      ff (techmass);
    }

  }
  fend ();

  if (pr && (pr != stdout))
    fclose (pr);
}
#endif

void
planet_list (void)
{
  planet *p;
  int complete;


  printf ("Standard list? [Y/N] >");
  getstr ();
  switch (tolower (buf[0]))
  {
  case 'y':
    complete = 0;
    break;
  case 'n':
    complete = 1;
    break;
  default:
    complete = 0;
  }

  sprintf (buf, "\nSystem list\n");

  if (complete)
  {
    fbegin (buf, "xxxffffff");
    fhead (      "ON#XYSRPI");
  }
  else
  {
    fbegin (buf, "xxxffff");
    fhead (      "ON#XYSR");
  }
  for (p = planets; p; p = p->next)
  {
    if (p->owner)
      fs (p->owner->name);
    else
      fs ("-");
    fs (p->name);
    fs (p->num);
    ff (p->x);
    ff (p->y);
    ff (p->size);
    ff (p->resources);
    if (complete)
    {
      ff (p->pop);
      ff (p->ind);
    }
  }
  fend ();

  if (pr && (pr != stdout))
    fclose (pr);
}

void
gm_map (void)
{
  player *P, *P2;

  /* Add player -> unique char printing somehow */
  P = alloc (sizeof (player));
  memset (P, 0, sizeof (*P));

  P->opts1 = P->opts1 & (MAPPLUS ^ 0xff);

#ifdef V3
  P->x = 0.0;
  P->y = 0.0;
  P->size = galaxysize;
#endif

  P->homex = 0.0;
  P->homey = 0.0;
  printf ("\nGM map options:\n");
  printf ("M)ap\n");
  printf ("S)et co-ords\n");
  printf ("D)imensions of map\n");
  printf ("P)layer's viewpoint\n");
  printf ("U)nique letters\n");
  printf ("Q)uit\n");
  for (;;)
  {
    printf ("MAP>");
    fflush(stdout);
    getstr ();
    switch (tolower (buf[0]))
    {
    case 'm':
      inputpr ();
      canseeall = 1;
      domap (P);
      canseeall = 0;
      if (pr && (pr != stdout))
        fclose (pr);
      break;
    case 's':
      printf ("X-center? >");
      P->homex = getf ();
      printf ("Y-center? >");
      P->homey = getf ();
      if (fabs (P->homex) > galaxysize)
        P->homex = 0.0;
      if (fabs (P->homey) > galaxysize)
        P->homey = 0.0;
      break;
#ifdef V3
    case 'd':
      printf ("X-center? >");
      P->x = geti ();
      printf ("Y-center? >");
      P->y = geti ();
      if (abs (P->x) > galaxysize)
        P->homex = 0;
      if (abs (P->y) > galaxysize)
        P->homey = 0;
      printf ("Size? >");
      P->size = geti ();
      if (abs (P->size) > galaxysize)
        P->size = galaxysize;
      break;
#endif
    case 'u':
      P->opts1 = P->opts1 | MAPPLUS;
      break;
    case 'p':
      P2 = inputplayer (players, "Player?");
      if (P2)
      {
        P = P2;

#ifdef V3
        P->x = 0.0;
        P->y = 0.0;
        P->size = galaxysize;
#endif
      }
      break;
    case 'q':
      return;
    case 'x':
      return;
    default:
      printf ("\nGM map options:\n");
      printf ("M)ap\n");
      printf ("S)et co-ords\n");
      printf ("P)layer's viewpoint\n");
      printf ("U)nique letters\n");
      printf ("Q)uit\n");
    }

  }
}
