static char *rcsid = "$Header: /silver/homes/zeus/Blind-2.44/cmds/RCS/n.c,v 2.44 1995/12/31 19:45:18 zeus Exp zeus $";

/*

 * $Log: n.c,v $
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 */

#define NOTIMEB

#include "../protos/common.h"
#include "../protos/prototypes.h"
#include "../protos/enterturn-g.h"
#include "../protos/cmds.h"
#include "../protos/cmds-g.h"

extern char tbuf[];
extern int pos;
extern planet *planets;
extern char err_tmp[];

void n_cmd_rcsid (void);

void
n_cmd_rcsid (void)
{
  printf ("%s\n", rcsid);
}

void
n_cmd (char *buf, player * P)
{
  planet *p, *p2;
  char t[MAXTEXT];
  int tnum, rnum;

  hcstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  p = ninputplanet ();
  if (p)
  {
    if (p->owner != P)
    {
      sprintf (err_tmp, "You don't own system %s.\n", p->num);
      error (err_tmp);
      return;
    }
    hstrncpy (t, next_token (), MAXTEXT);


    if (t[0])
    {
      p2 = nametop (planets, t);
      /* This way they can rename if all they are doing is changing cases */
      if ((p2) && (p2 != p) )
      {
        sprintf (err_tmp, "System name \"%s\" is already in use.\n", t);
        error (err_tmp);
        return;
      }
      if (!legal_name (t, 0))   /* No funny characters... */
      {
        if (isnum (t, INT))
        {
          tnum = atoi (t);
          rnum = atoi (p->num);
          if (tnum != rnum)
          {
            sprintf (err_tmp,
                     "System name of \"%s\" for system \"%s\" pointless\n", 
                     t, p->num);
            error (err_tmp);
            return;
          }
        }
        hstrcpy (p->name, t);
      }
      else
      {
        error (err_tmp);
        return;
      }

    }
  }
  else
  {
    error (err_tmp);
    return;
  }
  extra_token ();
}
