static char *rcsid = "$Header: /silver/homes/zeus/Blind-2.44/cmds/RCS/b.c,v 2.44 1995/12/31 19:45:18 zeus Exp zeus $";

/*
 *
 * $Log: b.c,v $
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 */

#define NOTIMEB
 
#include "common.h"
#include "prototypes.h"
#include "cmds.h"
#include "cmds-g.h"
#include "enterturn-g.h"
#include "misc-g.h"
#include "options.h"

extern char tbuf[];
extern char err_tmp[];
extern int pos;
extern int groupno;

void b_cmd_rcsid (void);
void
b_cmd_rcsid (void)
{
  printf ("%s\n",rcsid);
}

void
b_cmd (char *buf, player * P)
{

  group *g;
  int i;

#ifdef UPGRADE
  fleetname *fl;
  char v[MAXTEXT];
  group *g2;

#endif

  hcstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  g = ninputgroup (P);
  if (!g)
  {
    error (err_tmp);
    return;
  }

#ifdef UPGRADE
  hstrncpy (v, next_token (),MAXTEXT);
  fl = matchfleet (P, v);
  if (fl)			/* B group fleet */
  {
    if ((g->dist != UPG) && (g->dist != 0.0))
    {
      error ("Fleet is in hyperspace\n");
      return;
    }

    if (g->fleet != fl)
    {
      sprintf (err_tmp, "Group %d not a part of fleet \"%s\"\n",
	       ptonum (P->groups, g), fl->name);
      error (err_tmp);
    }
    /* Get optional # ships to break from fleet */
    hstrncpy (v, next_token (),MAXTEXT);
    if (!v[0])	/* No ships, so whole group */
      g->fleet = NULL;
    else
    {
      if (isnum(v,INT))
      {
        i = atoi (v);
      }
      else
      {
        if (v[0] != ';' && v[0] != '#')
        {
        sprintf (err_tmp, "Number expected.\n");
        i = MISSINGI;
        }
        else i=0;
      }
      if (i < 0)
      {
	error (err_tmp);
	return;
      }
      if (i == 0)
	i = g->ships;
      /* Whine iff they break off too many, or if they break off all
         ships in a group, and UNSAFEBREAK is not set */
      if (((i >= g->ships) && !(P->opts1 & UNSAFEBREAK)) ||
	  ((i > g->ships) && (P->opts1 & UNSAFEBREAK)))
      {
	sprintf (err_tmp, "Not enough ships (%d/%d) in group %d.\n", i,
		 g->ships, groupno);
	error (err_tmp);
	return;
      }
      g2 = new_group (P, g, i);
      g2->fleet = NULL;
      if (g->ships == 0)	/* i.e. UNSAFEBREAK is on */
	g->dist = -4.0;
    }
    extra_token ();
    return;
  }				/* Not b group fleet, error or b group num */
  if (strlen (v) == 0)
  {
    error ("Missing Fleet or number of ships!\n");
    return;
  }
  if (isnum(v,INT))
    i = atoi (v);
  else
  {
    sprintf (err_tmp, "Number expected.\n");
    i = MISSINGI;
  }
#else
  i = ngeti ();
#endif

  if (i < 0)
  {
    error (err_tmp);
    return;
  }
  if (i == 0)
    i = g->ships;
  if (((i >= g->ships) && !(P->opts1 & UNSAFEBREAK)) ||
      ((i > g->ships) && (P->opts1 & UNSAFEBREAK)))
  {
    sprintf (err_tmp, "Not enough ships (%d/%d) in group %d.\n", i, g->ships, groupno);
    error (err_tmp);
    return;
  }
  if (group_check (P, g, NULL, groupno, G_DIST))
  {				/* broke off of a group in hyperspace */
    error (err_tmp);
    return;
  }
  (void) new_group (P, g, i);
  extra_token ();
}
