static char *rcsid = "$Header: /silver/homes/zeus/Blind-2.44/RCS/report-battle.c,v 2.44 1995/12/31 19:45:18 zeus Exp zeus $";

/*
 * $Log: report-battle.c,v $
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 */

#define NOTIMEB
#include "protos/common.h"
#include "protos/prototypes.h"
#include "protos/report-g.h"
#include "protos/report.h"
#include "protos/misc-g.h"
#include "protos/i-o.h"

void report_battle_rcsid (void);

void
report_battle_rcsid (void)
{
  printf ("%s\n", rcsid);
}

extern char buf[];
extern battle *battles;
extern bombing *bombings;
extern player *players;
extern FILE *pr;

void
print_player_groups_in_battle (player * P, participant * PA)
{
  group *g;

#ifdef V3
  if (P->opts1 & BATTLESUM)
  {
    if (P->opts2 & TECHS)
    {
      fbegin (buf, "iixffffxfff");
      fhead ("R#TDWSCTQMS");
    }
    else
    {
      fbegin (buf, "iixfifffxfff");
      fhead ("R#TDAWSCTQMS");
    }
    for (g = PA->groups; g; g = g->next)
      printgroup (P, g, PG_BATSUM, 1);
    fend ();
  }
  else
#endif

  {
    if (P->opts2 & TECHS)
    {
      fbegin (buf, "ixffffxfff");
      fhead ("#TDWSCTQMS");
    }
    else
    {
      fbegin (buf, "ixfifffxfff");
      fhead ("#TDAWSCTQMS");
    }
    for (g = PA->groups; g; g = g->next)
      printgroup (P, g, PG_SIMP_BATTLE, 1);
    fend ();
  }
}

void
print_battles (player * P)
{
  player *P2;
  shot *S;
  battle *B;
  viewer *V;
  participant *PA;

  for (B = battles; B; B = B->next)
  {
    for (V = B->viewers; V; V = V->next)
      if (V->who == P)
        break;
    if (V)
    {
      strcpy (buf, B->where->name);
      ckunderscores (buf);
      if (canseeplanet (P, B->where,1))
        fprintf (pr, "\t\tBattle at %s (%s)\n\n", B->where->num, buf);
      else
        fprintf (pr, "\t\tBattle at %s\n\n", B->where->num);
      for (PA = B->participants; PA; PA = PA->next)
      {
        if (PA->who == P)
        {
          sprintf (buf, "Your Groups");
          print_player_groups_in_battle (P, PA);
          break;
        }
      }
      for (PA = B->participants; PA; PA = PA->next)
      {
        P2 = PA->who;
        if (P2 != P)
        {
          strcpy (buf, P2->name);
          ckunderscores (buf);
          strcat (buf, " Groups");
          print_player_groups_in_battle (P, PA);
        }
      }

#ifndef V3
      /*
       * Note: This code is not going to be used because it gives away info
       * that wasn't available eariler in the game. Uncomment it if you wish
       */
      /*
         if (P->opts1 & BATTLESUM) 
         { 
         for (PA = B->participants; PA; PA = PA->next) 
         { 
         P2 = PA->who; 
         sprintf (buf, "%s Remaining Groups", P2 == P ? "Your" : P2->name); 
         fbegin (buf, "xi"); 
         fhead ("T#"); 
         for (g = PA->who->groups; g; g = g->next) 
         if (g->where == B->where && !g->dist) 
         { 
         fs (g->type->name); 
         fi (g->ships); 
         } 
         fend (); 
         }     
         }
       */
#endif

#ifdef V3
      if (P->opts1 & BATTLEMASS)
      {
        group *g;
        double bm, fm, btm, ftm;
        double m;
        int b, f;

        sprintf (buf, "Battle masses");
        fbegin (buf, "xiffifff");
        fhead ("W#MT#MT ");
        for (PA = B->participants; PA; PA = PA->next)
          if (PA->who == P)
          {
            b = f = 0;
            bm = fm = btm = ftm = 0.0;
            for (g = PA->groups; g; g = g->next)
            {
              b += g->ships;
              m = (typemass (g->type));
              f += g->left;
              fm += m * (double) g->left;
              ftm += (double) g->left * ttechmass (g);
              bm += m * (double) g->ships;
              btm += (double) g->ships * ttechmass (g);
            }
            if (bm > 0.0)
            {
              fs (P->name);
              fi (f);
              ff (fm);
              ff (ftm);
              fi (b);
              ff (bm);
              ff (btm);
              ff (100.0 * fm / bm);
            }
            break;
          }
        for (PA = B->participants; PA; PA = PA->next)
          if (PA->who != P)
          {
            b = f = 0;
            bm = fm = btm = ftm = 0.0;
            for (g = PA->groups; g; g = g->next)
            {
              b += g->ships;
              f += g->left;
              m = (typemass (g->type));
              fm += m * (double) g->left;
              ftm += (double) g->left * ttechmass (g);
              bm += m * (double) g->ships;
              btm += (double) g->ships * ttechmass (g);
            }
            if (bm > 0.0)
            {
              fs (PA->who->name);
              fi (f);
              ff (fm);
              ff (ftm);
              fi (b);
              ff (bm);
              ff (btm);
              ff (100.0 * fm / bm);
            }
          }
        fend ();
      }
#endif

      if (!(P->opts1 & LONGBATTLE))
        /* print the blow-by-blow, but only for those that care... */
      {
        fbegin ("", "xxxxxx");
        for (S = B->shots; S; S = S->next)
        {
          fs (S->attacker->owner->name);
          fs (S->attacker->name);
          fs ("fires on");
          fs (S->target->owner->name);
          fs (S->target->name);
          fs (S->kill ? ":  Destroyed" : ":  Shields");
        }
        fend ();
      }
    }
  }
}

void
print_battle_sum (player * P)
{
  battle *B;
  participant *PA;
  int numb, pnum, nump;
  group *g;
  int *b, *f;
  double *bm, *fm, *btm, *ftm;
  double ms;
  int m;



  nump = listlen (players) + 1;
  bm = alloc (nump * sizeof (double));
  fm = alloc (nump * sizeof (double));
  btm = alloc (nump * sizeof (double));
  ftm = alloc (nump * sizeof (double));
  b = alloc (nump * sizeof (int));
  f = alloc (nump * sizeof (int));
  memset (bm,0, sizeof(double) * nump);
  memset (fm,0, sizeof(double) * nump);
  memset (btm,0, sizeof(double) * nump);
  memset (ftm,0, sizeof(double) * nump);
  memset (b,0, sizeof(int) * nump);
  memset (f,0, sizeof(int) * nump);

  numb = 0;                     /* No battles yet */

  for (B = battles; B; B = B->next)
  {
    if (P)
      for (PA = B->participants; PA; PA = PA->next)
        if (PA->who == P)
          break;
    if (PA || !P)               /* We participated, or are GM */
    {
      numb++;
      for (PA = B->participants; PA; PA = PA->next)
      {
        pnum = ptonum (players, PA->who);
        for (g = PA->groups; g; g = g->next)
        {
          b[pnum] += g->ships;
          ms = (typemass (g->type));
          f[pnum] += g->left;
          fm[pnum] += ms * (double) g->left;
          ftm[pnum] += (double) g->left * ttechmass (g);
          bm[pnum] += ms * (double) g->ships;
          btm[pnum] += (double) g->ships * ttechmass (g);
        }
      }
    }
  }
  if (numb)
  {
    sprintf (buf, "Battle summary for %d battles\n", numb);
    fbegin (buf, "xiffifff");
    fhead ("W#MT#MT ");

    for (m = 0; m < nump; m++)
    {
      if (bm[m] > 0)
      {
        for (P=players,pnum=0;P;pnum++,P=P->next)
        {
          if (pnum==m-1)
          {
            fs (P->name);
            break;
          }
        }
        assert (P);
        fi (f[m]);
        ff (fm[m]);
        ff (ftm[m]);
        fi (b[m]);
        ff (bm[m]);
        ff (btm[m]);
        ff (100.0 * fm[m] / bm[m]);
      }
    }
    fend();
  }
  free (bm);
  free (btm);
  free (fm);
  free (ftm);
  free (b);
  free (f);
}


void
print_bombings (player * P)
{
  bombing *b;
  battle *B;
  viewer *V;

  fbegin ("Bombings", "xxxxfffff");
  fhead ("WO#NPIC$M");
  for (b = bombings; b; b = b->next)
  {
    for (V = b->viewers; V; V = V->next)
    {
      if (V->who == P)
        break;
    }
    if (V)                      /* Saw the bombing */
    {
      for (B = battles; B; B = B->next)
      {
        if (B->where == b->where)
          break;
      }
      if (B)                    /* Was a battle */
      {
        for (V = B->viewers; V; V = V->next)
          if (V->who == P)
            break;
        if (V)                  /* Saw the battle */
        {                       /* So print bomber info */
          fs (b->who->name);
        }
        else
          fs ("?");             /* Didn't see battle */
      }
      else
      {
        if (canseeplanet (P, b->where,1))    /* No battle, but you can see it */
          fs (b->who->name);
        else
          fs ("?");             /* Was no battle */
      }
      fs (b->whoose->name);
      fs (b->where->num);
      fs (b->where->name);
      ff (b->pop);
      ff (b->ind);
      ff (b->col);
      ff (b->cap);
      ff (b->mat);
    }
  }
  fend ();
}
