static char *rcsid = "$Header: /silver/homes/zeus/Blind-2.44/cmds/RCS/j.c,v 2.44 1995/12/31 19:45:18 zeus Exp zeus $";

/*
 *
 * $Log: j.c,v $
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 */

#define NOTIMEB
 
#include "../protos/common.h"
#include "../protos/prototypes.h"
#include "../protos/cmds.h"
#include "../protos/cmds-g.h"
#include "../protos/enterturn-g.h"

void j_cmd_rcsid (void);
void j_cmd_rcsid (void)
{
  printf ("%s\n",rcsid);
}

#ifdef UPGRADE
extern char tbuf[];
extern int pos;
extern int groupno;
extern char err_tmp[];
extern int comment;

void
j_cmd (char *buf, player * P)
{
  planet *p=NULL; /* for lint */
  planet *p2;
  group *g;
  group *g2;
  double dist1;
  double dist2;
  fleetname *fl;
  fleetname *fl2;
  int i;
  char v[80];
  char v2[80];

  hcstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();

  hstrcpy (v, next_token ());
  fl = matchfleet (P, v);
  if (!fl)
    g = matchgroup (P, v);
  else
    g = NULL;
  if (!g && !fl)
  {
    error (err_tmp);
    return;
  }
  if (fl)
  {
    hstrcpy (v2, next_token ());
    if (!v2[0])
    {
      error ("Missing fleet to join to!\n");
      return;
    }
    fl2 = matchfleet (P, v2);
    if (!fl2)
    {
      sprintf (err_tmp, "Destination fleet %s not recognized\n", v2);
      error (err_tmp);
      return;
    }
    dist1 = 0.0;
    dist2 = 0.0;
    p2 = NULL;
    for (g = P->groups; g; g = g->next)
    {
      if (g->fleet == fl)
      {
	p = g->where;
	dist1 = g->dist;
      }
      if (g->fleet == fl2)
      {
	p2 = g->where;
	dist2 = g->dist;
      }
    }
    if (dist1 > 0.0)
    {
      error ("First fleet is in hyperspace\n");
      return;
    }
    if (dist2 > 0.0)
    {
      error ("Second fleet is in hyperspace\n");
      return;
    }
    if ((p != p2) && (p2))
    {
      error ("Fleets are not at the same planet\n");
      return;
    }
    for (g = P->groups; g; g = g->next)
      if (g->fleet == fl)
	g->fleet = fl2;
    return;
  }
  /* Joining a group to a fleet */
  hstrcpy (v2, next_token ());
  if (!v2[0])
  {
    error ("Missing fleet to join to!\n");
    return;
  }
  group_check (P, g, NULL, groupno, G_DIST);
  /*
     if (g->dist1 > 0.0)
     {
     error ("Group is in hyperspace\n");
     return;
     } */
  fl = matchfleet (P, v2);
  if (!fl)
  {
    error ("Fleet name not recognized\n");
    return;
  }
  i = ngeti ();
  if (i == NAI)
    comment = 1;
  if (i == BADI)
  {
    error (err_tmp);
    return;
  }
  if (i == MISSINGI)
    i = 0;

  if ((i > 0) && (g->ships != i))
  {
    if (i > g->ships)
    {
      error ("Not enough ships, all available used\n");
      return;
    }
    g = new_group (P, g, i);
  }
  for (g2 = P->groups; g2; g2 = g2->next)
  {
    if ((g2->fleet == fl) && (g2->dist > 0.0))
    {
      error ("Fleet is in hyperspace\n");
      return;
    }
    if ((g2->fleet == fl) && (!g2->dist) && (g2->where != g->where))
    {
      error ("Group is at the wrong planet\n");
      return;
    }
  }
  if (g->dist > 0.0) 
  {
    error ("Group is in hyperspace\n");
    return;
  }
  g->fleet = fl;
}
#endif
