static char *rcsid = "$Header: /silver/homes/zeus/Blind-2.44/RCS/report-map.c,v 2.44 1995/12/31 19:45:18 zeus Exp zeus $";

/*
 * $Log: report-map.c,v $
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * *** empty log message ***
 *
 * Revision 2.43  1995/03/20  01:43:09  zeus
 * *** empty log message ***
 *
 */

#define NOTIMEB
#include "protos/common.h"
#include "protos/prototypes.h"
#include "protos/report.h"
#include "protos/report-g.h"


void report_map_rcsid (void);

void
report_map_rcsid (void)
{
  printf ("%s\n", rcsid);
}

extern battle *battles;
extern bombing *bombings;
extern double galaxysize;
extern char buf[256];
extern planet *planets;
extern FILE *pr;

#ifdef FORECAST
extern int seenlist[];

#endif

char map[MAPWIDTH][MAPHEIGHT];

double
wrap (double coord)		/* GE: wraps an idividual coordinate (X or Y)
				 * so all planets display on a
				 * player-centered map */
{
  if (coord > (galaxysize / 2.0))
    return (coord - galaxysize);
  if (coord < (-galaxysize / 2.0))
    return (coord + galaxysize);
  return coord;
}

int
scrsize (double a, double b)
{
  int i;

  spf (buf, a);
  i = strlen (buf);
  spf (buf, b);
  return i + 1 + strlen (buf);
}

/* Arg 7 SHOULD be a char, but gcc 2.6.3 moans about it for some
asinine reason, unless it is an int. */
void
putmap (double x1, double y1, double x2, double y2, double x, double y, int c)
{
  int ix, iy;

  ix = (int) ((x - x1) / (x2 - x1) * MAPWIDTH);
  iy = (int) ((y - y1) / (y2 - y1) * MAPHEIGHT);
  if (ix < 0 || ix >= MAPWIDTH || iy < 0 || iy >= MAPHEIGHT)
    return;
  map[ix][iy] = (char ) c;
}

void
domap (player * P)
{
  int i, j;
  double x1, x2, y1, y2;
  planet *p;

#ifdef V3
  x1 = P->x - P->size / 2.0;
  x2 = P->x + P->size / 2.0;
  y1 = P->y - P->size / 2.0;
  y2 = P->y + P->size / 2.0;
#else
  x1 = y1 = - (galaxysize/2.0);
  x2 = y2 = galaxysize/2.0;
#endif

  rpf (x1);
  fputc (',', pr);
  rpf (y1);
  for (i = MAPWIDTH - scrsize (x1, y1) - scrsize (x2, y1); i != 0; i--)
    fputc (' ', pr);
  rpf (x2);
  fputc (',', pr);
  rpf (y1);
  fputc ('\n', pr);
  for (i = 0; i < MAPWIDTH; i++)
    fputc ('-', pr);
  fputc ('\n', pr);

  memset (map, ' ', sizeof (map));

#ifdef FORECAST
  /* Planets you can't see */
  for (p = planets; p; p = p->next)
    if (!seenlist[ptonum (planets, p)])
      putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
	      wrap (p->y - P->homey), (int) '?');

  /* unowned planets you can see */

  for (p = planets; p; p = p->next)
  {
    if ((!p->owner) && seenlist[ptonum (planets, p)])
      if ((P->opts1 & MAPPLUS) && (p->size <= ALMOSTZERO))
	putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
		wrap (p->y - P->homey), (int) '0');
      else if (P->opts1 & MAPPLUS)
	putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
		wrap (p->y - P->homey), (int) '@');
      else
	putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
		wrap (p->y - P->homey), (int) 'o');
  }


  /* Alien planets */

  for (p = planets; p; p = p->next)
    if (p->owner && p->owner != P && seenlist[ptonum (planets, p)])

      if (P->opts1 & MAPPLUS)
      {
	putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
		wrap (p->y - P->homey), p->owner->name[0]);
      }
      else
      {
	putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
		wrap (p->y - P->homey), (int) '+');
      }


  /* your planets */
  for (p = planets; p; p = p->next)
    if ((p->owner == P) && seenlist[ptonum (planets, p)])
      putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
	      wrap (p->y - P->homey), (int) '*');

#else
  /* planets you don't know about becuase you can't see them */
  for (p = planets; p; p = p->next)
    if (!(canseeplanet (P, p)))
      putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
	      wrap (p->y - P->homey), (int) '?');

  /* Battles you can see. Ones you survived will be clobbered */

  if (P->opts1 & MAPPLUS)
    for (p = planets; p; p = p->next)
    {
      battle *B;
      viewer *V;

      for (B = battles; B; B = B->next)
      {
	if (B->where == p)
	  for (V = B->viewers; V; V = V->next)
	    if (V->who == P)
	    {
	      putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
		      wrap (p->y - P->homey), (int) '#');
	      break;
	    }
      }
    }

  /* unowned planets you can see */
  for (p = planets; p; p = p->next)
  {
    if ((!p->owner) && canseeplanet (P, p))
    {
      if ((P->opts1 & MAPPLUS) && (p->size <= ALMOSTZERO))
      {
	putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
		wrap (p->y - P->homey), (int) '0');
      }
      else if (P->opts1 & MAPPLUS)
	putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
		wrap (p->y - P->homey), (int) '@');
      else
	putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
		wrap (p->y - P->homey), (int) 'o');
    }
  }

  /* owned by someone else planets you can see */
  for (p = planets; p; p = p->next)
    if (p->owner && p->owner != P && canseeplanet (P, p))

      if (P->opts1 & MAPPLUS)
      {
	putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
		wrap (p->y - P->homey), p->owner->name[0]);
      }
      else
      {
	putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
		wrap (p->y - P->homey), (int) '+');
      }

  /* your planets */
  for (p = planets; p; p = p->next)
    if (p->owner == P)
      putmap (x1, y1, x2, y2, wrap (p->x - P->homex),
	      wrap (p->y - P->homey), (int) '*');
#endif

  for (i = 0; i < MAPHEIGHT; i++)
  {
    for (j = 0; j < MAPWIDTH; j++)
      fputc (map[j][i], pr);
    fputc ('\n', pr);
  }

  for (i = 0; i < MAPWIDTH; i++)
    fputc ('-', pr);
  fputc ('\n', pr);
  rpf (x1);
  fputc (',', pr);
  rpf (y2);
  for (i = MAPWIDTH - scrsize (x1, y2) - scrsize (x2, y2); i > 0; i--)
    fputc (' ', pr);
  rpf (x2);
  fputc (',', pr);
  rpf (y2);
  fprintf (pr, "\n\n");
}				/* end of map section */
