static char *rcsid = "$Header: /silver/homes/zeus/Blind-2.43/RCS/Blind.c,v 2.43 1995/03/20 01:43:00 zeus Exp zeus $";

/*
 * $Log: Blind.c,v $
 * Revision 2.43  1995/03/20  01:43:00  zeus
 * *** empty log message ***
 *
 * Revision 2.42  1994/05/17  13:43:15  bampton
 * Revision 2.41  1994/04/08  03:11:28  bampton
 * Revision 2.40  1994/03/09  20:22:55  bampton
 * Revision 2.38  1993/09/27  17:15:54  bampton
 * Revision 2.37  1993/09/07  20:50:32  bampton
 * Revision 2.36  1993/08/19  16:32:29  bampton
 * Revision 2.34  1993/08/09  23:06:20  bampton
 * Revision 2.33  1993/08/03  23:10:13  bampton
 * Revision 2.30  1993/07/14  14:59:26  bampton
 * Revision 0.0  1993/07/14  13:41:34  bampton RCS prototype.
 *
 */

/*
 * Galaxy game Copyright 1991 by Russell Wallace. This is a text-based
 * strategy game for 2 or more players, suitable for    playing directly or
 * by mail. Written in standard ANSI C, should compile & run on any system.
 * See documentation for details. Will work with 16-bit ints but 32-bit ints
 * recommended as 16-bit limits some quantities.  This code may be freely
 * used and distributed non-commercially provided that this message is not
 * altered or omitted. It may not be sold or used commercially without prior
 * written permission from the author.
 */

/*
 * Compile flags to use: See the file Readme
 */

#define NOTIMEB

#include "protos/common.h"
#include "protos/prototypes.h"
#include "protos/new-game.h"
#include "protos/turn-g.h"
#include "protos/exit.h"

int main (int argc, char *argv[]);
void blind_rcsid (void);

extern player *players;
extern battle *battles;
extern bombing *bombings;
extern double galaxysize;
extern planet *planets;
extern int turn;
extern shiptype *shiptypes;
extern int file;
extern char buf[256], buf2[256];
extern FILE *pr;
extern int randseed;
extern planetdefense *defender;

#ifdef GAMENAME
char gamename[MAXTEXT];

#endif

#ifdef PREPROC
extern int bad;
extern int turn_run;

#endif

int nplanets;

void
blind_rcsid (void)
{
  printf ("%s\n", rcsid);
}

int
main (int argc, char *argv[])
{

  float version = VER;
  double size;
  planet *p;

#ifndef PREPROC

#ifdef REPORTDIR
  char reportd[] = REPORTDIR;

#endif
  int i;
  player *P;
  char fileext[MAXTEXT];

#endif

  printf ("Galaxy v2.9 by Russell Wallace  " __DATE__ "\n");
  printf ("Blind  v%4.2f\n", version);
  file = open ("blindrc", O_RDWR | O_BINARY);
  if (file >= 0)
  {
    loadgame ();
    close (file);

#ifdef GAMENAME

#ifdef FIX
    printf ("Name of game?");
    getstr ();
    strcpy (gamename, buf);
#else
    printf ("Gamename:%s\n", gamename);
#endif

#endif

    nplanets = 0;
    size = 0;
    for (p = planets; p; p = p->next)
    {
      nplanets++;
      size += p->size;
    }

#ifndef PREPROC
    printf ("\nGalaxy Size ");
    fpf (stdout, galaxysize);
    printf ("\n%d Systems with Total Size ", nplanets);
    fpf (stdout, size);
    printf ("\nTurn:%d Seed:%d", turn, randseed);
    putchar ('\n');
#else
    printf ("Preprocessor version\n");
    printf ("Turn %d\n", turn);
#endif
  }

  /* MAIN INPUT LOOP */

  for (;;)
  {

#ifndef PREPROC
    printf ("> ");
#endif

    if (argc > 1)
    {
      strcpy (buf, argv[1]);
      argc--;
      argv++;
    }
    else
      getstr ();
    switch (tolower (buf[0]))
    {

#ifndef PREPROC
    case '+':			/* redo seed */
      printf ("New random seed?");
      randseed = geti ();
#if HPUX || SOLARIS || USESRAND48
      srand48((long)randseed);
#else
      srandom (randseed);
#endif
      break;
    case '*':			/* print renamed planets */
      for (p = planets; p; p = p->next)
	if (strcmp (p->num, p->name) != 0)
	  printf ("%s\t%s\n", p->num, p->name);
      break;
#endif

    case 'x':			/* exit, no changes */
      return 0;
    case 'q':

#ifndef PREPROC
      file = open ("blindrc", O_CREAT | O_TRUNC | O_RDWR | O_BINARY, 0600);
      if (file < 0)
      {
	printf ("Can't create file blindrc.\n");
	return 1;
      }
      savegame ();

#ifdef BACKUPS
      {
	char tmp[80];

	sprintf (tmp, "cp blindrc blindrc.%d.bak", turn);
	system (tmp);
      }
#endif

      return 0;
#else
      /* Preprocessor doesn't save game.... */
      return (bad);
#endif

#ifndef PREPROC
    case 'd':			/* Delete player */
      printf ("Player name? ");
      getstr ();
      if (!buf[0])
	break;
      if (!(P = nametop (players, buf)))
      {
	printf ("Player %s is not in use.\n", buf);
	break;
      }
      else
	delete_player (P, 1);
      break;

    case 'a':			/* Get all reports */
      strcpy (fileext, ".r");
      printf ("Filename extension? [.r] ");
      getstr ();
      if (buf[0])
      {
	strcpy (fileext, buf);
	if (buf[0] != '.')
	  sprintf (fileext, ".%s", buf);
      }
      for (P = players; P; P = P->next)
      {
	i = strlen (P->name);
	while (i && P->name[i - 1] != ' ' && P->name[i - 1] != '\'')
	  i--;

#ifdef REPORTDIR
	sprintf (buf, "%s/%s%s", reportd, P->name + i, fileext);
#else
	sprintf (buf, "%s%s", P->name + i, fileext);
#endif

	pr = fopen (buf, "w");
	if (pr == 0)
	{
	  printf ("Can't open %s\n", buf);
	  break;
	}
	printf ("Writing report %s\n", buf);
	report (P);
	fclose (pr);
      }
      break;

    case 'r':			/* Get single report */
      P = inputplayer (players, "Player?");
      if (P)
      {
	inputpr ();
	report (P);
      }
      break;
    case 's':			/* Player dip status */
      {
	player *P1, *P2;

	P1 = inputplayer (players, "Asking Player? ");
	P2 = inputplayer (players, "about Player? ");
	dip_status (P1, P2);
      }
      break;
    case 'k':			/* full echo status for all players */
      inputpr ();
      player_status ();
      break;
    case 'f':			/* full listing for all planets */
      inputpr ();
      showfull ();
      break;
    case 'l':
      inputpr ();
      planet_list ();		/* Show planet sizes, loc's and such */
      break;
    case 'm':
      gm_map ();
      break;
    case 'g':
      go ();
      break;
    case 'y':
      inputpr ();
      forward_list ();
      break;
    case 'b':
      for (P = players; P; P = P->next)
      {
	if (P->lastorders == turn + 1)
	  printf ("%s has orders for this turn\n", P->name);
      }
      break;
#endif

    case 't':
      do
      {
	enterturn ();
      }
      while (!feof (stdin));
      break;
    case 'e':
      enterturn ();

#ifdef PREPROC
      {
	player *P=NULL;

	if (!turn_run) {
	  for (P = players; P; P = P->next)
	  {
	    if (turn < P->lastorders)
	      break;
	  }
	if (!P)			/* No orders at all */
	  bad = EMPTYORDERS; }
      }
#endif

      break;

    case 'v':
      version_info ();
      break;

    case 'z':
      full_version ();
      break;

#ifndef PREPROC
    default:
      printf (
	       "A = Report on All Players\n"
	       "R = Report for One Player\n"
	       "E = Enter Turn\n"
	       "T = Enter Turns until EOF\n"
	       "G = Go\n"
	       "Q = Quit\n"
	       "X = Exit without saving\n"
	       "\n"
	       "* = List renamed systems\n"
	       "+ = New random seed\n"
	       "B = Current order status\n"
	       "D = Delete player\n"
	       "F = Full report on all systems\n"
	       "K = Kurrent players status\n"
	       "L = pLanet info\n"
	       "M = Map\n"
	       "R = player Relationships\n"
	       "S = Diplomatic status\n"
	       "V = Version info\n"
	       "Y = Forewarding list (Howard)\n"
	       "Z = RCS Version info\n"
	);
#else
    default:
      printf ("E = Enter Turn\n"
	      "Q = Quit\n");
#endif
    }
  }
}
