static char *rcsid = "$Header: /silver/homes/zeus/Blind-2.43/cmds/RCS/l.c,v 2.43 1995/03/20 01:43:09 zeus Exp zeus $";

/*
 *
 * $Log: l.c,v $
 * Revision 2.43  1995/03/20  01:43:09  zeus
 * *** empty log message ***
 *
 *
 */

#define NOTIMEB
 
#include "../protos/common.h"
#include "../protos/prototypes.h"
#include "../protos/enterturn-g.h"
#include "../protos/cmds.h"
#include "../protos/cmds-g.h"

extern char tbuf[];
extern int pos;
extern char err_tmp[];
extern int groupno;
extern int comment;

void
l_cmd (char *buf, player * P)
{
  group *g;
  int i, j;
  double x, x2;
  planet *p;

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  g = ninputgroup (P);
  if (!g)
  {
    error (err_tmp);
    return;
  }
  if (g->type->cargo == 0)
  {
    sprintf (err_tmp, "Ships in group %d can't carry cargo.\n", groupno);
    error (err_tmp);
    return;
  }
  if (group_check (P, g, NULL, groupno, G_DIST | G_OWNPLANET | G_INTERCEPT))
  {
    error (err_tmp);
    return;
  }

  x = cargospace (g);
  if (x <= g->load)
  {
    sprintf (err_tmp, "Group %d is fully loaded.\n", groupno);
    error (err_tmp);
    return;
  }
  p = g->where;
  x = (x - g->load) * g->ships;
  i = ninputcargotype ();
  if (i == -1)
  {
    error (err_tmp);
    return;
  }
  if (g->load && g->loadtype != i)
  {
    sprintf (err_tmp, "Group %d is already carrying a different load.\n", groupno);
    error (err_tmp);
    return;
  }
  j = ngeti ();
  if (j == -3)
    comment = 1;
  if (j == -2)
  {
    error (err_tmp);
    return;
  }
  if (j > g->ships)
  {
    j = g->ships;
    sprintf (err_tmp, "Only %d ships can be loaded.\n", j);
    error (err_tmp);
  }
  if (j <= 0)
    j = g->ships;
  if (j != g->ships)
  {
    g = new_group (P, g, j);
    x = (cargospace (g) - g->load) * g->ships;	/* bug fix- HJB */
  }
  switch (i)
  {
  case CG_CAP:
    x2 = p->cap;
    if (!x2)
    {
      sprintf (err_tmp, "No capital available for group %d.\n", groupno);
      error (err_tmp);
      break;
    }
    if (x2 > x)
      x2 = x;
    g->load += x2 / g->ships;
    p->cap -= x2;
    g->loadtype = CG_CAP;
    break;
  case CG_MAT:
    x2 = p->mat;
    if (!x2)
    {
      sprintf (err_tmp, "No materials available for group %d.\n", groupno);
      error (err_tmp);
      break;
    }
    if (x2 > x)
      x2 = x;
    g->load += x2 / g->ships;
    p->mat -= x2;
    g->loadtype = CG_MAT;
    break;
  case CG_COL:
    x2 = p->col;
    if (!x2)
    {
      sprintf (err_tmp, "No colonists available for group %d.\n", groupno);
      error (err_tmp);
      break;
    }
    if (x2 > x)
      x2 = x;
    g->load += x2 / g->ships;
    p->col -= x2;
    g->loadtype = CG_COL;
    break;
  }
  extra_token ();
}
