static char *rcsid = "$Header: /silver/homes/zeus/Blind-2.43/cmds/RCS/b.c,v 2.43 1995/03/20 01:43:09 zeus Exp zeus $";

/*
 *
 * $Log: b.c,v $
 * Revision 2.43  1995/03/20  01:43:09  zeus
 * *** empty log message ***
 *
 *
 */

#define NOTIMEB
 
#include "../protos/common.h"
#include "../protos/prototypes.h"
#include "../protos/cmds.h"
#include "../protos/cmds-g.h"
#include "../protos/enterturn-g.h"
#include "../protos/misc-g.h"

extern char tbuf[];
extern char err_tmp[];
extern int pos;
extern int groupno;

void
b_cmd (char *buf, player * P)
{

  group *g;
  int i;

#ifdef UPGRADE
  fleetname *fl;
  char v[80];
  group *g2;

#endif

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  g = ninputgroup (P);
  if (!g)
  {
    error (err_tmp);
    return;
  }

#ifdef UPGRADE
  hstrcpy (v, next_token ());
  fl = matchfleet (P, v);
  if (fl)			/* B group fleet */
  {
    if ((g->dist != UPG) && (g->dist != 0.0))
    {
      error ("Fleet is in hyperspace\n");
      return;
    }

    if (g->fleet != fl)
    {
      sprintf (err_tmp, "Group %d not a part of fleet %s\n",
	       ptonum (P->groups, g), fl->name);
      error (err_tmp);
    }
    hstrcpy (v, next_token ());	/* Get optional # ships to break from fleet */
    if (strlen (v) == 0)	/* No ships, so whole group */
      g->fleet = NULL;
    else
    {
      if (isnum(v,INT))
        i = atoi (v);
      else
      {
        if (v[0] != ';' && v[0] != '#')
        {
        sprintf (err_tmp, "Number expected.\n");
        i = -1;
        }
        else i=0;
      }
      if (i < 0)
      {
	error (err_tmp);
	return;
      }
      if (i == 0)
	i = g->ships;
      /* Whine iff they break off too many, or if they break off all
         ships in a group, and UNSAFEBREAK is not set */
      if (((i >= g->ships) && !(P->opts1 & UNSAFEBREAK)) ||
	  ((i > g->ships) && (P->opts1 & UNSAFEBREAK)))
      {
	sprintf (err_tmp, "Not enough ships (%d/%d) in group %d.\n", i,
		 g->ships, groupno);
	error (err_tmp);
	return;
      }
      g2 = new_group (P, g, i);
      g2->fleet = NULL;
      if (g->ships == 0)	/* i.e. UNSAFEBREAK is on */
	g->dist = -4.0;
    }
    extra_token ();
    return;
  }				/* Not b group fleet, error or b group num */
  if (strlen (v) == 0)
  {
    error ("Missing Fleet or number of ships!\n");
    return;
  }
  if (isnum(v,INT))
    i = atoi (v);
  else
  {
    sprintf (err_tmp, "Number expected.\n");
    i = -1;
  }
#else
  i = ngeti ();
#endif

  if (i < 0)
  {
    error (err_tmp);
    return;
  }
  if (i == 0)
    i = g->ships;
  if (((i >= g->ships) && !(P->opts1 & UNSAFEBREAK)) ||
      ((i > g->ships) && (P->opts1 & UNSAFEBREAK)))
  {
    sprintf (err_tmp, "Not enough ships (%d/%d) in group %d.\n", i, g->ships, groupno);
    error (err_tmp);
    return;
  }
  if (group_check (P, g, NULL, groupno, G_DIST))
  {				/* broke off of a group in hyperspace */
    error (err_tmp);
    return;
  }
  (void) new_group (P, g, i);
  extra_token ();
}
