#include <stdio.h>
#include "gchdr.h"
#include "gcio.h"

#if !DEBUG_ALLOC
#define getmem malloc
#define getcmem calloc
#endif

static BYTE _put_gcb _(( FILE *, PLAYER *, GC_MISC * ));


static BYTE _put_gcb(P(FILE *) gcb_datei, P(PLAYER *) player, P(GC_MISC *) gcb)
PP(FILE *gcb_datei;)
PP(PLAYER *player;)
PP(GC_MISC *gcb;)
{
	int i;
	SCH_TYP *typ;
	
	/* Aktuelle Versionsnummer des Zugeditors */
	
	fprintf(gcb_datei, "%d.%d  Bentigte GC-Bee Version\n", GC_MAJOR, GC_MINOR);
	fprintf(gcb_datei, "%s  Kennung der GC-Runde\n", gcb->gc_id);
	fprintf(gcb_datei, "%d  Spielernummer\n", player->pl_number);
	fprintf(gcb_datei, "%d  Heimatplanet\n", player->pl_heimat);
	fprintf(gcb_datei, "%d  Gre des Universums\n", gcb->maxMapSize);
	fprintf(gcb_datei, "%d  Anzahl Planeten\n", gcb->anz_planeten);
	fprintf(gcb_datei, "%d  Maximale Anz. TF\n", gcb->max_tf);
	fprintf(gcb_datei, "%d  Anzahl Spieler\n", gcb->anz_spieler);
	for (i = 0; i < gcb->anz_spieler; i++)
		fprintf(gcb_datei, "%s\n", gcb->spieler[i]->pl_name);
	fprintf(gcb_datei, "%d  Anzahl Schiffstypen\n", gcb->anz_stypen);
	for (i = 1; i <= gcb->anz_stypen; i++)
	{
		typ = SH_TYP(i);
		fprintf(gcb_datei, "%d %d %d %d %d\n",
			typ->t_att, typ->t_def, typ->t_transp,
			typ->t_kosten[0], typ->t_reichw[0]);
	}
	for (i = 0; i < ANZ_GUETER; i++)
		fprintf(gcb_datei, "%d Kosten\n", gcb->kosten_goods[i]);
	for (i = 0; i < ANZ_LADUNG; i++)
		fprintf(gcb_datei, "%d Volumen\n", gcb->trans_goods[i]);
	for (i = 0; i < ANZ_TL; i++)
		fprintf(gcb_datei, "%d Techlevel\n", gcb->kosten_tl[i]);
	return(OK);
}


BYTE put_gcb(P(PLAYER *) player, P(char *) pathname)
PP(PLAYER *player;)
PP(char *pathname;)
{
	FILE *gcb_datei;
	char datei[MAX_PATHLEN];
	BYTE fehler;

	/* Dateinamen zusammen basteln aus Spielername+Extension */
	sprintf(datei, "%s%s", pathname, EXT_GCB);

	if ((gcb_datei = fopen(datei, FWRITE_TEXT)) == NULL)
		return(FEHLER_O);
	if (verbose)
		fprintf (stderr, "writing %s ...\n", datei);
	fehler = _put_gcb(gcb_datei, player, &gc_global);
	f_close(gcb_datei);
	return(fehler);
}




