#include <stdio.h>
#include "gchdr.h"
#include "gcio.h"

static BYTE _put_flb _(( PLAYER *, FILE * ));

/*
 * FLB-Datei schreiben
 */
static BYTE _put_flb(P(PLAYER *) player, P(FILE *) flb_datei)
PP(PLAYER *player;)
PP(FILE *flb_datei;)
{
	SCHIFF *ship;
	SCHIFF **schiff;
	int i;
	
	schiff = player->pl_ships;
	for (i = 0; i < player->pl_num_ships; i++)
	{
		ship = schiff[i];
		fputword(flb_datei, ship->s_number);
		fputword(flb_datei, ship->s_kills);
		fputword(flb_datei, ship->s_pos);
		fputword(flb_datei, ship->s_ziel);
		fputbyte(flb_datei, ship->s_typ);
		fputbyte(flb_datei, ship->s_atl);
		fputbyte(flb_datei, ship->s_vtl);
		fputbyte(flb_datei, ship->s_reichw);
		fputbyte(flb_datei, ship->s_moved);
		fputbyte(flb_datei, ship->s_distance);
		fputbyte(flb_datei, ship->s_tf_nr);
		fputbyte(flb_datei, ship->s_cur_def);
		fputbyte(flb_datei, ship->s_cur_transp);
		fputbyte(flb_datei, ship->s_ladung[LAD_SPARES]);
		fputbyte(flb_datei, ship->s_ladung[LAD_MPE]);
		fputbyte(flb_datei, ship->s_ladung[LAD_LPE]);
		fputbyte(flb_datei, ship->s_ladung[LAD_RPE]);
		fputbyte(flb_datei, ship->s_ladung[LAD_MKITS]);
		fputbyte(flb_datei, ship->s_ladung[LAD_LKITS]);
		fputbyte(flb_datei, ship->s_ladung[LAD_RKITS]);
		fputbyte(flb_datei, ship->s_ladung[LAD_FKITS]);
		fputbyte(flb_datei, ship->s_ladung[LAD_KOLONIST]);
		if (ferror(flb_datei))
			return(FEHLER_W);
	}
	return(OK);
}


BYTE put_flb(P(PLAYER *) player, P(char *) pathname)
PP(PLAYER *player;)
PP(char *pathname;)
{
	FILE *flb_datei;
	BYTE fehler;
	char datei[MAX_PATHLEN];
	
	sprintf(datei, "%s%s", pathname, EXT_FLB);

	if ((flb_datei = fopen(datei, FWRITE_BIN)) == NULL)
	{
		return(FEHLER_O);
	}
	if (verbose)
		fprintf (stderr, "writing %s ...\n", datei);
	fehler = _put_flb(player, flb_datei);
	f_close(flb_datei);
	return(fehler);
}




