/* Programm Parameter */
#define Version "2.5"
#define VDate "11 July 1994"


typedef int Bool;

#define PS_Y1	764
#define PS_Y2	714
#define PS_Y3	32
#define PS_Y4   90

#define GS_Y1	740
#define GS_Y2	690
#define GS_Y3	56
#define GS_Y4	114

#define PS_FONT	"Palatino"
#define GS_FONT	"Utopia"

#define SMALL_CARD	459.448
#define NORMAL_CARD	510.448

#define MAX_RADIEN 5

#ifndef EXTERN
#  define EXTERN extern
#  define INIT(x) /**/
#else
#  undef EXTERN
#  define EXTERN /**/
#  define INIT(x) = x
#endif

EXTERN char *program_name;

/* Option -z: Map auf maximale Groesse bringen */
EXTERN Bool	zoom INIT(FALSE);

/* Option -zp: Nur Teilstueck der Map anzeigen */
EXTERN Bool part INIT(FALSE);
EXTERN XY map_max;
EXTERN XY map_min;

/* Option -t: Map verschieben */
EXTERN XY map_offset;

/* Option -n: grosse Map mit Icons als PL */
EXTERN Bool normal INIT(FALSE);
EXTERN Bool showScouted INIT(FALSE);

/* Option -d: Debug-Ausgaben erzeugen */
EXTERN int	debug INIT(0);

/* Option -v: ein paar Meldungen erzeugen */
EXTERN Bool verbose INIT(FALSE);

/* Option -q: Warnmeldungen unterdruecken */
EXTERN Bool quiet INIT(FALSE);

/* Option -r: Spy-Ranges der Planeten anzeigen */
EXTERN Bool	showRange INIT(FALSE);

/* Option -g: Gitter malen */
EXTERN Bool	gitter INIT(FALSE);

/* Option -gs: Anpassungen fuer Ghostscript */
EXTERN Bool	gsfix INIT(FALSE);

/* Option -l: Grenzen einzeichnen */
EXTERN Bool	limesline INIT(FALSE);

/* Option -m: Verteidigung und Anzahl Festungen anzeigen */
EXTERN Bool	monster INIT(FALSE);

/* Option -n: Speicher sparen, schoene Gruesse an Kleinweich */
EXTERN Bool	messydos INIT(FALSE);

/* Option -x: Planeteninformation anzeigen */
EXTERN Bool	plotStatus INIT(TRUE);

/* Option -o: Radien um Heimatplaneten zeichnen */
EXTERN Bool	gebiet INIT(FALSE);
EXTERN WORD radius[MAX_RADIEN+1];

/* Option -f: Alternativer Fontname */
EXTERN char fontname[41] INIT(PS_FONT);

/* Option -s: Skalierung */
EXTERN double scale INIT(1.0);


EXTERN double corr_x;
EXTERN double corr_y;
EXTERN WORD mapSize;            /* Groesse des gezoomten Bereichs  */


/* GETARGS.C */

void    get_map_args _(( int argc, char **argv, BYTE (*map_func) _(( char *, PLAYER * )) ));

/* MAKEMAP.C */
BYTE	create_map _(( char *fname, PLAYER *aWorld,
	Bool joinMaps, BYTE (*map_func) _(( char *, PLAYER * )) ));
void FindHomePlanets _(( void ));

/* PSFUNCT.C */
BYTE	buildPS _(( char *fname, PLAYER *aWorld ));
BYTE	buildASC _(( char *fname, PLAYER *aWorld ));

/* MAPTOOLS.C */
void	translateMap _(( PLAYER *aWorld, WORD x_offset, WORD y_offset ));
void	zoomMap _(( PLAYER *aWorld ));
void	miniMap _(( PLAYER *aWorld ));
void	freeMap _(( PLAYER *aWorld ));
BYTE	MakeMap _(( PLAYER *aWorld ));
BYTE	MergeInfo _(( PLAYER *aWorld ));
void	debugFile _(( PLAYER *aWorld, char *dName ));

/* JOINMAPS.C */
Bool	joinMaps _(( PLAYER *aWorld ));

/* UPDATMPS.C */
BYTE	get_mps _(( char *fname, PLAYER *aWorld ));
BYTE	put_mps _(( char *fname, PLAYER *aWorld ));
void	SortLimes _(( PLAYER *aWorld ));
LIMES*	AddLime _(( LIMES **list, WORD number, double x, double y, WORD line_number ));
void	UpdateLimesPos _(( PLAYER *player, LIMES *limes ));
void	DelLime _(( LIMES **list, WORD line_number ));
void	FreeLimes _(( LIMES *list ));
