#include <stdio.h>
#include <errno.h>
#include "gchdr.h"
#include "gcio.h"

static BYTE _get_map _(( FILE *, PLAYER *, int *, int *, int , char * ));

/*
 * MAP-Datei lesen
 */
static BYTE _get_map(P(FILE *) map_datei, P(PLAYER *) player, P(int *) found,
	P(int *) new_found, P(int) check_version, P(char *) filename)
PP(FILE *map_datei;)
PP(PLAYER *player;)
PP(int *found;)
PP(int *new_found;)
PP(int check_version;)
PP(char *filename;)
{
	STATIC char r_buf[2048];
	int stardate;
	int mapsize;
	int number, x, y, status;
	PlanetList *planet;
	int insert;
	
	*found = 0;
	*new_found = 0;
	if (fgets(r_buf, (int)sizeof(r_buf), map_datei) == NULL)
		return(FEHLER_R);
	if (sscanf(r_buf, "%d", &stardate) != 1)
		return(FEHLER_F);
	if (stardate != gc_global.starDate)
	{
		if (check_version)
			return(FEHLER_V);
		if (gc_global.starDate == 0)
		{
			gc_global.starDate = stardate;
		} else {
			if (!quiet)
				fprintf(stderr, "warning: %s out of date (%d)\n", filename, stardate);
		}
	}
	if (fgets(r_buf, (int)sizeof(r_buf), map_datei) == NULL)
		return(FEHLER_R);
	if (sscanf(r_buf, "%d", &mapsize) != 1)
		return(FEHLER_F);
	if (mapsize != gc_global.maxMapSize)
		return(FEHLER_V);
	
	while (fgets(r_buf, (int)sizeof(r_buf), map_datei) != NULL)
	{
		if (sscanf(r_buf, "%d %d %d %d", &number, &x, &y, &status) != 4)
			return(FEHLER_F);
		(*found)++;
		planet = findPlanet(player, number, &insert);
		if (planet == NULL)
			return(errno);
		if (insert)
			(*new_found)++;
		planet->l_koordinate.x = x;
		planet->l_koordinate.y = y;
		planet->l_status = status;
		if (planet->l_status == STATUS_OWN)
		{
			planet->l_planetrange = regel.radius[player->pl_tech_level[FG_SPY]];
			planet->l_owner = player->pl_number;
		} else {
			planet->l_planetrange = 0;
		}
	}
	return(OK);
}


BYTE get_map(P(PLAYER *) player, P(char *) pathname, P(int) check_version)
PP(PLAYER *player;)
PP(char *pathname;)
PP(int check_version;)
{
	FILE *map_datei;
	char datei[MAX_PATHLEN];
	BYTE fehler;
	int found, new_found;
	
	/* MAP Datei einlesen */
	sprintf(datei, "%s%s", pathname, EXT_MAP);
	if ((map_datei = fopen(datei, FREAD_TEXT)) == NULL)
	{
		return(FEHLER_O);
	}

	if (verbose)
		fprintf(stderr, "reading %s ... ", datei);
	fehler = _get_map(map_datei, player, &found, &new_found, check_version, datei);
	if (verbose)
		fprintf(stderr, "found %d planets\n", found);
	f_close(map_datei);
	return(fehler);
}




