#include <stdio.h>
#include "gchdr.h"
#include "gcio.h"

#if !DEBUG_ALLOC
#define getmem malloc
#define getcmem calloc
#endif

static BYTE _get_fln _(( PLAYER *, FILE * ));

/*
 * FLN-Datei einlesen
 */
static BYTE _get_fln(P(PLAYER *) player, P(FILE *) fln_datei)
PP(PLAYER *player;)
PP(FILE *fln_datei;)
{
	UWORD s_zahl = 0, lz;
	SCHIFF *ship;
	SCHIFF **schiff;
	STATIC char r_buf[2048];
	char *p;
	
	schiff = player->pl_ships;
	while (NULL != fgets(r_buf, (int) sizeof(r_buf), fln_datei))
	{
		if (s_zahl >= MAX_SCHIFFE)
			return(FEHLER_F);
		if ((ship = NEW(SCHIFF, "_get_fln")) == NULL)
		{
			return(FEHLER_M);
		}
		schiff[s_zahl] = ship;
		
		p = r_buf;
		ship->s_number = (WORD)sgetint(&p);

		ship->s_kills = (WORD)sgetint(&p);
		ship->s_pos = (WORD)sgetint(&p);
		ship->s_ziel = (WORD)sgetint(&p);

		ship->s_typ = (UBYTE) sgetint(&p);
		ship->s_atl = (UBYTE) sgetint(&p);
		ship->s_vtl = (UBYTE) sgetint(&p);
		ship->s_reichw = (UBYTE) sgetint(&p);

		ship->s_moved = (UBYTE) sgetint(&p);
		ship->s_distance = (UBYTE) sgetint(&p);

		ship->s_tf_nr = (UBYTE) sgetint(&p);

		ship->s_cur_def = (UBYTE) sgetint(&p);
		ship->s_cur_transp = (UBYTE) sgetint(&p);

		for (lz = 0; lz < ANZ_LADUNG; lz++)
		{
			ship->s_ladung[lz] = (UBYTE) sgetint(&p);
		}

		s_zahl++;
	}
	player->pl_num_ships = s_zahl;
	return(OK);
}


BYTE get_fln(P(PLAYER *) player, P(char *) pathname)
PP(PLAYER *player;)
PP(char *pathname;)
{
	FILE *fln_datei;
	BYTE fehler;
	char datei[MAX_PATHLEN];
	
	sprintf(datei, "%s%s", pathname, EXT_FLN);

	if ((fln_datei = fopen(datei, FREAD_TEXT)) == NULL)
	{
		return(FEHLER_O);
	}
	if (verbose)
		fprintf (stderr, "reading %s ...\n", datei);
	fehler = _get_fln(player, fln_datei);
	f_close(fln_datei);
	return(fehler);
}




