#define FIRST_STARDATE 3500

typedef enum _cmd_code {
	CMD_NONE,
	CMD_MOVE_SHIP,
	CMD_MOVE_TF,
	CMD_LOAD_SHIP,
	CMD_LOAD_TF,
	CMD_SCHROTT,
	CMD_TASKFORCE,
	CMD_CHOWN,

	CMD_WERFT,
	CMD_CONS_SHIP,
	CMD_SPY,
	CMD_CORRUPT,
	CMD_FORSCH,
	CMD_PRODUCE,
	CMD_INSTALL,

	CMD_KOPFGELD
} CMD_CODE;

typedef struct _cmd {
	struct _cmd *next;
	struct _cmd *prev;
	CMD_CODE cmd_code;
	char cmd_valid;
	union {
		struct { WORD ship;   WORD planet;              } move_ship;
		struct { WORD tf;     WORD planet;              } move_tf;
		struct { WORD ship;   WORD lad;    WORD anz;    } load_ship;
		struct { WORD tf;     WORD lad;    WORD anz;    } load_tf;
		struct { WORD ship;                             } schrott;
		struct { WORD ship;   WORD tf;                  } taskforce;
		struct { WORD ship;   WORD player;              } chown;
		
		struct { WORD pl;     WORD wft;    WORD typ;    } werft;
		struct { WORD pl;     WORD wft;    WORD pe;     } cons_ship;
		struct { WORD target; WORD pe;     WORD planet; } spy;
		struct { WORD target; WORD pe;     WORD planet; } corrupt;
		struct { WORD pl;     WORD pe;     WORD kind;   } forsch;
		struct { WORD pl;     WORD kind;   WORD anz;    } produce;
		struct { WORD pl;     WORD kind;   WORD anz;    } install;
		
		struct { WORD pe;     WORD player;              } kopfgeld;
		
		struct { WORD w1;     WORD w2;     WORD w3;     } words;
	} cmd_vals;
} CMD;


extern PLAYER *me;


/*
 * allgemeine Routinen
 */

#define CMD_LIST_EMPTY() (cmd_head.next == &cmd_head)
#define FOR_ALL_CMDS(cmd) for (cmd = cmd_head.next; cmd != &cmd_head; cmd = cmd->next)

extern CMD cmd_head;
extern int cmds_have_changed;
extern WORD kosten_festung;

extern CMD *cmd_move_ship _(( SCHIFF *s, WORD dest ));
extern CMD *cmd_move_taskforce _(( WORD tf_nr, WORD dest ));
extern CMD *cmd_chown _(( SCHIFF *s, WORD pl_number ));
extern CMD *cmd_change_taskforce _(( SCHIFF *s, WORD tf ));
extern CMD *cmd_load_ship _(( SCHIFF *s, WORD diff, WORD ladung ));
extern CMD *cmd_load_taskforce _(( WORD tf_nr, WORD diff, WORD ladung ));
extern CMD *cmd_schrott _(( SCHIFF *s ));

extern CMD *cmd_spy _(( WORD target, WORD pes, PLANET *planet ));
extern CMD *cmd_corrupt _(( WORD target, WORD pes, PLANET *planet ));
extern CMD *cmd_forsch _(( PLANET *planet, WORD diff, WORD gebiet ));
extern CMD *cmd_install _(( PLANET *planet, WORD kind, WORD anz ));
extern CMD *cmd_produce _(( PLANET *planet, WORD kind, WORD anz ));
extern CMD *cmd_werft _(( PLANET *planet, WORD no, WORD typ ));
extern CMD *cmd_cons_ship _(( PLANET *planet, WORD no, WORD pe ));

extern CMD *cmd_kopfgeld _(( WORD pes, WORD pl_number ));

extern void cmd_string _(( CMD *cmd, char *command, char *comment ));
extern void cmd_recalc _(( PLAYER *player ));
extern BYTE write_bef _(( PLAYER *player, char *pathname, char *editor_name ));
extern WORD gesamt_rest _(( PLAYER *player ));
extern WORD koord_distance _(( WORD x1, WORD y1, WORD x2, WORD y2 ));
extern WORD planet_distance _(( PLANET *p1, PLANET *p2 ));
extern long cmd_count _(( void ));
extern void do_cmd _(( CMD *cmd ));
extern CMD *add_cmd _(( CMD_CODE code, WORD wort1, WORD wort2, WORD wort3 ));
extern void cmd_delete _(( CMD *cmd ));
extern void delete_all_cmds _(( PLAYER *player ));
extern void undo_last_cmd _(( void ));
extern void undo_last_ship_cmd _(( void ));
extern BYTE get_bef _(( PLAYER *player, char *pathname ));
extern FILE *bef_exists _(( char *pathname, char *gc_id, WORD *pl_number, WORD *starDate ));
extern WORD calc_techlevel _(( WORD pes ));
extern WORD count_ladung _(( SCHIFF *s ));
extern PLANET *find_pe_planet _(( PLAYER *player ));
extern void recalc_bef _(( PLAYER *player ));
extern WORD costs_of_ship _(( WFT *wft ));
extern void cons_ships _(( PLAYER *player ));



/*
 * Routinen, die die Oberflaeche bereitstellen muss
 */
extern void ship_changed _(( PLAYER *player, SCHIFF *schiff ));
extern void planet_changed _(( PLAYER *player, PLANET *planet ));
extern void cmds_changed _(( void ));
extern void err_memory _(( void ));
