/**************************************************************
 * GAMLST.C                  Copyright (C) Damian Walker 1997 *
 *------------------------------------------------------------*
 * AstroMail 1.00 - Game list module.  Header file.           *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     02-Apr-97                                         *
 **************************************************************/


#ifndef _GAMLST_H_
#define _GAMLST_H_


/* function prototypes ****************************************/


/* gamlst_clear() - clear the game list */
void gamlst_clear(void);

/* gamlst_open() - open the library */
result gamlst_open(char *path, int *line);

/* gamlst_close() - close the game list */
void gamlst_close(void);

/* gamlst_first() - select first game in list */
result gamlst_first(void);

/* gamlst_next() - select next game from list */
result gamlst_next(void);

/* gamlst_find() - attempt to find a named game */
result gamlst_find(char *name);

/* gamlst_get...() - 'get' functions */
char *gamlst_getname(char *name);
char *gamlst_getpath(char *path);

/* gamlst_set...() - 'set' functions */
char *gamlst_setname(char *name);
char *gamlst_setpath(char *path);

/* gamlst_write() - write a new game list */
result gamlst_write(char *path);

/* gamlst_new() - add a new game */
result gamlst_new(void);

/* gamlst_old() - delete an old game */
result gamlst_old(void);


/* end of include file ****************************************/


#endif
