/**********************************************************************
 * ASTROWAR.C                        Copyright (C) Damian Walker 1997 *
 *--------------------------------------------------------------------*
 * AstroWar 1.01 - main program                                       *
 *--------------------------------------------------------------------*
 * Author   Damian G Walker                                           *
 * Date     13-Apr-97 version 1.00                                    *
 *          05-Sep-97 version 1.01                                    *
 **********************************************************************/


/* included headers ***************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "astrowar.h"
#include "create.h"
#include "doturn.h"
#include "scrlog.h"


/* enumerated types ***************************************************/


typedef enum {
  S_NONE,   /* no service selected */
  S_CREATE, /* turn input selected */
  S_DOTURN, /* turn output selected */
  S_HELP,   /* program help selected */
  S_ERROR   /* error on command line */
} service;


/* global variables ***************************************************/


char pid[36] = PROGNAME;


/* level 1 routines ***************************************************/


/* astrowar_args() - parse command line */
service astrowar_args(char *path, char **argp, int argc, char **argv)
{
  int
    argi,    /* current input parameter (argv) */
    argo;    /* current output parameter (argp) */
  service s; /* service to return */
  char *env; /* pointer to environment variable */

  /* initialise */
  strcpy(path, "");
  if(( env = getenv("ASTROWAR") ) != NULL) strcpy(path, env);
  argi = 1; argo = 0; s = S_NONE;

  /* loop through parameters */
  while(argi < argc)
    {
      if( !stricmp(argv[argi], "create") && s == S_NONE )
	s = S_CREATE;
      else if( !stricmp(argv[argi], "turn") && s == S_NONE )
	s = S_DOTURN;
      else if( !stricmp(argv[argi], "?") )
	s = S_HELP;
      else if( !stricmp(argv[argi], "-path") )
        {
	  if(++argi < argc)
	    strcpy(path, argv[argi]);
	  else
	    s = S_ERROR;
        }
      else if(argo < 10)
	argp[argo++] = argv[argi];
      else s = S_ERROR;
      argi++;
    }

  /* fill rest of output parameters and return */
  while(argo < 10) argp[argo++] = NULL;
  return s;
}

/* astrowar_drop() - drop semaphore */
result astrowar_drop(char *path)
{
  char  filename[128]; /* full name of file */
  FILE *sem;           /* file handle for semaphore */

  sprintf(filename, "%sastrowar.sem", path);
  if(( sem = fopen(filename, "r") ) != NULL)
    {
      fclose(sem);
      return R_EXISTS;
    }
  if(( sem = fopen(filename, "w") ) == NULL) return R_FILE;
  fclose(sem);

  return R_OK;
}

/* astrowar_lift() - lift a semaphore */
void astrowar_lift(char *path)
{
  char filename[128]; /* full name of file */

  sprintf(filename, "%sastrowar.sem", path);
  remove(filename);
}


/* level 0 routines ***************************************************/


/* main program */
int main(int argc, char **argv)
{
  service s;       /* service requested on command line */
  char
    *argp[10],     /* process-specific parameters */
    path[72];      /* path to configs, semaphores etc. */
  result r = R_OK; /* returned to calling process */

  scrlog_open();
  s = astrowar_args(path, argp, argc, argv);
  if(( r = astrowar_drop(path) ) == R_OK)
    {
      switch(s)
        {
	case S_CREATE:
	  r = create_main(path, argp);
	  break;
	case S_DOTURN:
	  r = doturn_main(path, argp);
	  break;
	case S_ERROR: case S_NONE:
	  r = R_BADCMD;
	  scrlog_error();
	  break;
	default:
	  r = R_OK;
	  scrlog_help();
        }
      astrowar_lift(path);
    }
  scrlog_close();

  return r;
}
