/**********************************************************************
 * SCRLOG.H                          Copyright (C) Damian Walker 1997 *
 *--------------------------------------------------------------------*
 * AstroWar 1.00 - Screen and Log Output Module.  Header file.        *
 *--------------------------------------------------------------------*
 * Author   Damian G Walker                                           *
 * Date     09-Apr-97                                                 *
 **********************************************************************/


#ifndef _SCRLOG_H_
#define _SCRLOG_H_


/* function prototypes ************************************************/


/* scrlog_open() - open screen and log */
result scrlog_open(void);

/* scrlog_openlog() - open the log file */
result scrlog_openlog(char *filename, short status);

/* scrlog_close() - close the library */
void scrlog_close(void);

/* void scrlog_cannotopenlog() - cannot open the log file */
void scrlog_cannotopenlog(char *filename);

/* scrlog_error() - command line error */
void scrlog_error(void);

/* scrlog_running() - program already running */
void scrlog_running(void);

/* scrlog_help() - program help output */
void scrlog_help(void);

/* scrlog_create() - running turn input module */
void scrlog_create(void);

/* scrlog_doturn() - running turn output module */
void scrlog_doturn(void);

/* scrlog_outofmemory() - general out of memory error */
void scrlog_outofmemory(char *act);

/* scrlog_badreturncode() - unexpected result code from function */
void scrlog_badreturncode(result r, char *function);

/* scrlog_finished() - finished */
void scrlog_finished(void);

/* scrlog_planetsdone() - done! */
void scrlog_done(void);

/* scrlog_badcommandinconfig() - bad command in config file */
void scrlog_badcommandinconfig(char *path, int line);

/* scrlog_cannotreadconfig() - file error opening config */
void scrlog_cannotreadconfig(char *path);

/* scrlog_cannotwriteconfig() - file error creating config */
void scrlog_cannotwriteconfig(char *path);

/* scrlog_configread() - config read successfully */
void scrlog_configread(char *path);

/* scrlog_cannotopendetail() - cannot read detail file */
void scrlog_cannotopendetail(char *path);

/* scrlog_badcommandindetail() - bad command in detail file */
void scrlog_badcommandindetail(char *path);

/* scrlog_detailread() - detail file read successfully */
void scrlog_detailread(char *path);

/* scrlog_cannotopengamelist() - error opening game list */
void scrlog_cannotopengamelist(char *path);

/* scrlog_badfileingamelist() - bad command in game list */
void scrlog_badfileingamelist(char *path, int line);

/* scrlog_badlineingamelist() - bad command in game list */
void scrlog_badlineingamelist(char *path, int line);

/* scrlog_gamelistread() - game list read successfully */
void scrlog_gamelistread(char *path);

/* scrlog_gamelistempty() - game list empty */
void scrlog_gamelistempty(char *path);

/* scrlog_gamenotfound() - game not found */
void scrlog_gamenotfound(char *gamename);

/* scrlog_cannotwritegamelist() - cannot write game list */
void scrlog_cannotwritegamelist(char *path);

/* scrlog_cannotopenfile() - cannot open file.* */
void scrlog_cannotopenfile(char *path, char *file);

/* scrlog_badheaderinfile() - bad header in file.* */
void scrlog_badheaderinfile(char *path, char *file);

/* scrlog_fileopened() - join request file opened */
void scrlog_fileopened(char *path, char *file);

/* scrlog_fileexists() - join request file exists */
void scrlog_fileexists(char *path, char *file);

/* scrlog_cannotcreatefile() - cannot create join request file */
void scrlog_cannotcreatefile(char *path, char *file);

/* scrlog_filecreated() - join request file created */
void scrlog_filecreated(char *path, char *file);

/* scrlog_creatingplanet() - creating planet ... */
void scrlog_creatingplanet(long curr, long planets);

/* scrlog_planetsdone() - planets created */
void scrlog_planetsdone(long planets);

/* scrlog_movingfleet() - moving fleet ... */
void scrlog_movingfleet(long fleetno);

/* scrlog_fleetsdone() - fleets moved */
void scrlog_fleetsdone(void);

/* scrlog_processingorder() - processing ... order ... */
void scrlog_processingorder(char type);

/* scrlog_ordersdone() - processed all orders */
void scrlog_ordersdone(void);

/* scrlog_processingplanet() - moving fleet ... */
void scrlog_processingplanet(char *name);

/* scrlog_proddone() - prod moved */
void scrlog_productiondone(void);

/* scrlog_checkingvictory() - checking victory */
void scrlog_checkingvictory(void);

/* scrlog_victory() - victory for ... */
void scrlog_victory(char *vname);

/* scrlog_novictory() - victory for ... */
void scrlog_novictory(void);


#endif
