/**********************************************************************
 * STRICMP.C                            Copyright (C) Damian G Walker *
 *--------------------------------------------------------------------*
 * Implementation of stricmp() for Centurion programs ported to ANSI. *
 *--------------------------------------------------------------------*
 * Author   Damian G Walker                                           *
 * Date     06-May-97                                                 *
 **********************************************************************/

/* stricmp() - case insensitive string compare */
int stricmp(char *s1, char *s2)
{
    char *p1 = s1, *p2 = s2;
    int   r = *p2 - *p1;

    while( (*p1 && *p2) && !r ) r = *++p2 - *++p1;
    return r;
}

/* strnicmp() - size limited case insensitive string compare */
int strnicmp(char *s1, char *s2, int num)
{
    char *p1 = s1, *p2 = s2;
    int   r = *p2 - *p1;

    while( (*p1 && *p2) && !r && num--) r = *++p2 - *++p1;
    return r;
}
