/**********************************************************************
 * IOMSG.H                           Copyright (C) Damian Walker 1997 *
 *--------------------------------------------------------------------*
 * AstroMail 1.00 - input message processing via MSGLIB.              *
 *--------------------------------------------------------------------*
 * Author   Damian G Walker                                           *
 * Date     09-Apr-97                                                 *
 **********************************************************************/


#ifndef _IOMSG_H_
#define _IOMSG_H_


/* other included headers *********************************************/


#include "astroml.h" /* for 'fido' and 'result' definitions */


/* function prototypes ************************************************/


/* iomsg_open() - open the netmail area */
result iomsg_open(void);

/* iomsg_close() - close the netmail area */
result iomsg_close(void);

/* iomsg_first() - find the first message to AstroMail */
result iomsg_first(void);

/* iomsg_next() - find the next message to AstroMail */
result iomsg_next(void);

/* iomsg_get...() - return stuff about message */
char *iomsg_getfromname(char *fromname);
char *iomsg_getgame(char *game);
fido iomsg_getfromaddr(void);
fido iomsg_gettoaddr(void);

/* iomsg_firstline() - first line of message text */
char *iomsg_firstline(void);

/* iomsg_nextline() - next line of message text */
char *iomsg_nextline(void);

/* iomsg_post() - post an outgoing message */
result iomsg_post(fido fromaddr, char *toname, fido toaddr,
    char *subject, int attr, char *text);

/* iomsg_recd() - mark read message as received */
result iomsg_rcvd(void);


#endif
