/**********************************************************************
 * TEXTFL.C                          Copyright (C) Damian Walker 1997 *
 *--------------------------------------------------------------------*
 * Announce 1.00 - Text file input module                             *
 *--------------------------------------------------------------------*
 * Author  Damian G Walker                                            *
 * Date    02-Sep-97                                                  *
 **********************************************************************/


/* included headers ***************************************************/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "announce.h"


/* level 0 routines ***************************************************/


/* textfl_read() - read a named text file and convert line ends */
char *textfl_read(char *filename)
{
  FILE
    *textfile; /* file handly for text file */
  char
    *text,     /* full text of message */
    *eol;      /* end of line marker */
  long
    pos;       /* position of end of file & length of text */

  /* open file */
  if(!( textfile = fopen(filename, "r") ))
    return NULL;

  /* reserve memory for text */
  fseek(textfile, 0, SEEK_END);
  pos = ftell(textfile);
  text = calloc( 1, pos + 1 );
  if(!text)
    {
      fclose(textfile);
      return NULL;
    }

  /* read text */
  fseek(textfile, 0, SEEK_SET);
  fread(text, pos, 1, textfile);

  /* convert line ends */
  while(( eol = strchr(text, '\n') ))
    *eol = '\r';

  /* close and return */
  fclose(textfile);
  return text;
}

/* textfl_old() - free memory from old text */
void textfl_old(char *text)
{
  free(text);
}
