/**************************************************************
 * CONFIG.C                  Copyright (C) Damian Walker 1997 *
 *------------------------------------------------------------*
 * AstroWar 1.00 - configuration file maintenance             *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     28-Mar-97                                         *
 **************************************************************/


/* included headers *******************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "astrowar.h"


/* structures *************************************************/


typedef struct {
    char logfile[72]; /* name of log file */
} config;


/* global variables ***************************************************/


extern char pid[36]; /* program ID */
config config_rec;   /* configuration record */


/* level 1 routines ***************************************************/


/* config_intlogfile() - interpret 'log file' config item */
void config_intlogfile(void)
{
    char *tok; /* log filename token */

    tok = strtok(NULL, "\n");
    if( strlen(tok) > 71 )
    {
        strncpy(config_rec.logfile, tok, 71);
        config_rec.logfile[71] = '\0';
    }
    else strcpy(config_rec.logfile, tok);
}


/* level 0 routines ***************************************************/


/* config_open() - intialise the library */
result config_open(char *path)
{
    sprintf(config_rec.logfile, "%sastrowar.log", path);
    return R_OK;
}

/* config_close() - clean up and close */
void config_close(void)
{
}

/* config_read() - open (and read) the configuration file */
result config_read(char *path, int *line)
{
    char      filename[128]; /* full filename of config file */
    FILE     *config_file;   /* config file handle */
    char      buf[1024],     /* buffer for line input */
             *tok;           /* pointer to token in buf */

    /* attempt to open configuration file */
    sprintf(filename, "%sastrowar.data", path);
    if(( config_file = fopen(filename, "r") ) == NULL )
        return R_FILE;

    /* read and interpret config lines */
    *line = 0;
    while( fgets(buf, 1023, config_file) )
    {
        ++*line;
        if(*buf != '\n' && *buf != ';' && *buf != '\0')
        {
            if( strchr(buf, '\n') == NULL ) strcat(buf, "\n");
            tok = strtok(buf, " \n");
            if( !stricmp(tok, "logfile") )
                config_intlogfile();
            else
            {
                fclose(config_file);
                return R_BADCMD;
            }
        }
    }

    /* close and clean up */
    fclose(config_file);
    return R_OK;
}

/* config_write() - write the config to a file */
result config_write(char *path)
{
    char      filename[128]; /* full filename of config file */
    FILE     *config_file;   /* config file handle */

    /* attempt to open configuration file */
    sprintf(filename, "%sastrowar.data", path);
    if(( config_file = fopen(filename, "w") ) == NULL )
        return R_FILE;

    /* output title */
    fprintf(config_file,
        ";   AstroWar Configuration File %sastrowar.data\n"
        ";   automatically generated by %s\n", path, pid);

    /* output logfile name */
    fprintf(config_file,
        "\n; logfile <logname>\n"
          ";   sets the log output file to <logname>.  "
              "No trailing slash, please.");
    fprintf(config_file, "\nlogfile %s\n", config_rec.logfile);

    /* close file */
    fclose(config_file);
    return R_OK;
}

/* config_set...() - set field values */
char *config_setlogfile(char *logfile)
    { return strcpy(config_rec.logfile, logfile); }

/* config_get...() - get field values */
char *config_getlogfile(char *logfile)
    { return strcpy(logfile, config_rec.logfile); }
