/***********************************************************
        Copyright 1991 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#ifndef _PREFERENCETYPES_H
#define _PREFERENCETYPES_H

static char PreferenceTypes_rcs_idH[]= "$Header: /afs/andrew.cmu.edu/system/src/local/depot/016/RCS/PreferenceTypes.h,v 4.2 1992/02/12 18:05:04 ww0r Exp $";

/*
 * Author: Sohan C. Ramakrishna Pillai
 */



#define PREF_UNKNOWN	0
#define PREF_INT	1
#define PREF_UNSIGNED	2
#define PREF_BOOLEAN	3
#define PREF_STRING	4
#define PREF_STRINGARRAY 5

#define PREFDEFAULT_INT		0
#define PREFDEFAULT_UNSIGNED	0
#define PREFDEFAULT_BOOLEAN	FALSE
#define PREFDEFAULT_STRING	NULL
#define PREFDEFAULT_STRINGARRAY NULL

static struct PrefTypePair
{
  char *prefname;
  unsigned preftype;
} PrefTypeList[] =
{
/* Test for unsigned resources
  { "unsignedtypetest",	PREF_UNSIGNED },
 */
  /* resources for collections */
  { "deleteunreferenced",	PREF_BOOLEAN },
  { "ignore",		PREF_STRINGARRAY },
  { "mapcommand",	PREF_STRING },
  { "override",		PREF_STRINGARRAY },
  { "path",		PREF_STRING },
  { "searchpath",	PREF_STRINGARRAY },
  { "specialfile",	PREF_STRINGARRAY },
  { "usemodtimes",	PREF_BOOLEAN },
  { "version",		PREF_INT },
  { "versiondelimiter",	PREF_STRING },	/* actually char stored as string */

  /* specification of a command to be executed */
  { "command",		PREF_STRING },
};

static unsigned NPrefTypes = sizeof(PrefTypeList)/sizeof(PrefTypeList[0]);

static unsigned PreferenceType();

/*
 * $Log: PreferenceTypes.h,v $
 * Revision 4.2  1992/02/12  18:05:04  ww0r
 * make RCS headers visibile
 * added protection against double includes
 *
 * Revision 4.1  1991/10/08  21:52:57  dl2n
 * add CMU copyright
 *
 * Revision 4.0  1991/09/25  17:36:33  sohan
 * Release 4
 *
 * Revision 4.0  1991/09/25  16:08:52  sohan
 * Version 4.0
 *
 */
#endif /* _PREFERENCETYPES_H */
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot/016/RCS/PreferenceTypes.h,v $ */
