/******************************************************************************
 *                                                                            *
 * File:   transtab.c         Version  1.12            Date: 1997-05-01       *
 *                                                                            *
 * Copyright (C) 1993-1997 by kostis@acm.org (Kosta Kostis)                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - this program creates an 8-bit translation table using two         *
 *          character encoding description files with ISO 10646 mnemonics     *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *     1997-05-01: KK V1.12                                                   *
 *        - new release of the package                                        *
 *     1996-06-01: KK V1.11                                                   *
 *        - minor changes, including my email address                         *
 *     1995-07-01: KK V1.10                                                   *
 *        - minor changes, including my email address                         *
 *     1994-03-31: KK V1.00                                                   *
 *        - more 16-bit support for ISO 10646                                 *
 *     1994-03-04: KK V0.97                                                   *
 *        - new release of the package                                        *
 *     1994-01-18: KK V0.96                                                   *
 *        - added -c, -b and -n switch                                        *
 *        - added binary table generation                                     *
 *     1993-12-22: KK V0.95                                                   *
 *        - added -d switch (for debugging)                                   *
 *        - fixed bug when reading line with code only in ReadCodeTable ()    *
 *        - less memory allocated in ReadCodeTable ()                         *
 *        - splitted transtab.c into many small files                         *
 *        - renamed some internal functions                                   *
 *     1993-11-14: KK V0.94                                                   *
 *        - cosmetic changes                                                  *
 *     1993-10-15: KK V0.93                                                   *
 *        - prepared for future use                                           *
 *     1993-07-25: KK V0.91                                                   *
 *        - added ScanFlags () and -t switch                                  *
 *     1993-07-05: KK V0.90                                                   *
 *        - cosmetic changes                                                  *
 *     1993-05-25: KK V0.82                                                   *
 *        - dropped support for K&R C                                         *
 *        - improved ReadCodeTable ()                                         *
 *     1993-05-18: KK V0.81                                                   *
 *        - moved OS and compiler dependent definitions into "os-stuff.h"     *
 *     1993-05-10: KK V0.80                                                   *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>

/******************************************************************************

	General Program Definitions

 *****************************************************************************/

#include "transtab.h"
#include "taberr.h"
#include "tab.h"

/******************************************************************************

	String Support Functions

 *****************************************************************************/

#ifdef	NO_STRDUP
	#include "strdup.c"
#endif

#ifdef	NO_STRUPR
	#include "strupr.c"
#endif

/******************************************************************************

	Character Encoding Description Table Functions

 *****************************************************************************/

#include "readtab.h"

/******************************************************************************

	Character Encoding Translation Table and Output Functions

 *****************************************************************************/

#include "comptran.h"

/******************************************************************************

	Program Parameter Parsing Functions

 *****************************************************************************/

#include "scanflag.h"

/******************************************************************************

	Function:
		display copyright, author and program information

	Parameters:
		none

	Returns:
		nothing

 *****************************************************************************/

void	Hello (void)
{
	fprintf (stderr, MSG_COPYRIGHT) ;
	fprintf (stderr, MSG_VERSION, PRGNAM, VERSION) ;
}

/*****************************************************************************/

int     main
(
	int	argc,
	char	*argv		[]
)
{
	int	rc ;
	char	*SrcTable	[MAX_TABLE_ENTRIES] ;
	char	*DstTable	[MAX_TABLE_ENTRIES] ;
	char	SrcName		[MAX_ENC_NAME_LENGTH + 1] ;
	char	DstName		[MAX_ENC_NAME_LENGTH + 1] ;
	char	*SrcComment	[MAX_COMMENTS] ;
	char	*DstComment	[MAX_COMMENTS] ;
	ushort	Result		[MAX_TABLE_ENTRIES] ;

	Hello () ;

	/**********************************************************************

		parse parameters/arguments

	 *********************************************************************/

	rc = ScanFlags (argc, argv) ;
	if (rc != SCN_OK)
	{
		/**************************************************************

			display syntax error message and quit

		 *************************************************************/

		fprintf (stderr, ERR_MSG_SYNTAX, PRGNAM) ;
		return (ERR_SYNTAX) ;
	}

	/**********************************************************************

		try to read character encoding description files

	 *********************************************************************/

	rc = ReadCodeTable (SrcFile, SrcTable, (ushort *) NULL,
		MAX_TABLE_ENTRIES, SrcName, SrcComment) ;
	if (rc != ERR_NONE)
		return (rc) ;

	rc = ReadCodeTable (DstFile, DstTable, (ushort *) NULL,
		MAX_TABLE_ENTRIES, DstName, DstComment) ;
	if (rc != ERR_NONE)
		return (rc) ;

	/**********************************************************************

		create translation table

	 *********************************************************************/

	if (TransMake != TRANS_MAKE_NOTHING)
	{
		TransTable (SrcTable, MAX_TABLE_ENTRIES, DstTable,
			MAX_TABLE_ENTRIES, (ushort *) NULL, Result) ;
		fprintf (stdout,
			MSG_CREATE, PRGNAM, TabFile, SrcFile, DstFile) ;
	}

	DumpProg (SrcTable, DstTable, (ushort *) NULL, TabFile,
		Result, MAX_TABLE_ENTRIES,
		SrcName, DstName, SrcComment, DstComment, TransMake) ;

	if (TableDump)
	{
		DumpCodeTable (stdout, SrcFile,
			SrcTable, (ushort *) NULL, MAX_TABLE_ENTRIES) ;
		DumpCodeTable (stdout, DstFile,
			DstTable, (ushort *) NULL, MAX_TABLE_ENTRIES) ;
	}

	/**********************************************************************

		free memory allocated by ReadCodeTable () and quit

	 *********************************************************************/

	FreeCodeTable (SrcTable, MAX_TABLE_ENTRIES) ;
	FreeCodeTable (DstTable, MAX_TABLE_ENTRIES) ;

	return (ERR_NONE) ;
}
